/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.api.locks;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.INBTSerializable;
import pl.asie.charset.api.lib.ICacheable;
import pl.asie.charset.api.locks.ILockingEntity;

public final class Lockable
implements ICacheable,
INBTSerializable<NBTTagCompound> {
    private final TileEntity owner;
    private ILockingEntity lock;

    public Lockable() {
        this(null);
    }

    public Lockable(TileEntity owner) {
        this.owner = owner;
    }

    public ILockingEntity getLock() {
        if (this.lock != null && !this.lock.isLockValid(null)) {
            this.lock = null;
        }
        return this.lock;
    }

    public boolean hasLock() {
        return this.getLock() != null;
    }

    public boolean addLock(ILockingEntity lock) {
        if (this.getLock() == null) {
            this.lock = lock;
            return true;
        }
        return false;
    }

    public boolean removeLock(ILockingEntity lock) {
        if (this.hasLock() && this.getLock() == lock) {
            this.lock = null;
            return true;
        }
        return false;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.hasLock()) {
            compound.setInteger("lockId", this.lock.getLockEntityId());
        }
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        Entity entity;
        this.lock = null;
        if (nbt.hasKey("lockId", 99) && this.owner.getWorld() != null) {
            Entity entity2 = this.owner.getWorld().getEntityByID(nbt.getInteger("lockId"));
            if (entity2 instanceof ILockingEntity) {
                this.lock = (ILockingEntity)entity2;
            }
        } else if (nbt.hasKey("lockILockingEntityId", 99) && this.owner.getWorld() != null && (entity = this.owner.getWorld().getEntityByID(nbt.getInteger("lockILockingEntityId"))) instanceof ILockingEntity) {
            this.lock = (ILockingEntity)entity;
        }
    }

    @Override
    public boolean isCacheValid() {
        return !this.owner.isInvalid();
    }
}

