/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableCache;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.util.BlockCoord;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public interface IConduit {
    public Class<? extends IConduit> getBaseConduitType();

    public ItemStack createItem();

    public List<ItemStack> getDrops();

    public int getLightValue();

    public boolean isActive();

    public void setActive(boolean var1);

    public void writeToNBT(NBTTagCompound var1);

    public void readFromNBT(NBTTagCompound var1, short var2);

    public void setBundle(IConduitBundle var1);

    public IConduitBundle getBundle();

    public void onAddedToBundle();

    public void onRemovedFromBundle();

    public BlockCoord getLocation();

    public boolean hasConnections();

    public boolean hasExternalConnections();

    public boolean hasConduitConnections();

    public boolean canConnectToConduit(ForgeDirection var1, IConduit var2);

    public Set<ForgeDirection> getConduitConnections();

    public boolean containsConduitConnection(ForgeDirection var1);

    public void conduitConnectionAdded(ForgeDirection var1);

    public void conduitConnectionRemoved(ForgeDirection var1);

    public AbstractConduitNetwork<?, ?> getNetwork();

    public boolean setNetwork(AbstractConduitNetwork<?, ?> var1);

    public boolean canConnectToExternal(ForgeDirection var1, boolean var2);

    public Set<ForgeDirection> getExternalConnections();

    public boolean containsExternalConnection(ForgeDirection var1);

    public void externalConnectionAdded(ForgeDirection var1);

    public void externalConnectionRemoved(ForgeDirection var1);

    public boolean isConnectedTo(ForgeDirection var1);

    public ConnectionMode getConnectionMode(ForgeDirection var1);

    public void setConnectionMode(ForgeDirection var1, ConnectionMode var2);

    public boolean hasConnectionMode(ConnectionMode var1);

    public ConnectionMode getNextConnectionMode(ForgeDirection var1);

    public ConnectionMode getPreviousConnectionMode(ForgeDirection var1);

    public IIcon getTextureForState(CollidableComponent var1);

    public IIcon getTransmitionTextureForState(CollidableComponent var1);

    public float getTransmitionGeometryScale();

    public float getSelfIlluminationForState(CollidableComponent var1);

    public boolean haveCollidablesChangedSinceLastCall();

    public Collection<CollidableComponent> getCollidableComponents();

    public Collection<CollidableComponent> createCollidables(CollidableCache.CacheKey var1);

    public Class<? extends IConduit> getCollidableType();

    public boolean onBlockActivated(EntityPlayer var1, RaytraceResult var2, List<RaytraceResult> var3);

    public void onChunkUnload(World var1);

    public void updateEntity(World var1);

    public boolean onNeighborBlockChange(Block var1);

    public boolean onNeighborChange(IBlockAccess var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public boolean writeConnectionSettingsToNBT(ForgeDirection var1, NBTTagCompound var2);

    public boolean readConduitSettingsFromNBT(ForgeDirection var1, NBTTagCompound var2);
}

