/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.facade;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.machine.painter.IPaintedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockConduitFacade
extends Block
implements IPaintedBlock {
    private Block blockOverride;

    public static BlockConduitFacade create() {
        BlockConduitFacade result = new BlockConduitFacade();
        result.init();
        return result;
    }

    private BlockConduitFacade() {
        super(new Material(MapColor.field_151665_m));
        this.func_149711_c(0.5f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149663_c(ModObject.blockConduitFacade.unlocalisedName);
        this.func_149647_a(null);
    }

    private void init() {
        GameRegistry.registerBlock((Block)this, (String)ModObject.blockConduitFacade.unlocalisedName);
    }

    public void func_149651_a(IIconRegister IIconRegister2) {
        this.field_149761_L = IIconRegister2.func_94245_a("enderio:conduitFacade");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess ba, int x, int y, int z, int side) {
        TileEntity te = ba.func_147438_o(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return this.field_149761_L;
        }
        IConduitBundle cb = (IConduitBundle)te;
        Block block = cb.getFacadeId();
        if (block != null) {
            int meta = cb.getFacadeMetadata();
            return block.func_149691_a(side, meta);
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        if (this.blockOverride != null) {
            return this.blockOverride.func_149691_a(par1, par2);
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        if (this.blockOverride != null) {
            return this.blockOverride.func_149635_D();
        }
        return super.func_149635_D();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        if (this.blockOverride != null) {
            try {
                return this.blockOverride.func_149720_d(par1IBlockAccess, par2, par3, par4);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return super.func_149720_d(par1IBlockAccess, par2, par3, par4);
    }

    public Block getIconOverrideBlock() {
        return this.blockOverride;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int par1) {
        if (this.blockOverride != null) {
            return this.blockOverride.func_149741_i(par1);
        }
        return super.func_149741_i(par1);
    }

    public void setBlockOverride(IConduitBundle cb) {
        if (cb == null) {
            this.blockOverride = null;
            return;
        }
        Block block = cb.getFacadeId();
        int meta = cb.getFacadeMetadata();
        if (block == null || block == this) {
            return;
        }
        this.blockOverride = block;
    }

    public int func_149643_k(World par1World, int x, int y, int z) {
        Mimic m = this.getMimic((IBlockAccess)par1World, x, y, z);
        if (m != null) {
            return m.meta;
        }
        return 0;
    }

    private Mimic getMimic(IBlockAccess ba, int x, int y, int z) {
        TileEntity te = ba.func_147438_o(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return null;
        }
        IConduitBundle cb = (IConduitBundle)te;
        Block id = cb.getFacadeId();
        int meta = cb.getFacadeMetadata();
        if (id == null) {
            return null;
        }
        return new Mimic(id, meta);
    }

    class Mimic {
        int meta;
        Block block;

        private Mimic(Block block, int meta) {
            this.block = block;
            this.meta = meta;
        }
    }
}

