/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.gui.BaseSettingsPanel;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.PacketFluidFilter;
import crazypants.enderio.conduit.liquid.EnderLiquidConduit;
import crazypants.enderio.conduit.liquid.FluidFilter;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.packet.PacketExtractMode;
import crazypants.enderio.gui.ColorButton;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.RedstoneModeButton;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.network.PacketHandler;
import crazypants.gui.GuiToolTip;
import crazypants.gui.IGuiScreen;
import crazypants.render.ColorUtil;
import crazypants.render.RenderUtil;
import crazypants.util.DyeColor;
import crazypants.util.Lang;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public class LiquidSettings
extends BaseSettingsPanel {
    static final int ID_REDSTONE_BUTTON = GuiExternalConnection.nextButtonId();
    private static final int ID_COLOR_BUTTON = GuiExternalConnection.nextButtonId();
    private RedstoneModeButton rsB;
    private ColorButton colorB;
    private String autoExtractStr = Lang.localize("gui.conduit.fluid.autoExtract");
    private String filterStr = Lang.localize("gui.conduit.fluid.filter");
    private ILiquidConduit conduit;
    private EnderLiquidConduit eConduit;
    private boolean isEnder;
    private int filterX = 59;
    private int filterY = 63;
    private Rectangle filterBounds = new Rectangle(this.filterX, this.filterY, 90, 18);
    private GuiToolTip[] filterToolTips;

    protected LiquidSettings(final GuiExternalConnection gui, IConduit con) {
        super(IconEIO.WRENCH_OVERLAY_FLUID, Lang.localize("itemLiquidConduit.name"), gui, con);
        this.conduit = (ILiquidConduit)con;
        if (con instanceof EnderLiquidConduit) {
            this.eConduit = (EnderLiquidConduit)con;
            this.isEnder = true;
            if (this.isFilterVisible()) {
                gui.getContainer().setInventorySlotsVisible(true);
            }
            this.addFilterTooltips();
        } else {
            this.isEnder = false;
            gui.getContainer().setInventorySlotsVisible(false);
        }
        int x = this.gap + gui.getFontRenderer().func_78256_a(this.autoExtractStr) + this.gap * 2;
        int y = this.customTop;
        this.rsB = new RedstoneModeButton((IGuiScreen)gui, ID_REDSTONE_BUTTON, x, y, new IRedstoneModeControlable(){

            @Override
            public void setRedstoneControlMode(RedstoneControlMode mode) {
                RedstoneControlMode curMode = this.getRedstoneControlMode();
                LiquidSettings.this.conduit.setExtractionRedstoneMode(mode, gui.getDir());
                if (curMode != mode) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(LiquidSettings.this.conduit, gui.getDir()));
                }
            }

            @Override
            public RedstoneControlMode getRedstoneControlMode() {
                return LiquidSettings.this.conduit.getExtractionRedstoneMode(gui.getDir());
            }
        });
        this.colorB = new ColorButton(gui, ID_COLOR_BUTTON, x += this.rsB.getWidth() + this.gap, y);
        this.colorB.setToolTipHeading(Lang.localize("gui.conduit.redstone.signalColor"));
        this.colorB.setColorIndex(this.conduit.getExtractionSignalColor(gui.getDir()).ordinal());
    }

    private void addFilterTooltips() {
        this.filterToolTips = new GuiToolTip[5];
        for (int i = 0; i < 5; ++i) {
            Rectangle bound = new Rectangle(this.filterX + i * 18, this.filterY, 18, 18);
            this.filterToolTips[i] = new FilterToolTip(bound, i);
            this.gui.addToolTip(this.filterToolTips[i]);
        }
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        super.actionPerformed(guiButton);
        if (guiButton.field_146127_k == ID_COLOR_BUTTON) {
            this.conduit.setExtractionSignalColor(this.gui.getDir(), DyeColor.values()[this.colorB.getColorIndex()]);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(this.conduit, this.gui.getDir()));
        }
    }

    @Override
    protected void connectionModeChanged(ConnectionMode conectionMode) {
        super.connectionModeChanged(conectionMode);
        if (conectionMode == ConnectionMode.INPUT) {
            this.rsB.onGuiInit();
            this.colorB.onGuiInit();
        } else {
            this.rsB.detach();
            this.colorB.detach();
        }
        if (this.isEnder && this.isFilterVisible()) {
            this.gui.getContainer().setInventorySlotsVisible(true);
        } else {
            this.gui.getContainer().setInventorySlotsVisible(false);
        }
    }

    @Override
    public void mouseClicked(int x, int y, int par3) {
        if (!this.isFilterVisible()) {
            return;
        }
        ItemStack st = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        FluidFilter filter = this.eConduit.getFilter(this.gui.getDir(), this.isInput());
        if (filter == null && st == null) {
            return;
        }
        if (filter == null) {
            filter = new FluidFilter();
        }
        if (this.filterBounds.contains(x, y)) {
            int slot = (x - this.filterX) / 18;
            filter.setFluid(slot, st);
        }
        this.eConduit.setFilter(this.gui.getDir(), filter, this.isInput());
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFluidFilter(this.eConduit, this.gui.getDir(), filter, this.isInput()));
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.rsB.setToolTip(null);
        this.colorB.setToolTip(null);
        if (this.isEnder) {
            this.gui.getContainer().setInventorySlotsVisible(false);
            for (GuiToolTip tt : this.filterToolTips) {
                if (tt == null) continue;
                this.gui.removeToolTip(tt);
            }
        }
    }

    @Override
    protected void renderCustomOptions(int top, float par1, int par2, int par3) {
        boolean isInput = this.isInput();
        if (isInput) {
            int x = this.gui.getGuiLeft() + this.gap + this.gui.getFontRenderer().func_78256_a(this.autoExtractStr) + this.gap + 2;
            int y = this.customTop;
            this.gui.getFontRenderer().func_78276_b(this.autoExtractStr, this.left, top, ColorUtil.getRGB(Color.DARK_GRAY));
        }
        if (this.isEnder && this.isFilterVisible()) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.bindTexture("enderio:textures/gui/itemFilter.png");
            this.gui.func_73729_b(this.gui.getGuiLeft(), this.gui.getGuiTop() + 55, 0, 55, this.gui.getXSize(), 145);
            FontRenderer fr = this.gui.getFontRenderer();
            int sw = fr.func_78256_a(this.filterStr);
            int x = this.gui.field_146294_l / 2 - sw / 2;
            int y = top + 20;
            fr.func_78276_b(this.filterStr, x, y, ColorUtil.getRGB(Color.DARK_GRAY));
            x = this.gui.getGuiLeft() + this.filterX;
            y = this.gui.getGuiTop() + this.filterY;
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.bindTexture("enderio:textures/gui/externalConduitConnection.png");
            this.gui.func_73729_b(x, y, 24, 238, 90, 18);
            FluidFilter filter = this.eConduit.getFilter(this.gui.getDir(), isInput);
            if (filter != null && !filter.isEmpty()) {
                for (int i = 0; i < filter.size(); ++i) {
                    Fluid f = filter.getFluidAt(i);
                    if (f == null) continue;
                    this.renderFluid(f, x + i * 18, y);
                }
            }
        }
    }

    private void renderFluid(Fluid f, int x, int y) {
        IIcon icon = f.getIcon();
        if (icon != null) {
            RenderUtil.bindBlockTexture();
            this.gui.func_94065_a(x + 1, y + 1, icon, 16, 16);
        }
    }

    private boolean isInput() {
        return this.conduit.getConnectionMode(this.gui.getDir()) == ConnectionMode.INPUT;
    }

    private boolean isFilterVisible() {
        if (!this.isEnder) {
            return false;
        }
        ConnectionMode mode = this.conduit.getConnectionMode(this.gui.getDir());
        return mode == ConnectionMode.INPUT || mode == ConnectionMode.OUTPUT;
    }

    private class FilterToolTip
    extends GuiToolTip {
        int index;

        public FilterToolTip(Rectangle bounds, int index) {
            super(bounds, (String[])null);
            this.index = index;
        }

        @Override
        public List<String> getToolTipText() {
            if (!LiquidSettings.this.isFilterVisible()) {
                return null;
            }
            FluidFilter filter = LiquidSettings.this.eConduit.getFilter(LiquidSettings.this.gui.getDir(), LiquidSettings.this.isInput());
            if (filter == null) {
                return null;
            }
            if (filter.getFluidAt(this.index) == null) {
                return null;
            }
            return Collections.singletonList(filter.getFluidAt(this.index).getLocalizedName());
        }
    }
}

