/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui.item;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.filter.ItemFilter;
import crazypants.enderio.conduit.packet.PacketItemConduitFilter;
import crazypants.enderio.gui.IconButtonEIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.ToggleButtonEIO;
import crazypants.enderio.network.PacketHandler;
import crazypants.render.RenderUtil;
import crazypants.util.Lang;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class BasicItemFilterGui
implements IItemFilterGui {
    private static final int ID_WHITELIST = GuiExternalConnection.nextButtonId();
    private static final int ID_NBT = GuiExternalConnection.nextButtonId();
    private static final int ID_META = GuiExternalConnection.nextButtonId();
    private static final int ID_ORE_DICT = GuiExternalConnection.nextButtonId();
    private static final int ID_STICKY = GuiExternalConnection.nextButtonId();
    private IItemConduit itemConduit;
    private GuiExternalConnection gui;
    private ToggleButtonEIO useMetaB;
    private ToggleButtonEIO useNbtB;
    private IconButtonEIO whiteListB;
    private ToggleButtonEIO useOreDictB;
    private ToggleButtonEIO stickyB;
    boolean isAdvanced;
    boolean isInput;
    private ItemFilter filter;

    public BasicItemFilterGui(GuiExternalConnection gui, IItemConduit itemConduit, boolean isInput) {
        int butLeft;
        this.gui = gui;
        this.itemConduit = itemConduit;
        this.isInput = isInput;
        this.filter = isInput ? (ItemFilter)itemConduit.getInputFilter(gui.getDir()) : (ItemFilter)itemConduit.getOutputFilter(gui.getDir());
        this.isAdvanced = this.filter.isAdvanced();
        int x = butLeft = 124;
        int y = 68;
        this.whiteListB = new IconButtonEIO(gui, ID_WHITELIST, x, y, IconEIO.FILTER_WHITELIST);
        this.whiteListB.setToolTip(Lang.localize("gui.conduit.item.whitelist"));
        this.useMetaB = new ToggleButtonEIO(gui, ID_META, x += 20, y, IconEIO.FILTER_META_OFF, IconEIO.FILTER_META);
        this.useMetaB.setSelectedToolTip(Lang.localize("gui.conduit.item.matchMetaData"));
        this.useMetaB.setUnselectedToolTip(Lang.localize("gui.conduit.item.ignoreMetaData"));
        this.useMetaB.setPaintSelectedBorder(false);
        this.stickyB = new ToggleButtonEIO(gui, ID_STICKY, x += 20, y, IconEIO.FILTER_STICKY_OFF, IconEIO.FILTER_STICKY);
        String[] lines = Lang.localizeList("gui.conduit.item.stickyEnabled");
        this.stickyB.setSelectedToolTip(lines);
        this.stickyB.setUnselectedToolTip(Lang.localize("gui.conduit.item.stickyDisbaled"));
        this.stickyB.setPaintSelectedBorder(false);
        x = butLeft;
        this.useNbtB = new ToggleButtonEIO(gui, ID_NBT, x += 20, y += 20, IconEIO.FILTER_NBT_OFF, IconEIO.FILTER_NBT);
        this.useNbtB.setSelectedToolTip(Lang.localize("gui.conduit.item.matchNBT"));
        this.useNbtB.setUnselectedToolTip(Lang.localize("gui.conduit.item.ignoreNBT"));
        this.useNbtB.setPaintSelectedBorder(false);
        x = butLeft;
        this.useOreDictB = new ToggleButtonEIO(gui, ID_ORE_DICT, x, y, IconEIO.FILTER_ORE_DICT_OFF, IconEIO.FILTER_ORE_DICT);
        this.useOreDictB.setSelectedToolTip(Lang.localize("gui.conduit.item.oreDicEnabled"));
        this.useOreDictB.setUnselectedToolTip(Lang.localize("gui.conduit.item.oreDicDisabled"));
        this.useOreDictB.setPaintSelectedBorder(false);
    }

    @Override
    public void mouseClicked(int x, int y, int par3) {
    }

    @Override
    public void updateButtons() {
        ItemFilter activeFilter = this.filter;
        if (this.isAdvanced) {
            this.useNbtB.onGuiInit();
            this.useNbtB.setSelected(activeFilter.isMatchNBT());
            this.useOreDictB.onGuiInit();
            this.useOreDictB.setSelected(activeFilter.isUseOreDict());
            if (!this.isInput) {
                this.stickyB.onGuiInit();
                this.stickyB.setSelected(activeFilter.isSticky());
            }
        }
        this.useMetaB.onGuiInit();
        this.useMetaB.setSelected(activeFilter.isMatchMeta());
        this.whiteListB.onGuiInit();
        if (activeFilter.isBlacklist()) {
            this.whiteListB.setIcon(IconEIO.FILTER_BLACKLIST);
            this.whiteListB.setToolTip(Lang.localize("gui.conduit.item.blacklist"));
        } else {
            this.whiteListB.setIcon(IconEIO.FILTER_WHITELIST);
            this.whiteListB.setToolTip(Lang.localize("gui.conduit.item.whitelist"));
        }
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        if (guiButton.field_146127_k == ID_META) {
            this.filter.setMatchMeta(this.useMetaB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_NBT) {
            this.filter.setMatchNBT(this.useNbtB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_STICKY) {
            this.filter.setSticky(this.stickyB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_ORE_DICT) {
            this.filter.setUseOreDict(this.useOreDictB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_WHITELIST) {
            this.filter.setBlacklist(!this.filter.isBlacklist());
            this.sendFilterChange();
        }
    }

    private void sendFilterChange() {
        this.updateButtons();
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketItemConduitFilter(this.itemConduit, this.gui.getDir()));
    }

    @Override
    public void deactivate() {
        this.useNbtB.detach();
        this.useMetaB.detach();
        this.useOreDictB.detach();
        this.whiteListB.detach();
        this.stickyB.detach();
    }

    @Override
    public void renderCustomOptions(int top, float par1, int par2, int par3) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture("enderio:textures/gui/itemFilter.png");
        this.gui.func_73729_b(this.gui.getGuiLeft() + 32, this.gui.getGuiTop() + 68, 0, 238, 90, 18);
        if (this.filter.isAdvanced()) {
            this.gui.func_73729_b(this.gui.getGuiLeft() + 32, this.gui.getGuiTop() + 86, 0, 238, 90, 18);
        }
    }
}

