/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui.item;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.gui.BaseSettingsPanel;
import crazypants.enderio.conduit.gui.FilterChangeListener;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.BasicItemFilterGui;
import crazypants.enderio.conduit.gui.item.ExistingItemFilterGui;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.gui.item.ModItemFilterGui;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.filter.ExistingItemFilter;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.conduit.item.filter.ItemFilter;
import crazypants.enderio.conduit.item.filter.ModItemFilter;
import crazypants.enderio.conduit.packet.PacketExtractMode;
import crazypants.enderio.conduit.packet.PacketItemConduitFilter;
import crazypants.enderio.gui.ColorButton;
import crazypants.enderio.gui.IconButtonEIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.RedstoneModeButton;
import crazypants.enderio.gui.ToggleButtonEIO;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.network.PacketHandler;
import crazypants.gui.GuiToolTip;
import crazypants.gui.IGuiScreen;
import crazypants.render.ColorUtil;
import crazypants.render.RenderUtil;
import crazypants.util.DyeColor;
import crazypants.util.Lang;
import java.awt.Color;
import java.awt.Rectangle;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class ItemSettings
extends BaseSettingsPanel {
    private static final int NEXT_FILTER_ID = 98932;
    private static final int ID_REDSTONE_BUTTON = 12614;
    private static final int ID_COLOR_BUTTON = 179816;
    private static final int ID_LOOP = 22;
    private static final int ID_ROUND_ROBIN = 24;
    private static final int ID_PRIORITY_UP = 25;
    private static final int ID_PRIORITY_DOWN = 26;
    private static final int ID_CHANNEL = 23;
    private IItemConduit itemConduit;
    private String inputHeading;
    private String outputHeading;
    private IconButtonEIO nextFilterB;
    private ToggleButtonEIO loopB;
    private ToggleButtonEIO roundRobinB;
    private IconButtonEIO priUpB;
    private IconButtonEIO priDownB;
    private RedstoneModeButton rsB;
    private ColorButton colorB;
    private ColorButton channelB;
    boolean inOutShowIn = false;
    private IItemFilter activeFilter;
    private int priLeft;
    private int priWidth = 32;
    private GuiToolTip priorityTooltip;
    private IItemFilterGui filterGui;

    public ItemSettings(final GuiExternalConnection gui, IConduit con) {
        super(IconEIO.WRENCH_OVERLAY_ITEM, Lang.localize("itemItemConduit.name"), gui, con);
        this.itemConduit = (IItemConduit)con;
        this.inputHeading = Lang.localize("gui.conduit.item.extractionFilter");
        this.outputHeading = Lang.localize("gui.conduit.item.insertionFilter");
        int x = 52;
        int y = this.customTop;
        this.nextFilterB = new IconButtonEIO(gui, 98932, x, y, IconEIO.RIGHT_ARROW);
        this.nextFilterB.setSize(8, 16);
        x = 66;
        this.channelB = new ColorButton(gui, 23, x, y);
        this.channelB.setColorIndex(0);
        this.channelB.setToolTipHeading(Lang.localize("gui.conduit.item.channel"));
        this.priLeft = (x += this.channelB.getWidth() + 4) - 8;
        this.rsB = new RedstoneModeButton((IGuiScreen)gui, 12614, x, y, new IRedstoneModeControlable(){

            @Override
            public void setRedstoneControlMode(RedstoneControlMode mode) {
                RedstoneControlMode curMode = this.getRedstoneControlMode();
                ItemSettings.this.itemConduit.setExtractionRedstoneMode(mode, gui.getDir());
                if (curMode != mode) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(ItemSettings.this.itemConduit, gui.getDir()));
                }
            }

            @Override
            public RedstoneControlMode getRedstoneControlMode() {
                return ItemSettings.this.itemConduit.getExtractionRedstoneMode(gui.getDir());
            }
        });
        this.colorB = new ColorButton(gui, 179816, x += this.rsB.getWidth() + 4, y);
        this.colorB.setColorIndex(this.itemConduit.getExtractionSignalColor(gui.getDir()).ordinal());
        this.colorB.setToolTipHeading(Lang.localize("gui.conduit.item.sigCol"));
        this.roundRobinB = new ToggleButtonEIO(gui, 24, x += 4 + this.colorB.getWidth(), y, IconEIO.ROUND_ROBIN_OFF, IconEIO.ROUND_ROBIN);
        this.roundRobinB.setSelectedToolTip(Lang.localize("gui.conduit.item.roundRobinEnabled"));
        this.roundRobinB.setUnselectedToolTip(Lang.localize("gui.conduit.item.roundRobinDisabled"));
        this.roundRobinB.setPaintSelectedBorder(false);
        this.loopB = new ToggleButtonEIO(gui, 22, x += 4 + this.roundRobinB.getWidth(), y, IconEIO.LOOP_OFF, IconEIO.LOOP);
        this.loopB.setSelectedToolTip(Lang.localize("gui.conduit.item.selfFeedEnabled"));
        this.loopB.setUnselectedToolTip(Lang.localize("gui.conduit.item.selfFeedDisabled"));
        this.loopB.setPaintSelectedBorder(false);
        x = this.priLeft + this.priWidth + 9;
        this.priUpB = new IconButtonEIO(gui, 25, x, y, IconEIO.ADD_BUT);
        this.priUpB.setSize(8, 8);
        this.priDownB = new IconButtonEIO(gui, 26, x, y += 8, IconEIO.MINUS_BUT);
        this.priDownB.setSize(8, 8);
        this.priorityTooltip = new GuiToolTip(new Rectangle(this.priLeft + 9, y, this.priWidth, 20), Lang.localize("gui.conduit.item.priority"));
        gui.getContainer().addFilterListener(new FilterChangeListener(){

            @Override
            public void onFilterChanged() {
                ItemSettings.this.filtersChanged();
            }
        });
    }

    private String getHeading() {
        ConnectionMode mode = this.con.getConnectionMode(this.gui.getDir());
        if (mode == ConnectionMode.DISABLED) {
            return "";
        }
        if (mode == ConnectionMode.OUTPUT) {
            return this.outputHeading;
        }
        if (mode == ConnectionMode.INPUT || this.inOutShowIn) {
            return this.inputHeading;
        }
        return this.outputHeading;
    }

    @Override
    protected void initCustomOptions() {
        this.updateGuiVisibility();
    }

    private void updateGuiVisibility() {
        this.deactivate();
        boolean showInput = false;
        boolean showOutput = false;
        ConnectionMode mode = this.con.getConnectionMode(this.gui.getDir());
        if (mode == ConnectionMode.INPUT) {
            showInput = true;
        } else if (mode == ConnectionMode.OUTPUT) {
            showOutput = true;
        } else if (mode == ConnectionMode.IN_OUT) {
            if (this.nextFilterB != null) {
                this.nextFilterB.onGuiInit();
            }
            showInput = this.inOutShowIn;
            boolean bl = showOutput = !this.inOutShowIn;
        }
        if (!showInput && !showOutput) {
            this.filterGui = null;
            this.activeFilter = null;
        } else if (showInput) {
            this.activeFilter = this.itemConduit.getInputFilter(this.gui.getDir());
            this.gui.getContainer().setInventorySlotsVisible(true);
            this.gui.getContainer().setInputSlotsVisible(true);
            this.gui.getContainer().setOutputSlotsVisible(false);
            if (this.activeFilter != null) {
                this.filterGui = this.getFilterGui(this.activeFilter, true);
            }
        } else if (showOutput) {
            this.activeFilter = this.itemConduit.getOutputFilter(this.gui.getDir());
            this.gui.getContainer().setInputSlotsVisible(false);
            this.gui.getContainer().setOutputSlotsVisible(true);
            this.gui.getContainer().setInventorySlotsVisible(true);
            if (this.activeFilter != null) {
                this.filterGui = this.getFilterGui(this.activeFilter, false);
            }
        }
        this.updateButtons();
    }

    private void filtersChanged() {
        boolean showInput;
        ConnectionMode mode;
        if (this.filterGui != null) {
            this.filterGui.deactivate();
            this.filterGui = null;
        }
        if ((mode = this.con.getConnectionMode(this.gui.getDir())) == ConnectionMode.DISABLED) {
            return;
        }
        boolean bl = showInput = mode == ConnectionMode.INPUT || mode == ConnectionMode.IN_OUT && this.inOutShowIn;
        if (showInput) {
            this.gui.getContainer().setInventorySlotsVisible(true);
            this.gui.getContainer().setInputSlotsVisible(true);
            this.gui.getContainer().setOutputSlotsVisible(false);
            this.activeFilter = this.itemConduit.getInputFilter(this.gui.getDir());
            if (this.activeFilter != null) {
                this.filterGui = this.getFilterGui(this.activeFilter, true);
            }
        } else {
            this.gui.getContainer().setInventorySlotsVisible(true);
            this.gui.getContainer().setInputSlotsVisible(false);
            this.gui.getContainer().setOutputSlotsVisible(true);
            this.activeFilter = this.itemConduit.getOutputFilter(this.gui.getDir());
            if (this.activeFilter != null) {
                this.filterGui = this.getFilterGui(this.activeFilter, false);
            }
        }
        if (this.filterGui != null) {
            this.filterGui.updateButtons();
        }
    }

    private IItemFilterGui getFilterGui(IItemFilter filter, boolean isInput) {
        if (filter instanceof ItemFilter) {
            return new BasicItemFilterGui(this.gui, this.itemConduit, isInput);
        }
        if (filter instanceof ExistingItemFilter) {
            return new ExistingItemFilterGui(this.gui, this.itemConduit, isInput);
        }
        if (filter instanceof ModItemFilter) {
            return new ModItemFilterGui(this.gui, this.itemConduit, isInput);
        }
        return null;
    }

    private void updateButtons() {
        boolean outputActive;
        ConnectionMode mode = this.con.getConnectionMode(this.gui.getDir());
        if (mode == ConnectionMode.DISABLED) {
            return;
        }
        boolean bl = outputActive = mode == ConnectionMode.IN_OUT && !this.inOutShowIn || mode == ConnectionMode.OUTPUT;
        if (!outputActive) {
            this.rsB.onGuiInit();
            this.rsB.setMode(this.itemConduit.getExtractionRedstoneMode(this.gui.getDir()));
            this.colorB.onGuiInit();
            this.colorB.setColorIndex(this.itemConduit.getExtractionSignalColor(this.gui.getDir()).ordinal());
        }
        if (mode == ConnectionMode.IN_OUT && !outputActive) {
            this.loopB.onGuiInit();
            this.loopB.setSelected(this.itemConduit.isSelfFeedEnabled(this.gui.getDir()));
        }
        if (mode == ConnectionMode.IN_OUT && !outputActive || mode == ConnectionMode.INPUT) {
            this.roundRobinB.onGuiInit();
            this.roundRobinB.setSelected(this.itemConduit.isRoundRobinEnabled(this.gui.getDir()));
        }
        if (mode == ConnectionMode.IN_OUT && outputActive || mode == ConnectionMode.OUTPUT) {
            this.priUpB.onGuiInit();
            this.priDownB.onGuiInit();
            this.gui.addToolTip(this.priorityTooltip);
        }
        int chanCol = !outputActive ? this.itemConduit.getInputColor(this.gui.getDir()).ordinal() : this.itemConduit.getOutputColor(this.gui.getDir()).ordinal();
        this.channelB.onGuiInit();
        this.channelB.setColorIndex(chanCol);
        if (this.filterGui != null) {
            this.filterGui.updateButtons();
        }
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        super.actionPerformed(guiButton);
        if (guiButton.field_146127_k == 98932) {
            this.inOutShowIn = !this.inOutShowIn;
            this.updateGuiVisibility();
        } else if (guiButton.field_146127_k == 179816) {
            this.itemConduit.setExtractionSignalColor(this.gui.getDir(), DyeColor.values()[this.colorB.getColorIndex()]);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(this.itemConduit, this.gui.getDir()));
        } else if (guiButton.field_146127_k == 22) {
            this.itemConduit.setSelfFeedEnabled(this.gui.getDir(), !this.itemConduit.isSelfFeedEnabled(this.gui.getDir()));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketItemConduitFilter(this.itemConduit, this.gui.getDir()));
        } else if (guiButton.field_146127_k == 24) {
            this.itemConduit.setRoundRobinEnabled(this.gui.getDir(), !this.itemConduit.isRoundRobinEnabled(this.gui.getDir()));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketItemConduitFilter(this.itemConduit, this.gui.getDir()));
        } else if (guiButton.field_146127_k == 25) {
            this.itemConduit.setOutputPriority(this.gui.getDir(), this.itemConduit.getOutputPriority(this.gui.getDir()) + 1);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketItemConduitFilter(this.itemConduit, this.gui.getDir()));
        } else if (guiButton.field_146127_k == 26) {
            this.itemConduit.setOutputPriority(this.gui.getDir(), this.itemConduit.getOutputPriority(this.gui.getDir()) - 1);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketItemConduitFilter(this.itemConduit, this.gui.getDir()));
        } else if (guiButton.field_146127_k == 23) {
            DyeColor col = DyeColor.values()[this.channelB.getColorIndex()];
            if (this.isInputVisible()) {
                col = DyeColor.values()[this.channelB.getColorIndex()];
                this.itemConduit.setInputColor(this.gui.getDir(), col);
                boolean input = true;
            } else {
                this.itemConduit.setOutputColor(this.gui.getDir(), DyeColor.values()[this.channelB.getColorIndex()]);
                boolean input = false;
            }
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketItemConduitFilter(this.itemConduit, this.gui.getDir()));
        }
        if (this.filterGui != null) {
            this.filterGui.actionPerformed(guiButton);
        }
    }

    @Override
    public void mouseClicked(int x, int y, int par3) {
        super.mouseClicked(x, y, par3);
        if (this.filterGui != null) {
            this.filterGui.mouseClicked(x, y, par3);
        }
    }

    private boolean isInputVisible() {
        ConnectionMode mode = this.con.getConnectionMode(this.gui.getDir());
        return mode == ConnectionMode.IN_OUT && this.inOutShowIn || mode == ConnectionMode.INPUT;
    }

    @Override
    protected void connectionModeChanged(ConnectionMode conectionMode) {
        super.connectionModeChanged(conectionMode);
        this.updateGuiVisibility();
    }

    @Override
    protected void renderCustomOptions(int top, float par1, int par2, int par3) {
        boolean outputActive;
        ConnectionMode mode = this.con.getConnectionMode(this.gui.getDir());
        if (mode == ConnectionMode.DISABLED) {
            return;
        }
        RenderUtil.bindTexture("enderio:textures/gui/itemFilter.png");
        this.gui.func_73729_b(this.gui.getGuiLeft(), this.gui.getGuiTop() + 55, 0, 55, this.gui.getXSize(), 145);
        FontRenderer fr = this.gui.getFontRenderer();
        String heading = this.getHeading();
        int headingWidth = fr.func_78256_a(heading);
        int x = 0;
        int rgb = ColorUtil.getRGB(Color.darkGray);
        fr.func_78276_b(heading, this.left + x, top, rgb);
        boolean bl = outputActive = mode == ConnectionMode.IN_OUT && !this.inOutShowIn || mode == ConnectionMode.OUTPUT;
        if (outputActive) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            IconEIO.BUTTON_DOWN.renderIcon(this.left + this.priLeft, top - 5, this.priWidth, 16.0, 0.0, true);
            String str = this.itemConduit.getOutputPriority(this.gui.getDir()) + "";
            int sw = fr.func_78256_a(str);
            fr.func_78276_b(str, this.left + this.priLeft + this.priWidth - sw - this.gap, top, ColorUtil.getRGB(Color.black));
        } else {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.bindTexture("enderio:textures/gui/itemFilter.png");
            this.gui.func_73729_b(this.gui.getGuiLeft() + 9 + 18, this.gui.getGuiTop() + 46, 94, 238, 18, 18);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture("enderio:textures/gui/itemFilter.png");
        this.gui.func_73729_b(this.gui.getGuiLeft() + 9, this.gui.getGuiTop() + 46, 94, 220, 18, 18);
        if (this.filterGui != null) {
            this.filterGui.renderCustomOptions(top, par1, par2, par3);
        }
    }

    @Override
    public void deactivate() {
        this.gui.getContainer().setInventorySlotsVisible(false);
        this.gui.getContainer().setInputSlotsVisible(false);
        this.gui.getContainer().setOutputSlotsVisible(false);
        this.rsB.detach();
        this.colorB.detach();
        this.roundRobinB.detach();
        this.loopB.detach();
        this.nextFilterB.detach();
        this.priUpB.detach();
        this.priDownB.detach();
        this.gui.removeToolTip(this.priorityTooltip);
        this.channelB.detach();
        if (this.filterGui != null) {
            this.filterGui.deactivate();
            this.filterGui = null;
        }
    }
}

