/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item;

import cpw.mods.fml.common.network.ByteBufUtils;
import crazypants.enderio.Log;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.conduit.item.filter.IItemFilterUpgrade;
import crazypants.enderio.conduit.item.filter.ItemFilter;
import crazypants.enderio.network.NetworkUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class FilterRegister {
    public static IItemFilter getFilterForUpgrade(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (!(stack.func_77973_b() instanceof IItemFilterUpgrade)) {
            return null;
        }
        IItemFilterUpgrade upgrade = (IItemFilterUpgrade)stack.func_77973_b();
        IItemFilter res = upgrade.createFilterFromStack(stack);
        return res;
    }

    public static boolean isFilterSet(ItemStack stack) {
        return stack != null && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("filter");
    }

    public static void writeFilterToStack(IItemFilter filter, ItemStack stack) {
        if (stack == null || filter == null) {
            return;
        }
        NBTTagCompound filterRoot = new NBTTagCompound();
        FilterRegister.writeFilterToNbt(filter, filterRoot);
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74782_a("filter", (NBTBase)filterRoot);
    }

    public static void writeFilterToNbt(IItemFilter filter, NBTTagCompound filterTag) {
        filterTag.func_74778_a("filterClass", filter.getClass().getName());
        filter.writeToNBT(filterTag);
    }

    public static IItemFilter loadFilterFromNbt(NBTTagCompound filterTag) {
        IItemFilter filter;
        if (filterTag == null) {
            return null;
        }
        if (!filterTag.func_74764_b("filterClass")) {
            filter = null;
            Log.warn("Could not load old version of item filter.");
        } else {
            String className = filterTag.func_74779_i("filterClass");
            filter = FilterRegister.loadFilterFromNbt(className, filterTag);
        }
        return filter;
    }

    private static IItemFilter loadFilterFromNbt(String className, NBTTagCompound tag) {
        try {
            Class<?> clz = Class.forName(className);
            IItemFilter filter = (IItemFilter)clz.newInstance();
            filter.readFromNBT(tag);
            return filter;
        }
        catch (Exception e) {
            Log.error("Could not read item filter with class name: " + className + " from NBT: " + tag + " Error: " + e);
            return null;
        }
    }

    public static void updateLegacyFilterNbt(NBTTagCompound filterTag, int conduitMeta) {
        if (filterTag == null) {
            return;
        }
        if (!filterTag.func_74764_b("filterClass")) {
            filterTag.func_74778_a("filterClass", ItemFilter.class.getName());
        }
        if (!filterTag.func_74764_b("isAdvanced")) {
            filterTag.func_74757_a("isAdvanced", conduitMeta == 1);
        }
    }

    public static void writeFilter(ByteBuf buf, IItemFilter filter) {
        if (filter == null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"nullFilter");
            return;
        }
        String name = filter.getClass().getName();
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)name);
        NBTTagCompound root = new NBTTagCompound();
        filter.writeToNBT(root);
        NetworkUtil.writeNBTTagCompound(root, buf);
    }

    public static IItemFilter readFilter(ByteBuf buf) {
        String className = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (className.equals("nullFilter")) {
            return null;
        }
        NBTTagCompound tag = NetworkUtil.readNBTTagCompound(buf);
        return FilterRegister.loadFilterFromNbt(className, tag);
    }
}

