/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item.filter;

import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.gui.TemplateSlot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class ItemFilter
implements IInventory,
IItemFilter {
    private static final boolean DEFAULT_BLACKLIST = false;
    private static final boolean DEFAULT_META = true;
    private static final boolean DEFAULT_MBT = true;
    private static final boolean DEFAULT_ORE_DICT = false;
    private static final boolean DEFAULT_STICKY = false;
    boolean isBlacklist = false;
    boolean matchMeta = true;
    boolean matchNBT = true;
    boolean useOreDict = false;
    boolean sticky = false;
    ItemStack[] items;
    final List<int[]> oreIds;
    private boolean isAdvanced;

    public ItemFilter() {
        this(5, false);
    }

    public ItemFilter(boolean advanced) {
        this(advanced ? 10 : 5, advanced);
    }

    private ItemFilter(int numItems, boolean isAdvanced) {
        this.isAdvanced = isAdvanced;
        this.items = new ItemStack[numItems];
        this.oreIds = new ArrayList<int[]>(numItems);
        for (int i = 0; i < numItems; ++i) {
            this.oreIds.add(null);
        }
    }

    @Override
    public boolean doesFilterCaptureStack(NetworkedInventory inv, ItemStack item) {
        return this.isSticky() && this.itemMatched(item);
    }

    @Override
    public boolean doesItemPassFilter(NetworkedInventory inv, ItemStack item) {
        if (!this.isValid()) {
            return true;
        }
        boolean matched = this.itemMatched(item);
        return this.isBlacklist ? !matched : matched;
    }

    private boolean itemMatched(ItemStack item) {
        if (item == null) {
            return false;
        }
        boolean matched = false;
        int i = 0;
        for (ItemStack it : this.items) {
            if (it != null && Item.func_150891_b((Item)item.func_77973_b()) == Item.func_150891_b((Item)it.func_77973_b())) {
                matched = true;
                if (this.matchMeta && item.func_77960_j() != it.func_77960_j()) {
                    matched = false;
                } else if (this.matchNBT && !ItemStack.func_77970_a((ItemStack)item, (ItemStack)it)) {
                    matched = false;
                }
            }
            if (!matched && this.isOreDicMatch(i, item)) {
                matched = true;
            }
            if (matched) break;
            ++i;
        }
        return matched;
    }

    private boolean isOreDicMatch(int filterItemIndex, ItemStack item) {
        if (!this.useOreDict || item == null) {
            return false;
        }
        int[] ids1 = this.getCachedIds(filterItemIndex);
        if (ids1 == null || ids1.length == 0) {
            return false;
        }
        int[] ids2 = OreDictionary.getOreIDs((ItemStack)item);
        if (ids2 == null || ids2.length == 0) {
            return false;
        }
        for (int id1 : ids1) {
            for (int id2 : ids2) {
                if (id1 != id2) continue;
                return true;
            }
        }
        return false;
    }

    private int[] getCachedIds(int filterItemIndex) {
        int[] res = this.oreIds.get(filterItemIndex);
        if (res == null) {
            ItemStack item = this.items[filterItemIndex];
            if (item == null) {
                res = new int[]{};
            } else {
                res = OreDictionary.getOreIDs((ItemStack)item);
                if (res == null) {
                    res = new int[]{};
                }
            }
            this.oreIds.set(filterItemIndex, res);
        }
        return res;
    }

    @Override
    public boolean isValid() {
        for (ItemStack item : this.items) {
            if (item == null) continue;
            return true;
        }
        return false;
    }

    public boolean isBlacklist() {
        return this.isBlacklist;
    }

    public void setBlacklist(boolean isBlacklist) {
        this.isBlacklist = isBlacklist;
    }

    public boolean isMatchMeta() {
        return this.matchMeta;
    }

    public void setMatchMeta(boolean matchMeta) {
        this.matchMeta = matchMeta;
    }

    public boolean isMatchNBT() {
        return this.matchNBT;
    }

    public void setMatchNBT(boolean matchNbt) {
        this.matchNBT = matchNbt;
    }

    public boolean isUseOreDict() {
        return this.useOreDict;
    }

    public void setUseOreDict(boolean useOreDict) {
        this.useOreDict = useOreDict;
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74757_a("isBlacklist", this.isBlacklist);
        nbtRoot.func_74757_a("matchMeta", this.matchMeta);
        nbtRoot.func_74757_a("matchNBT", this.matchNBT);
        nbtRoot.func_74757_a("useOreDict", this.useOreDict);
        nbtRoot.func_74757_a("sticky", this.sticky);
        nbtRoot.func_74757_a("isAdvanced", this.isAdvanced);
        int i = 0;
        for (ItemStack item : this.items) {
            NBTTagCompound itemTag = new NBTTagCompound();
            if (item != null) {
                item.func_77955_b(itemTag);
                nbtRoot.func_74782_a("item" + i, (NBTBase)itemTag);
            }
            ++i;
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot) {
        int i;
        this.isBlacklist = nbtRoot.func_74767_n("isBlacklist");
        this.matchMeta = nbtRoot.func_74767_n("matchMeta");
        this.matchNBT = nbtRoot.func_74767_n("matchNBT");
        this.useOreDict = nbtRoot.func_74767_n("useOreDict");
        this.sticky = nbtRoot.func_74767_n("sticky");
        this.isAdvanced = nbtRoot.func_74767_n("isAdvanced");
        int numItems = this.isAdvanced ? 10 : 5;
        this.items = new ItemStack[numItems];
        this.oreIds.clear();
        for (i = 0; i < numItems; ++i) {
            this.oreIds.add(null);
        }
        for (i = 0; i < numItems; ++i) {
            NBTBase tag = nbtRoot.func_74781_a("item" + i);
            this.items[i] = tag instanceof NBTTagCompound ? ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)tag)) : null;
        }
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int i) {
        if (i < 0 || i >= this.items.length) {
            return null;
        }
        return this.items[i];
    }

    public ItemStack func_70298_a(int fromSlot, int amount) {
        this.oreIds.set(fromSlot, null);
        ItemStack item = this.items[fromSlot];
        this.items[fromSlot] = null;
        if (item == null) {
            return null;
        }
        item.field_77994_a = 0;
        return item;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (itemstack != null) {
            this.items[i] = itemstack.func_77946_l();
            this.items[i].field_77994_a = 0;
        } else {
            this.items[i] = null;
        }
        this.oreIds.set(i, null);
    }

    public String func_145825_b() {
        return "Item Filter";
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public List<Slot> getSlots() {
        ArrayList<Slot> result = new ArrayList<Slot>();
        int topY = 69;
        int leftX = 33;
        int index = 0;
        int numRows = this.isAdvanced ? 2 : 1;
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < 5; ++col) {
                int x = leftX + col * 18;
                int y = topY + row * 18;
                result.add(new TemplateSlot(this, index, x, y));
                ++index;
            }
        }
        return result;
    }

    @Override
    public int getSlotCount() {
        return this.func_70302_i_();
    }

    public boolean isAdvanced() {
        return this.isAdvanced;
    }

    public boolean isDefault() {
        return !this.isAdvanced && !this.isValid() && !this.isBlacklist && this.matchMeta && this.matchNBT && !this.useOreDict && !this.sticky;
    }

    public String toString() {
        return "ItemFilter [isAdvanced=" + this.isAdvanced + ", items=" + Arrays.toString(this.items) + "]";
    }
}

