/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import crazypants.enderio.Log;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.liquid.EnderLiquidConduit;
import crazypants.enderio.conduit.liquid.FluidFilter;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.config.Config;
import crazypants.util.BlockCoord;
import crazypants.util.FluidUtil;
import crazypants.util.RoundRobinIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class EnderLiquidConduitNetwork
extends AbstractConduitNetwork<ILiquidConduit, EnderLiquidConduit> {
    public static final int MAX_EXTRACT_PER_TICK = Config.enderFluidConduitExtractRate;
    public static final int MAX_IO_PER_TICK = Config.enderFluidConduitMaxIoRate;
    List<NetworkTank> tanks = new ArrayList<NetworkTank>();
    Map<NetworkTankKey, NetworkTank> tankMap = new HashMap<NetworkTankKey, NetworkTank>();
    Map<NetworkTank, RoundRobinIterator<NetworkTank>> iterators;
    boolean filling;

    public EnderLiquidConduitNetwork() {
        super(EnderLiquidConduit.class);
    }

    @Override
    public Class<ILiquidConduit> getBaseConduitType() {
        return ILiquidConduit.class;
    }

    public void connectionChanged(EnderLiquidConduit con, ForgeDirection conDir) {
        NetworkTankKey key = new NetworkTankKey(con, conDir);
        NetworkTank tank = new NetworkTank(con, conDir);
        this.tanks.remove(tank);
        this.tankMap.remove(key);
        this.tanks.add(tank);
        this.tankMap.put(key, tank);
    }

    public boolean extractFrom(EnderLiquidConduit con, ForgeDirection conDir) {
        NetworkTank tank = this.getTank(con, conDir);
        if (tank == null || !tank.isValid()) {
            return false;
        }
        FluidStack drained = tank.externalTank.drain(conDir.getOpposite(), MAX_EXTRACT_PER_TICK, false);
        if (drained == null || drained.amount <= 0 || !this.matchedFilter(drained, con, conDir, true)) {
            return false;
        }
        int amountAccepted = this.fillFrom(tank, drained, true);
        if (amountAccepted <= 0) {
            return false;
        }
        drained = tank.externalTank.drain(conDir.getOpposite(), amountAccepted, true);
        if (drained == null || drained.amount <= 0) {
            return false;
        }
        if (drained.amount != amountAccepted) {
            Log.warn("EnderLiquidConduit.extractFrom: Extracted fluid volume is not equal to inserted volume. Drained=" + drained.amount + " filled=" + amountAccepted + " Fluid: " + drained + " Accepted=" + amountAccepted);
        }
        return true;
    }

    private NetworkTank getTank(EnderLiquidConduit con, ForgeDirection conDir) {
        return this.tankMap.get(new NetworkTankKey(con, conDir));
    }

    public int fillFrom(EnderLiquidConduit con, ForgeDirection conDir, FluidStack resource, boolean doFill) {
        return this.fillFrom(this.getTank(con, conDir), resource, doFill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fillFrom(NetworkTank tank, FluidStack resource, boolean doFill) {
        if (this.filling) {
            return 0;
        }
        try {
            this.filling = true;
            if (resource == null || tank == null || !this.matchedFilter(resource, tank.con, tank.conDir, true)) {
                int n = 0;
                return n;
            }
            resource = resource.copy();
            resource.amount = Math.min(resource.amount, MAX_IO_PER_TICK);
            int filled = 0;
            int remaining = resource.amount;
            for (NetworkTank target : this.getIteratorForTank(tank)) {
                if (target.equals(tank) || !target.acceptsOuput || !target.isValid() || !this.matchedFilter(resource, target.con, target.conDir, false)) continue;
                int vol = target.externalTank.fill(target.tankDir, resource.copy(), doFill);
                filled += vol;
                if ((remaining -= vol) <= 0) {
                    int n = filled;
                    return n;
                }
                resource.amount = remaining;
            }
            int n = filled;
            return n;
        }
        finally {
            this.filling = false;
        }
    }

    private boolean matchedFilter(FluidStack drained, EnderLiquidConduit con, ForgeDirection conDir, boolean isInput) {
        if (drained == null || con == null || conDir == null) {
            return false;
        }
        FluidFilter filter = con.getFilter(conDir, isInput);
        if (filter == null || filter.isEmpty()) {
            return true;
        }
        return filter.matchesFilter(drained);
    }

    private Iterable<NetworkTank> getIteratorForTank(NetworkTank tank) {
        RoundRobinIterator<NetworkTank> res;
        if (this.iterators == null) {
            this.iterators = new HashMap<NetworkTank, RoundRobinIterator<NetworkTank>>();
        }
        if ((res = this.iterators.get(tank)) == null) {
            res = new RoundRobinIterator<NetworkTank>(this.tanks);
            this.iterators.put(tank, res);
        }
        return res;
    }

    public FluidTankInfo[] getTankInfo(EnderLiquidConduit con, ForgeDirection conDir) {
        ArrayList<FluidTankInfo> res = new ArrayList<FluidTankInfo>(this.tanks.size());
        NetworkTank tank = this.getTank(con, conDir);
        for (NetworkTank target : this.tanks) {
            FluidTankInfo[] tTanks;
            if (target.equals(tank) || !target.isValid() || (tTanks = target.externalTank.getTankInfo(target.tankDir)) == null) continue;
            for (FluidTankInfo info : tTanks) {
                res.add(info);
            }
        }
        return res.toArray(new FluidTankInfo[res.size()]);
    }

    static class NetworkTank {
        EnderLiquidConduit con;
        ForgeDirection conDir;
        IFluidHandler externalTank;
        ForgeDirection tankDir;
        BlockCoord conduitLoc;
        boolean acceptsOuput;

        public NetworkTank(EnderLiquidConduit con, ForgeDirection conDir) {
            this.con = con;
            this.conDir = conDir;
            this.conduitLoc = con.getLocation();
            this.tankDir = conDir.getOpposite();
            this.externalTank = FluidUtil.getExternalFluidHandler((IBlockAccess)con.getBundle().getWorld(), this.conduitLoc.getLocation(conDir));
            this.acceptsOuput = con.getConnectionMode(conDir).acceptsOutput();
        }

        public boolean isValid() {
            return this.externalTank != null && this.con.getConnectionMode(this.conDir) != ConnectionMode.DISABLED;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.conDir == null ? 0 : this.conDir.hashCode());
            result = 31 * result + (this.conduitLoc == null ? 0 : this.conduitLoc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NetworkTank other = (NetworkTank)obj;
            if (this.conDir != other.conDir) {
                return false;
            }
            return !(this.conduitLoc == null ? other.conduitLoc != null : !this.conduitLoc.equals(other.conduitLoc));
        }
    }

    static class NetworkTankKey {
        ForgeDirection conDir;
        BlockCoord conduitLoc;

        public NetworkTankKey(EnderLiquidConduit con, ForgeDirection conDir) {
            this(con.getLocation(), conDir);
        }

        public NetworkTankKey(BlockCoord conduitLoc, ForgeDirection conDir) {
            this.conDir = conDir;
            this.conduitLoc = conduitLoc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.conDir == null ? 0 : this.conDir.hashCode());
            result = 31 * result + (this.conduitLoc == null ? 0 : this.conduitLoc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NetworkTankKey other = (NetworkTankKey)obj;
            if (this.conDir != other.conDir) {
                return false;
            }
            return !(this.conduitLoc == null ? other.conduitLoc != null : !this.conduitLoc.equals(other.conduitLoc));
        }
    }
}

