/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.power;

import java.util.LinkedList;

public class PowerTracker {
    private float previousStorageLevel = -1.0f;
    private final TickTracker recTracker = new TickTracker();
    private final TickTracker sentTracker = new TickTracker();
    private int sentThisTick = 0;
    private int recievedThisTick = 0;

    public void tickStart(float storedEnergy) {
        double curStorage = storedEnergy;
        if (this.previousStorageLevel > -1.0f) {
            double recieved = curStorage - (double)this.previousStorageLevel;
            recieved = Math.max(0.0, recieved);
            this.recievedThisTick = (int)((double)this.recievedThisTick + recieved);
        }
    }

    public void powerRecieved(int power) {
        this.recievedThisTick += power;
    }

    public void powerSent(int power) {
        this.sentThisTick += power;
    }

    public void tickEnd(int storedEnergy) {
        this.previousStorageLevel = storedEnergy;
        this.sentTracker.tick(this.sentThisTick);
        this.recTracker.tick(this.recievedThisTick);
        this.recievedThisTick = 0;
        this.sentThisTick = 0;
    }

    public float getAverageRfTickRecieved() {
        return this.recTracker.getRFT();
    }

    public float getAverageRfTickSent() {
        return this.sentTracker.getRFT();
    }

    private static class LimitedQueue<E>
    extends LinkedList<E> {
        private final int limit;

        public LimitedQueue(int limit) {
            this.limit = limit;
        }

        @Override
        public boolean add(E o) {
            super.add(o);
            while (this.size() > this.limit) {
                super.remove();
            }
            return true;
        }
    }

    private static class TickTracker {
        private float lastSecondTotal = 0.0f;
        private int index = 0;
        private LimitedQueue<Float> lastFiveSeconds = new LimitedQueue(5);

        private TickTracker() {
        }

        float getRFT() {
            int numTicks = this.index + this.lastFiveSeconds.size() * 20;
            if (numTicks == 0) {
                return 0.0f;
            }
            float totalPower = this.lastSecondTotal;
            for (Float fl : this.lastFiveSeconds) {
                totalPower += fl.floatValue();
            }
            return totalPower / (float)numTicks;
        }

        void tick(int power) {
            this.lastSecondTotal += (float)power;
            ++this.index;
            if (this.index == 20) {
                this.lastFiveSeconds.add(Float.valueOf(this.lastSecondTotal));
                this.lastSecondTotal = 0.0f;
                this.index = 0;
            }
        }
    }
}

