/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.enderface;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.enderface.PacketOpenRemoteUi;
import crazypants.enderio.enderface.TileEnderIO;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.TravelController;
import crazypants.render.RenderUtil;
import crazypants.util.BlockCoord;
import crazypants.vecmath.Camera;
import crazypants.vecmath.Matrix4d;
import crazypants.vecmath.VecmathUtil;
import crazypants.vecmath.Vector3d;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiEnderface
extends GuiScreen {
    protected static final RenderBlocks RB = new RenderBlocks();
    private float pitch = -45.0f;
    private float yaw = 45.0f;
    private final EntityPlayer player;
    private final World world;
    private final int ioX;
    private final int ioY;
    private final int ioZ;
    private boolean chunkLoaded;
    private List<ViewableBlocks> blocks = new ArrayList<ViewableBlocks>();
    private int gw;
    private int gh;
    private int guiLeft;
    private int guiTop;
    private int finalGw;
    private int finalGh;
    private boolean animateInX = false;
    private boolean animateInY = false;
    float animationDuration = 60.0f;
    private final Vector3d origin = new Vector3d();
    private final Vector3d eye = new Vector3d();
    private final Camera camera = new Camera();
    private final Matrix4d pitchRot = new Matrix4d();
    private final Matrix4d yawRot = new Matrix4d();
    private float scaleAnimX;
    private int range;
    boolean dragging = false;
    private double distance;
    private long initTime;
    private float portalFade = 1.0f;

    public GuiEnderface(EntityPlayer player, World world, int ioX, int ioY, int ioZ) {
        this.player = player;
        this.world = world;
        this.ioX = ioX;
        this.ioY = ioY;
        this.ioZ = ioZ;
        this.range = Config.enderIoRange;
        this.distance = 10 + this.range * 2;
        TileEntity te = world.func_147438_o(ioX, ioY, ioZ);
        if (te instanceof TileEnderIO) {
            this.pitch = ((TileEnderIO)te).lastUiPitch;
            this.yaw = ((TileEnderIO)te).lastUiYaw;
            this.distance = ((TileEnderIO)te).lastUiDistance;
        }
        this.origin.set((double)ioX + 0.5, (double)ioY + 0.5, (double)ioZ + 0.5);
        this.pitchRot.setIdentity();
        this.yawRot.setIdentity();
        Chunk c = world.func_72938_d(ioX, ioZ);
        this.chunkLoaded = c != null && c.field_76636_d;
        GuiEnderface.RB.field_147845_a = world;
        this.blocks.add(new ViewableBlocks(ioX, ioY, ioZ, EnderIO.blockEnderIo));
        for (int x = ioX - this.range; x <= ioX + this.range; ++x) {
            for (int y = ioY - this.range; y <= ioY + this.range; ++y) {
                for (int z = ioZ - this.range; z <= ioZ + this.range; ++z) {
                    Block block = world.func_147439_a(x, y, z);
                    this.blocks.add(new ViewableBlocks(x, y, z, block));
                }
            }
        }
    }

    public void func_146281_b() {
        TileEntity te = this.world.func_147438_o(this.ioX, this.ioY, this.ioZ);
        if (te instanceof TileEnderIO) {
            ((TileEnderIO)te).lastUiPitch = this.pitch;
            ((TileEnderIO)te).lastUiYaw = this.yaw;
            ((TileEnderIO)te).lastUiDistance = this.distance;
        }
    }

    public void func_73866_w_() {
        this.finalGw = this.field_146294_l * 1;
        this.finalGh = this.field_146295_m * 1;
        this.gw = this.finalGw;
        this.gh = this.finalGh;
        this.guiLeft = (this.field_146294_l - this.gw) / 2;
        this.guiTop = (this.field_146295_m - this.gh) / 2;
        this.initTime = EnderIO.proxy.getTickCount();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146274_d() {
        Vector3d end;
        Vector3d start;
        int y;
        int x;
        super.func_146274_d();
        if (Mouse.getEventButton() == 0) {
            this.dragging = Mouse.getEventButtonState();
        }
        if (this.dragging) {
            double dx = (double)Mouse.getEventDX() / (double)this.field_146297_k.field_71443_c;
            double dy = (double)Mouse.getEventDY() / (double)this.field_146297_k.field_71440_d;
            if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)42)) {
                this.distance -= dy * 15.0;
            } else {
                this.yaw = (float)((double)this.yaw - dx * 180.0);
                this.pitch = (float)((double)this.pitch + dy * 180.0);
                this.pitch = (float)VecmathUtil.clamp(this.pitch, -80.0, 80.0);
            }
        }
        this.distance -= (double)Mouse.getDWheel() * 0.01;
        this.distance = VecmathUtil.clamp(this.distance, 0.1, 20.0);
        long elapsed = EnderIO.proxy.getTickCount() - this.initTime;
        if (Mouse.getEventButton() == 1 && !Mouse.getEventButtonState() && this.camera.isValid() && elapsed > 10L && this.camera.getRayForPixel(x = Mouse.getEventX(), y = Mouse.getEventY(), start = new Vector3d(), end = new Vector3d())) {
            end.scale(this.distance * 2.0);
            end.add(start);
            this.doSelection(start, end);
        }
    }

    private void doSelection(Vector3d start, Vector3d end) {
        start.add(this.origin);
        end.add(this.origin);
        ArrayList<MovingObjectPosition> hits = new ArrayList<MovingObjectPosition>();
        for (ViewableBlocks ug : this.blocks) {
            MovingObjectPosition res;
            if (ug.bc.equals(new BlockCoord(this.ioX, this.ioY, this.ioZ)) || (res = this.player.field_70170_p.func_72901_a(Vec3.func_72443_a((double)start.x, (double)start.y, (double)start.z), Vec3.func_72443_a((double)end.x, (double)end.y, (double)end.z), false)) == null) continue;
            hits.add(res);
        }
        MovingObjectPosition hit = GuiEnderface.getClosestHit(Vec3.func_72443_a((double)start.x, (double)start.y, (double)start.z), hits);
        if (hit != null) {
            Block block = this.world.func_147439_a(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
            if (block == EnderIO.blockHyperCube || block == EnderIO.blockCapacitorBank) {
                block.func_149727_a(this.world, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, this.player, 0, 0.0f, 0.0f, 0.0f);
            } else {
                this.openInterface(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
            }
        }
    }

    public static MovingObjectPosition getClosestHit(Vec3 origin, Collection<MovingObjectPosition> candidates) {
        double minLengthSquared = Double.POSITIVE_INFINITY;
        MovingObjectPosition closest = null;
        for (MovingObjectPosition hit : candidates) {
            double lengthSquared;
            if (hit == null || !((lengthSquared = hit.field_72307_f.func_72436_e(origin)) < minLengthSquared)) continue;
            minLengthSquared = lengthSquared;
            closest = hit;
        }
        return closest;
    }

    public void func_73863_a(int par1, int par2, float partialTick) {
        this.animateBackground(partialTick);
        this.func_146276_q_();
        RenderHelper.func_74518_a();
        RenderHelper.func_74520_c();
        this.drawEnderfaceBackground();
        if (!this.updateCamera(partialTick)) {
            return;
        }
        this.applyCamera(partialTick);
        if (!this.animateInX && !this.animateInY) {
            if (this.chunkLoaded) {
                int pass;
                TravelController.instance.setSelectionEnabled(false);
                GL11.glEnable((int)2884);
                GL11.glEnable((int)32826);
                RenderHelper.func_74518_a();
                this.field_146297_k.field_71460_t.func_78463_b(0.0);
                RenderUtil.bindBlockTexture();
                Vector3d trans = new Vector3d(-this.origin.x + this.eye.x, -this.origin.y + this.eye.y, -this.origin.z + this.eye.z);
                for (pass = 0; pass < 2; ++pass) {
                    ForgeHooksClient.setRenderPass((int)pass);
                    this.setGlStateForPass(pass);
                    Tessellator.field_78398_a.func_78382_b();
                    Tessellator.field_78398_a.func_78373_b(trans.x, trans.y, trans.z);
                    for (ViewableBlocks ug : this.blocks) {
                        if (!ug.block.canRenderInPass(pass)) continue;
                        RB.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                        RB.func_147805_b(ug.block, ug.bc.x, ug.bc.y, ug.bc.z);
                    }
                    Tessellator.field_78398_a.func_78381_a();
                    Tessellator.field_78398_a.func_78373_b(0.0, 0.0, 0.0);
                }
                RenderHelper.func_74519_b();
                TileEntityRendererDispatcher.field_147556_a.field_147558_l = this.origin.x - this.eye.x;
                TileEntityRendererDispatcher.field_147556_a.field_147560_j = this.origin.y - this.eye.y;
                TileEntityRendererDispatcher.field_147556_a.field_147561_k = this.origin.z - this.eye.z;
                TileEntityRendererDispatcher.field_147554_b = this.origin.x - this.eye.x;
                TileEntityRendererDispatcher.field_147555_c = this.origin.y - this.eye.y;
                TileEntityRendererDispatcher.field_147552_d = this.origin.z - this.eye.z;
                for (pass = 0; pass < 2; ++pass) {
                    ForgeHooksClient.setRenderPass((int)pass);
                    this.setGlStateForPass(pass);
                    for (ViewableBlocks ug : this.blocks) {
                        TileEntity tile = this.world.func_147438_o(ug.bc.x, ug.bc.y, ug.bc.z);
                        if (tile == null) continue;
                        Vector3d at = new Vector3d(this.eye.x - 0.5, this.eye.y - 0.5, this.eye.z - 0.5);
                        at.x += (double)(ug.bc.x - this.ioX);
                        at.y += (double)(ug.bc.y - this.ioY);
                        at.z += (double)(ug.bc.z - this.ioZ);
                        TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, at.x, at.y, at.z, 0.0f);
                    }
                }
                ForgeHooksClient.setRenderPass((int)-1);
                this.setGlStateForPass(0);
                TravelController.instance.setSelectionEnabled(true);
            } else {
                this.func_73732_a(Minecraft.func_71410_x().field_71466_p, "EnderIO chunk not loaded.", this.field_146294_l / 2, this.field_146295_m / 2 - 32, -1);
            }
        }
        this.drawEffectOverlay(partialTick);
    }

    private void setGlStateForPass(int pass) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (pass == 0) {
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
        } else {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDepthMask((boolean)false);
        }
    }

    private boolean updateCamera(float partialTick) {
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        int vpx = this.guiLeft * scaledresolution.func_78325_e();
        int vpy = this.guiTop * scaledresolution.func_78325_e();
        int vpw = (int)((float)this.gw / (float)this.field_146294_l * (float)this.field_146297_k.field_71443_c);
        int vph = (int)((float)this.gh / (float)this.field_146295_m * (float)this.field_146297_k.field_71440_d);
        if (vpw <= 0 || vph <= 0) {
            return false;
        }
        this.camera.setViewport(vpx, vpy, vpw, vph);
        this.camera.setProjectionMatrixAsPerspective(30.0, 0.05, 50.0, vpw, vph);
        this.eye.set(0.0, 0.0, this.distance);
        this.pitchRot.makeRotationX(Math.toRadians(this.pitch));
        this.yawRot.makeRotationY(Math.toRadians(this.yaw));
        this.pitchRot.transform(this.eye);
        this.yawRot.transform(this.eye);
        this.camera.setViewMatrixAsLookAt(this.eye, RenderUtil.ZERO_V, RenderUtil.UP_V);
        return this.camera.isValid();
    }

    private void applyCamera(float partialTick) {
        Rectangle vp = this.camera.getViewport();
        GL11.glViewport((int)vp.x, (int)vp.y, (int)vp.width, (int)vp.height);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        RenderUtil.loadMatrix(this.camera.getTransposeProjectionMatrix());
        GL11.glMatrixMode((int)5888);
        RenderUtil.loadMatrix(this.camera.getTransposeViewMatrix());
        this.scaleAnimX = (float)((double)this.scaleAnimX + (double)partialTick * 0.25);
        float v = 0.4f;
        float sf = 1.0f * (1.0f + v / 32.0f);
        GL11.glRotatef((float)((this.scaleAnimX + partialTick) * 7.0f), (float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glScalef((float)sf, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)(-(this.scaleAnimX + partialTick) * 7.0f), (float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)(-((float)this.eye.x)), (float)(-((float)this.eye.y)), (float)(-((float)this.eye.z)));
    }

    private void drawEffectOverlay(float partialTick) {
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3008);
        GL11.glDepthMask((boolean)false);
        RenderHelper.func_74518_a();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        this.field_146297_k.field_71460_t.func_78483_a(0.0);
        this.portalFade -= partialTick * (1.0f / this.animationDuration);
        this.portalFade = Math.max(0.0f, this.portalFade);
        if (this.portalFade >= 0.0f) {
            this.drawRect(scaledresolution.func_78326_a(), scaledresolution.func_78328_b(), 0.0f, 0.3f, 0.16f, Math.max(0.3f, this.portalFade));
        }
        GL11.glEnable((int)2896);
        this.field_146297_k.field_71460_t.func_78463_b(0.0);
        this.renderPortalOverlay(0.8f - 0.2f * (1.0f - this.portalFade), scaledresolution.func_78326_a(), scaledresolution.func_78328_b());
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderPortalOverlay(float par1, int par2, int par3) {
        if (par1 < 1.0f) {
            par1 *= par1;
            par1 *= par1;
            par1 = par1 * 0.9f + 0.1f;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)par1);
        RenderUtil.bindBlockTexture();
        IIcon icon = Blocks.field_150427_aO.func_149733_h(1);
        float f1 = icon.func_94209_e();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94212_f();
        float f4 = icon.func_94210_h();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, (double)par3, -90.0, (double)f1, (double)f4);
        tessellator.func_78374_a((double)par2, (double)par3, -90.0, (double)f3, (double)f4);
        tessellator.func_78374_a((double)par2, 0.0, -90.0, (double)f3, (double)f2);
        tessellator.func_78374_a(0.0, 0.0, -90.0, (double)f1, (double)f2);
        tessellator.func_78381_a();
    }

    private boolean animating() {
        return this.gw < this.finalGw || this.gh < this.finalGh;
    }

    private void drawRect(int width, int height, float r, float g, float b, float a) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        tessellator.func_78382_b();
        tessellator.func_78377_a(0.0, (double)height, 0.0);
        tessellator.func_78377_a((double)width, (double)height, 0.0);
        tessellator.func_78377_a((double)width, 0.0, 0.0);
        tessellator.func_78377_a(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
    }

    private void animateBackground(float partialTick) {
        if (!this.animating()) {
            return;
        }
        int mag = (int)((float)this.field_146294_l / (this.animationDuration * 0.5f) * partialTick);
        int mag2 = mag * 2;
        int ymag = (int)((float)this.field_146295_m / (this.animationDuration * 0.5f) * partialTick);
        int ymag2 = ymag * 2;
        if (this.animateInX) {
            this.gw -= mag2;
            this.guiLeft += mag;
            if (this.gw <= 0) {
                this.animateInX = false;
            }
        } else {
            this.gw += mag2;
            this.guiLeft -= mag;
        }
        if (this.animateInY) {
            this.gh -= ymag2;
            this.guiTop += ymag;
            if (this.gh <= 0) {
                this.animateInY = false;
            }
        } else {
            this.gh += ymag2;
            this.guiTop -= ymag;
        }
        this.gw = Math.min(this.gw, this.finalGw);
        this.gh = Math.min(this.gh, this.finalGh);
        this.guiLeft = Math.max((this.field_146294_l - this.finalGw) / 2, this.guiLeft);
        this.guiTop = Math.max((this.field_146295_m - this.finalGh) / 2, this.guiTop);
    }

    private void drawEnderfaceBackground() {
        int w = this.gw;
        int h = this.gh;
        int left = this.guiLeft;
        int top = this.guiTop;
        int cx = left + w / 2;
        int cy = top + h / 2;
        GuiEnderface.func_73734_a((int)left, (int)top, (int)(left + w), (int)(top + h), (int)-16777216);
        ++left;
        ++top;
        w -= 2;
        h -= 2;
        int topH = -1;
        int botH = -11184811;
        int rightH = -11184811;
        int leftH = -1;
        if (this.animateInX) {
            leftH = -11184811;
            rightH = -1;
        }
        if (this.animateInY) {
            topH = -11184811;
            botH = -1;
        }
        GuiEnderface.func_73734_a((int)(++left), (int)(++top), (int)(left + (w -= 2)), (int)(top + (h -= 2)), (int)-16764132);
    }

    void openInterface(int x, int y, int z) {
        PacketOpenRemoteUi p = new PacketOpenRemoteUi(x, y, z);
        PacketHandler.INSTANCE.sendToServer((IMessage)p);
    }

    static class ViewableBlocks {
        BlockCoord bc;
        Block block;

        private ViewableBlocks(int x, int y, int z, Block block) {
            this.bc = new BlockCoord(x, y, z);
            this.block = block;
        }
    }
}

