/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.fluid;

import cpw.mods.fml.common.Loader;
import crazypants.enderio.Log;
import crazypants.enderio.fluid.IFluidCoolant;
import crazypants.enderio.fluid.IFluidFuel;
import crazypants.enderio.fluid.IFluidRegister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidFuelRegister
implements IFluidRegister {
    public static final FluidFuelRegister instance = new FluidFuelRegister();
    private final Map<String, IFluidCoolant> coolants = new HashMap<String, IFluidCoolant>();
    private final Map<String, IFluidFuel> fuels = new HashMap<String, IFluidFuel>();
    private final List<IFluidRegister> otherRegisters = new ArrayList<IFluidRegister>();

    private FluidFuelRegister() {
        this.addCoolant(FluidRegistry.WATER, 0.0023f);
        if (Loader.isModLoaded((String)"BuildCraft|Energy")) {
            try {
                IFluidRegister reg = (IFluidRegister)Class.forName("crazypants.enderio.fluid.BuildCraftFluidRegister").newInstance();
                this.otherRegisters.add(reg);
            }
            catch (Exception e) {
                Log.error("FluidFuelRegister: Error occured registering build craft fuels: " + e);
            }
        }
    }

    @Override
    public void addCoolant(Fluid fluid, float degreesCoolingPerMB) {
        if (fluid == null || this.coolants.get(fluid.getName()) != null) {
            return;
        }
        this.coolants.put(fluid.getName(), new CoolantImpl(fluid, degreesCoolingPerMB));
        for (IFluidRegister reg : this.otherRegisters) {
            reg.addCoolant(fluid, degreesCoolingPerMB);
        }
    }

    @Override
    public IFluidCoolant getCoolant(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        IFluidCoolant res = this.coolants.get(fluid.getName());
        if (res == null && !this.coolants.containsKey(fluid.getName())) {
            IFluidRegister reg;
            Iterator<IFluidRegister> i$ = this.otherRegisters.iterator();
            while (i$.hasNext() && (res = (reg = i$.next()).getCoolant(fluid)) == null) {
            }
            this.coolants.put(fluid.getName(), res);
        }
        return res;
    }

    @Override
    public IFluidCoolant getCoolant(FluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null) {
            return null;
        }
        return this.getCoolant(fluid.getFluid());
    }

    @Override
    public void addFuel(Fluid fluid, int powerPerCycleRF, int totalBurnTime) {
        if (fluid == null || this.fuels.get(fluid.getName()) != null) {
            return;
        }
        this.fuels.put(fluid.getName(), new FuelImpl(fluid, powerPerCycleRF, totalBurnTime));
        for (IFluidRegister reg : this.otherRegisters) {
            reg.addFuel(fluid, powerPerCycleRF, totalBurnTime);
        }
    }

    @Override
    public IFluidFuel getFuel(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        IFluidFuel res = this.fuels.get(fluid.getName());
        if (res == null && !this.fuels.containsKey(fluid.getName())) {
            IFluidRegister reg;
            Iterator<IFluidRegister> i$ = this.otherRegisters.iterator();
            while (i$.hasNext() && (res = (reg = i$.next()).getFuel(fluid)) == null) {
            }
            this.fuels.put(fluid.getName(), res);
        }
        return res;
    }

    @Override
    public IFluidFuel getFuel(FluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null) {
            return null;
        }
        return this.getFuel(fluid.getFluid());
    }

    public static class CoolantImpl
    implements IFluidCoolant {
        private final Fluid fluid;
        private final float degreesCoolingPerMB;

        public CoolantImpl(Fluid fluid, float degreesCoolingPerMB) {
            this.fluid = fluid;
            this.degreesCoolingPerMB = degreesCoolingPerMB;
        }

        @Override
        public Fluid getFluid() {
            return this.fluid;
        }

        @Override
        public float getDegreesCoolingPerMB(float heat) {
            return this.degreesCoolingPerMB;
        }
    }

    public static class FuelImpl
    implements IFluidFuel {
        private final Fluid fluid;
        private final int powerPerCycle;
        private final int totalBurningTime;

        public FuelImpl(Fluid fluid, int powerPerCycle, int totalBurningTime) {
            this.fluid = fluid;
            this.powerPerCycle = powerPerCycle;
            this.totalBurningTime = totalBurningTime;
        }

        @Override
        public Fluid getFluid() {
            return this.fluid;
        }

        @Override
        public int getTotalBurningTime() {
            return this.totalBurningTime;
        }

        @Override
        public int getPowerPerCycle() {
            return this.powerPerCycle;
        }
    }
}

