/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.gui;

import crazypants.enderio.gui.IconEIO;
import crazypants.gui.GuiToolTip;
import crazypants.gui.IGuiScreen;
import crazypants.render.RenderUtil;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class IconButtonEIO
extends GuiButton {
    public static final int DEFAULT_WIDTH = 16;
    public static final int DEFAULT_HEIGHT = 16;
    protected IconEIO icon;
    protected ResourceLocation texture;
    private int xOrigin;
    private int yOrigin;
    protected IGuiScreen gui;
    protected GuiToolTip toolTip;
    private int marginY = 0;
    private int marginX = 0;

    public IconButtonEIO(IGuiScreen gui, int id, int x, int y, IconEIO icon) {
        super(id, x, y, 16, 16, "");
        this.gui = gui;
        this.icon = icon;
        this.texture = IconEIO.TEXTURE;
        this.xOrigin = x;
        this.yOrigin = y;
    }

    public void setToolTip(String ... tooltipText) {
        if (this.toolTip == null) {
            this.toolTip = new GuiToolTip(new Rectangle(this.xOrigin, this.yOrigin, this.field_146120_f, this.field_146121_g), tooltipText);
            this.toolTip.setBounds(new Rectangle(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g));
        } else {
            this.toolTip.setToolTipText(tooltipText);
        }
    }

    public void onGuiInit() {
        this.gui.addButton(this);
        if (this.toolTip != null) {
            this.gui.addToolTip(this.toolTip);
        }
        this.field_146128_h = this.xOrigin + this.gui.getGuiLeft();
        this.field_146129_i = this.yOrigin + this.gui.getGuiTop();
    }

    public void detach() {
        this.gui.removeToolTip(this.toolTip);
        this.gui.removeButton(this);
    }

    public void setSize(int width, int height) {
        this.field_146120_f = width;
        this.field_146121_g = height;
        if (this.toolTip != null) {
            this.toolTip.setBounds(new Rectangle(this.field_146128_h, this.field_146129_i, width, height));
        }
    }

    public void setIconMargin(int x, int y) {
        this.marginX = x;
        this.marginY = y;
    }

    public int getWidth() {
        return this.field_146120_f;
    }

    public int getHeight() {
        return this.field_146121_g;
    }

    public IconEIO getIcon() {
        return this.icon;
    }

    public void setIcon(IconEIO icon) {
        this.icon = icon;
    }

    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        if (this.toolTip != null) {
            this.toolTip.setVisible(this.field_146125_m);
        }
        if (this.field_146125_m) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int hoverState = this.func_146114_a(this.field_146123_n);
            this.func_146119_b(mc, mouseX, mouseY);
            IconEIO background = this.getIconForHoverState(hoverState);
            RenderUtil.bindTexture(this.texture);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tes = Tessellator.field_78398_a;
            tes.func_78382_b();
            int x = this.field_146128_h;
            int y = this.field_146129_i;
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            background.renderIcon(x, y, this.field_146120_f, this.field_146121_g, 0.0, false);
            if (this.icon != null) {
                this.icon.renderIcon(x + this.marginX, y + this.marginY, this.field_146120_f - 2 * this.marginX, this.field_146121_g - 2 * this.marginY, 0.0, false);
            }
            tes.func_78381_a();
            GL11.glPopAttrib();
        }
    }

    protected IconEIO getIconForHoverState(int hoverState) {
        if (hoverState == 0) {
            return IconEIO.BUTTON_DISABLED;
        }
        if (hoverState == 2) {
            return IconEIO.BUTTON_HIGHLIGHT;
        }
        return IconEIO.BUTTON;
    }
}

