/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.gui;

import crazypants.enderio.gui.IconButtonEIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.gui.IGuiScreen;
import net.minecraft.client.Minecraft;

public class ToggleButtonEIO
extends IconButtonEIO {
    private boolean selected;
    private IconEIO unselectedIcon;
    private IconEIO selectedIcon;
    private String[] selectedTooltip;
    private String[] unselectedTooltip;
    private boolean paintSelectionBorder;

    public ToggleButtonEIO(IGuiScreen gui, int id, int x, int y, IconEIO unselectedIcon, IconEIO selectedIcon) {
        super(gui, id, x, y, unselectedIcon);
        this.unselectedIcon = unselectedIcon;
        this.selectedIcon = selectedIcon;
        this.selected = false;
        this.paintSelectionBorder = true;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        IconEIO iconEIO = this.icon = selected ? this.selectedIcon : this.unselectedIcon;
        if (selected && this.selectedTooltip != null) {
            this.setToolTip(this.selectedTooltip);
        } else if (!selected && this.unselectedTooltip != null) {
            this.setToolTip(this.unselectedTooltip);
        }
    }

    @Override
    protected IconEIO getIconForHoverState(int hoverState) {
        if (!this.selected || !this.paintSelectionBorder) {
            return super.getIconForHoverState(hoverState);
        }
        if (hoverState == 0) {
            return IconEIO.BUTTON_DISABLED;
        }
        if (hoverState == 2) {
            return IconEIO.BUTTON_DOWN_HIGHLIGHT;
        }
        return IconEIO.BUTTON_DOWN;
    }

    public boolean func_146116_c(Minecraft par1Minecraft, int par2, int par3) {
        boolean result = super.func_146116_c(par1Minecraft, par2, par3);
        if (result) {
            this.setSelected(!this.selected);
        }
        return result;
    }

    public void setSelectedToolTip(String ... tt) {
        this.selectedTooltip = tt;
        this.setSelected(this.selected);
    }

    public void setUnselectedToolTip(String ... tt) {
        this.unselectedTooltip = tt;
        this.setSelected(this.selected);
    }

    public void setPaintSelectedBorder(boolean b) {
        this.paintSelectionBorder = b;
    }
}

