/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.gui;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.FluidFuelRegister;
import crazypants.enderio.fluid.IFluidCoolant;
import crazypants.enderio.fluid.IFluidFuel;
import crazypants.enderio.gui.IAdvancedTooltipProvider;
import crazypants.enderio.gui.IResourceTooltipProvider;
import crazypants.enderio.machine.crusher.CrusherRecipeManager;
import crazypants.enderio.machine.crusher.IGrindingMultiplier;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.util.ItemUtil;
import crazypants.util.Lang;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

public class TooltipAddera {
    public static TooltipAddera instance = new TooltipAddera();
    private BallTipProvider btp = new BallTipProvider();

    @SubscribeEvent
    public void addTooltip(ItemTooltipEvent evt) {
        IGrindingMultiplier gb;
        int time;
        if (evt.itemStack == null) {
            return;
        }
        if (Config.addFurnaceFuelTootip && (time = TileEntityFurnace.func_145952_a((ItemStack)evt.itemStack)) > 0) {
            evt.toolTip.add("Burn time " + time);
        }
        if (Config.addDurabilityTootip) {
            TooltipAddera.addDurabilityTooltip(evt.toolTip, evt.itemStack);
        }
        if (evt.itemStack.func_77973_b() instanceof IAdvancedTooltipProvider) {
            IAdvancedTooltipProvider ttp = (IAdvancedTooltipProvider)evt.itemStack.func_77973_b();
            TooltipAddera.addInformation(ttp, evt.itemStack, evt.entityPlayer, evt.toolTip, false);
            return;
        }
        if (evt.itemStack.func_77973_b() instanceof IResourceTooltipProvider) {
            TooltipAddera.addInformation((IResourceTooltipProvider)evt.itemStack.func_77973_b(), evt);
            return;
        }
        Block blk = Block.func_149634_a((Item)evt.itemStack.func_77973_b());
        if (blk instanceof IAdvancedTooltipProvider) {
            TooltipAddera.addInformation((IAdvancedTooltipProvider)blk, evt.itemStack, evt.entityPlayer, evt.toolTip, false);
            return;
        }
        if (blk instanceof IResourceTooltipProvider) {
            TooltipAddera.addInformation((IResourceTooltipProvider)blk, evt);
            return;
        }
        if (Config.addFuelTooltipsToAllFluidContainers) {
            TooltipAddera.addTooltipForFluid(evt.toolTip, evt.itemStack);
        }
        if ((gb = CrusherRecipeManager.getInstance().getGrindballFromStack(evt.itemStack)) != null) {
            this.btp.ball = gb;
            TooltipAddera.addInformation(this.btp, evt.itemStack, evt.entityPlayer, evt.toolTip, false);
        }
    }

    public static void addDurabilityTooltip(List<String> toolTip, ItemStack itemStack) {
        if (!itemStack.func_77984_f()) {
            return;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemTool || item instanceof ItemArmor || item instanceof ItemSword || item instanceof ItemHoe || item instanceof ItemBow) {
            toolTip.add(ItemUtil.getDurabilityString(itemStack));
        }
    }

    public static void addTooltipForFluid(List list, ItemStack stk) {
        FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stk);
        if (fluidStack == null) {
            return;
        }
        TooltipAddera.addTooltipForFluid(list, fluidStack.getFluid());
    }

    public static void addTooltipForFluid(List list, Fluid fluid) {
        if (fluid != null) {
            IFluidFuel fuel = FluidFuelRegister.instance.getFuel(fluid);
            if (fuel != null) {
                if (TooltipAddera.showAdvancedTooltips()) {
                    list.add(Lang.localize("fuel.tooltip.heading"));
                    list.add(EnumChatFormatting.ITALIC + " " + PowerDisplayUtil.formatPowerPerTick(fuel.getPowerPerCycle()));
                    list.add(EnumChatFormatting.ITALIC + " " + fuel.getTotalBurningTime() + " " + Lang.localize("fuel.tooltip.burnTime"));
                } else {
                    TooltipAddera.addShowDetailsTooltip(list);
                }
            } else {
                IFluidCoolant coolant = FluidFuelRegister.instance.getCoolant(fluid);
                if (coolant != null) {
                    if (TooltipAddera.showAdvancedTooltips()) {
                        list.add(Lang.localize("coolant.tooltip.heading"));
                        list.add(EnumChatFormatting.ITALIC + " " + list.add(Lang.localize("fuel.tooltip.degreesPerBucket") + " " + PowerDisplayUtil.formatPowerFloat(coolant.getDegreesCoolingPerMB(100.0f) * 1000.0f)));
                    } else {
                        TooltipAddera.addShowDetailsTooltip(list);
                    }
                }
            }
        }
    }

    public static void addInformation(IResourceTooltipProvider item, ItemTooltipEvent evt) {
        TooltipAddera.addInformation(item, evt.itemStack, evt.entityPlayer, evt.toolTip);
    }

    public static void addInformation(IResourceTooltipProvider tt, ItemStack itemstack, EntityPlayer entityplayer, List list) {
        String name = tt.getUnlocalizedNameForTooltip(itemstack);
        if (TooltipAddera.showAdvancedTooltips()) {
            TooltipAddera.addCommonTooltipFromResources(list, name);
            TooltipAddera.addDetailedTooltipFromResources(list, name);
        } else {
            TooltipAddera.addBasicTooltipFromResources(list, name);
            TooltipAddera.addCommonTooltipFromResources(list, name);
            TooltipAddera.addShowDetailsTooltip(list);
        }
    }

    public static void addInformation(IAdvancedTooltipProvider tt, ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        tt.addCommonEntries(itemstack, entityplayer, list, flag);
        if (TooltipAddera.showAdvancedTooltips()) {
            tt.addDetailedEntries(itemstack, entityplayer, list, flag);
        } else {
            tt.addBasicEntries(itemstack, entityplayer, list, flag);
            TooltipAddera.addShowDetailsTooltip(list);
        }
    }

    public static void addShowDetailsTooltip(List list) {
        list.add(EnumChatFormatting.WHITE + "" + EnumChatFormatting.ITALIC + Lang.localize("item.tooltip.showDetails"));
    }

    public static boolean showAdvancedTooltips() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static void addDetailedTooltipFromResources(List list, String unlocalizedName) {
        TooltipAddera.addTooltipFromResources(list, unlocalizedName, ".tooltip.detailed.line");
    }

    public static void addBasicTooltipFromResources(List list, String unlocalizedName) {
        TooltipAddera.addTooltipFromResources(list, unlocalizedName, ".tooltip.basic.line");
    }

    public static void addCommonTooltipFromResources(List list, String unlocalizedName) {
        TooltipAddera.addTooltipFromResources(list, unlocalizedName, ".tooltip.common.line");
    }

    public static void addTooltipFromResources(List list, String unlocalizedName, String tooltipTag) {
        String keyBase = unlocalizedName + tooltipTag;
        boolean done = false;
        int line = 1;
        while (!done) {
            String key = keyBase + line;
            String val = Lang.localize(key, false);
            if (val == null || val.trim().length() < 0 || val.equals(key) || line > 12) {
                done = true;
                continue;
            }
            list.add(val);
            ++line;
        }
    }

    public static void addDetailedTooltipFromResources(List list, ItemStack itemstack) {
        if (itemstack.func_77973_b() == null) {
            return;
        }
        String unlock = null;
        if (unlock == null) {
            unlock = itemstack.func_77973_b().func_77658_a();
        }
        TooltipAddera.addDetailedTooltipFromResources(list, unlock);
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    private static class BallTipProvider
    implements IAdvancedTooltipProvider {
        IGrindingMultiplier ball;

        private BallTipProvider() {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
            if (this.ball == null) {
                return;
            }
            list.add(EnumChatFormatting.BLUE + Lang.localize("darkGrindingBall.tooltip.detailed.line1"));
            list.add(EnumChatFormatting.GRAY + Lang.localize("darkGrindingBall.tooltip.detailed.line2") + this.toPercent(this.ball.getGrindingMultiplier()));
            list.add(EnumChatFormatting.GRAY + Lang.localize("darkGrindingBall.tooltip.detailed.line3") + this.toPercent(this.ball.getChanceMultiplier()));
            list.add(EnumChatFormatting.GRAY + Lang.localize("darkGrindingBall.tooltip.detailed.line4") + this.toPercent(1.0f - this.ball.getPowerMultiplier()));
        }

        private String toPercent(float fl) {
            int per = Math.round(fl *= 100.0f);
            return " " + per + "%";
        }
    }
}

