/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.config.Config;
import crazypants.enderio.gui.IAdvancedTooltipProvider;
import crazypants.enderio.item.darksteel.DarkSteelController;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.EnergyUpgrade;
import crazypants.enderio.item.darksteel.GliderUpgrade;
import crazypants.enderio.item.darksteel.GogglesOfRevealingUpgrade;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.JumpUpgrade;
import crazypants.enderio.item.darksteel.NightVisionUpgrade;
import crazypants.enderio.item.darksteel.SoundDetectorUpgrade;
import crazypants.enderio.item.darksteel.SpeedUpgrade;
import crazypants.enderio.item.darksteel.SwimUpgrade;
import crazypants.util.ItemUtil;
import crazypants.util.Lang;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import thaumcraft.api.IGoggles;
import thaumcraft.api.IVisDiscountGear;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.nodes.IRevealer;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.IGoggles", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.IVisDiscountGear", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.nodes.IRevealer", modid="Thaumcraft")})
public class ItemDarkSteelArmor
extends ItemArmor
implements IEnergyContainerItem,
ISpecialArmor,
IAdvancedTooltipProvider,
IDarkSteelItem,
IGoggles,
IRevealer,
IVisDiscountGear {
    public static final ItemArmor.ArmorMaterial MATERIAL = EnumHelper.addArmorMaterial((String)"darkSteel", (int)35, (int[])new int[]{2, 6, 5, 2}, (int)15);
    public static final int[] CAPACITY = new int[]{Config.darkSteelPowerStorageBase, Config.darkSteelPowerStorageBase, Config.darkSteelPowerStorageBase * 2, Config.darkSteelPowerStorageBase * 2};
    public static final int[] RF_PER_DAMAGE_POINT = new int[]{Config.darkSteelPowerStorageBase, Config.darkSteelPowerStorageBase, Config.darkSteelPowerStorageBase * 2, Config.darkSteelPowerStorageBase * 2};
    public static final String[] NAMES = new String[]{"helmet", "chestplate", "leggings", "boots"};
    boolean gogglesUgradeActive = true;
    private int powerPerDamagePoint;

    public static ItemDarkSteelArmor forArmorType(int armorType) {
        switch (armorType) {
            case 0: {
                return EnderIO.itemDarkSteelHelmet;
            }
            case 1: {
                return EnderIO.itemDarkSteelChestplate;
            }
            case 2: {
                return EnderIO.itemDarkSteelLeggings;
            }
            case 3: {
                return EnderIO.itemDarkSteelBoots;
            }
        }
        return null;
    }

    public static int getPoweredProtectionIncrease(int armorType) {
        switch (armorType) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public static ItemDarkSteelArmor create(int armorType) {
        ItemDarkSteelArmor res = new ItemDarkSteelArmor(armorType);
        res.init();
        return res;
    }

    protected ItemDarkSteelArmor(int armorType) {
        super(MATERIAL, 0, armorType);
        this.func_77637_a(EnderIOTab.tabEnderIO);
        String str = "darkSteel_" + NAMES[armorType];
        this.func_77655_b(str);
        this.func_111206_d("enderIO:" + str);
        this.powerPerDamagePoint = Config.darkSteelPowerStorageBase / MATERIAL.func_78046_a(armorType);
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        EnergyUpgrade.EMPOWERED_FOUR.writeToItem(is);
        EnergyUpgrade.setPowerFull(is);
        if (this.field_77881_a == 2) {
            SpeedUpgrade.SPEED_THREE.writeToItem(is);
        } else if (this.field_77881_a == 3) {
            JumpUpgrade.JUMP_THREE.writeToItem(is);
            SwimUpgrade.INSTANCE.writeToItem(is);
        } else if (this.field_77881_a == 1) {
            GliderUpgrade.INSTANCE.writeToItem(is);
        } else if (this.field_77881_a == 0) {
            SoundDetectorUpgrade.INSTANCE.writeToItem(is);
            NightVisionUpgrade.INSTANCE.writeToItem(is);
            if (GogglesOfRevealingUpgrade.getGoggles() != null) {
                GogglesOfRevealingUpgrade.INSTANCE.writeToItem(is);
            }
        }
        par3List.add(is);
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        switch (this.field_77881_a) {
            case 0: {
                return 5;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 7;
            }
            case 3: {
                return 4;
            }
        }
        return 4;
    }

    @Override
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        DarkSteelRecipeManager.instance.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    @Override
    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        DarkSteelRecipeManager.instance.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    @Override
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        String str;
        if (!Config.addDurabilityTootip) {
            list.add(ItemUtil.getDurabilityString(itemstack));
        }
        if ((str = EnergyUpgrade.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgrade.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(EnumChatFormatting.WHITE + Lang.localize("item.darkSteel_armor.tooltip.line1"));
            list.add(EnumChatFormatting.WHITE + Lang.localize("item.darkSteel_armor.tooltip.line2"));
            if (itemstack.func_77973_b() == EnderIO.itemDarkSteelBoots) {
                list.add(EnumChatFormatting.WHITE + Lang.localize("item.darkSteel_boots.tooltip.line1"));
                list.add(EnumChatFormatting.WHITE + Lang.localize("item.darkSteel_boots.tooltip.line2"));
            }
        }
        DarkSteelRecipeManager.instance.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public String getArmorTexture(ItemStack itemStack, Entity entity, int slot, String layer) {
        if (this.field_77881_a == 2) {
            return "enderio:textures/models/armor/darkSteel_layer_2.png";
        }
        return "enderio:textures/models/armor/darkSteel_layer_1.png";
    }

    public ItemStack createItemStack() {
        return new ItemStack((Item)this);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, armor.func_77958_k() + 1 - armor.func_77960_j());
        }
        double damageRatio = this.field_77879_b + (this.getEnergyStored(armor) > 0 ? ItemDarkSteelArmor.getPoweredProtectionIncrease(3 - slot) : 0);
        ISpecialArmor.ArmorProperties ap = new ISpecialArmor.ArmorProperties(0, damageRatio /= 25.0, armor.func_77958_k() + 1 - armor.func_77960_j());
        return ap;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        ItemDarkSteelArmor arm = ItemDarkSteelArmor.forArmorType(3 - slot);
        int powerBonus = this.getEnergyStored(armor) > 0 ? ItemDarkSteelArmor.getPoweredProtectionIncrease(3 - slot) : 0;
        return arm.func_82812_d().func_78044_b(3 - slot) + powerBonus;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(stack);
        if (eu != null && eu.isAbsorbDamageWithPower() && eu.getEnergy() > 0) {
            eu.extractEnergy(damage * this.powerPerDamagePoint, false);
        } else {
            damage = stack.func_77960_j() + damage;
            if (damage >= this.func_77612_l()) {
                stack.field_77994_a = 0;
            }
            stack.func_77964_b(damage);
        }
        if (eu != null) {
            eu.writeToItem(stack);
        }
    }

    public boolean func_82789_a(ItemStack i1, ItemStack i2) {
        return false;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return EnergyUpgrade.receiveEnergy(container, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return EnergyUpgrade.extractEnergy(container, maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return EnergyUpgrade.getEnergyStored(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return EnergyUpgrade.getMaxEnergyStored(container);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showNodes(ItemStack itemstack, EntityLivingBase player) {
        if (itemstack == null || itemstack.func_77973_b() == null || !this.gogglesUgradeActive) {
            return false;
        }
        return GogglesOfRevealingUpgrade.loadFromItem(itemstack) != null;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showIngamePopups(ItemStack itemstack, EntityLivingBase player) {
        if (itemstack == null || itemstack.func_77973_b() == null || !this.gogglesUgradeActive) {
            return false;
        }
        return GogglesOfRevealingUpgrade.loadFromItem(itemstack) != null;
    }

    @Optional.Method(modid="Thaumcraft")
    public int getVisDiscount(ItemStack stack, EntityPlayer player, Aspect aspect) {
        if (stack == null || stack.func_77973_b() != EnderIO.itemDarkSteelHelmet) {
            return 0;
        }
        return GogglesOfRevealingUpgrade.isUpgradeEquipped(player) ? 5 : 0;
    }

    public boolean isGogglesUgradeActive() {
        return this.gogglesUgradeActive;
    }

    public void setGogglesUgradeActive(boolean gogglesUgradeActive) {
        this.gogglesUgradeActive = gogglesUgradeActive;
    }

    static {
        FMLCommonHandler.instance().bus().register((Object)DarkSteelController.instance);
        MinecraftForge.EVENT_BUS.register((Object)DarkSteelRecipeManager.instance);
    }
}

