/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cofh.api.energy.IEnergyContainerItem;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.config.Config;
import crazypants.enderio.gui.IAdvancedTooltipProvider;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.EnergyUpgrade;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.ItemDarkSteelSword;
import crazypants.enderio.item.darksteel.SpoonUpgrade;
import crazypants.enderio.item.darksteel.TravelUpgrade;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.teleport.IItemOfTravel;
import crazypants.enderio.teleport.TravelController;
import crazypants.enderio.teleport.TravelSource;
import crazypants.render.BoundingBox;
import crazypants.util.BlockCoord;
import crazypants.util.ItemUtil;
import crazypants.util.Lang;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemDarkSteelPickaxe
extends ItemPickaxe
implements IEnergyContainerItem,
IAdvancedTooltipProvider,
IDarkSteelItem,
IItemOfTravel {
    private long lastBlickTick = -1L;

    public static boolean isEquipped(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null) {
            return false;
        }
        return equipped.func_77973_b() == EnderIO.itemDarkSteelPickaxe;
    }

    public static boolean isEquippedAndPowered(EntityPlayer player, int requiredPower) {
        if (!ItemDarkSteelPickaxe.isEquipped(player)) {
            return false;
        }
        return EnderIO.itemDarkSteelPickaxe.getEnergyStored(player.func_71045_bC()) >= requiredPower;
    }

    public static ItemDarkSteelPickaxe create() {
        ItemDarkSteelPickaxe res = new ItemDarkSteelPickaxe();
        res.init();
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    public ItemDarkSteelPickaxe() {
        super(ItemDarkSteelSword.MATERIAL);
        this.func_77637_a(EnderIOTab.tabEnderIO);
        String str = "darkSteel_pickaxe";
        this.func_77655_b(str);
        this.func_111206_d("enderIO:" + str);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        EnergyUpgrade.EMPOWERED_FOUR.writeToItem(is);
        EnergyUpgrade.setPowerFull(is);
        TravelUpgrade.INSTANCE.writeToItem(is);
        SpoonUpgrade.INSTANCE.writeToItem(is);
        par3List.add(is);
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 3;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        this.applyDamage(par3EntityLivingBase, par1ItemStack, 2);
        return true;
    }

    public boolean func_150894_a(ItemStack item, World world, Block block, int x, int y, int z, EntityLivingBase entLiving) {
        if ((double)block.func_149712_f(world, x, y, z) != 0.0) {
            if (block == Blocks.field_150343_Z) {
                this.extractEnergy(item, Config.darkSteelPickPowerUseObsidian, false);
            }
            this.applyDamage(entLiving, item, 1);
        }
        return true;
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (!this.isTravelUpgradeActive(player, item)) {
            return ItemDarkSteelPickaxe.doRightClickItemPlace(player, world, x, y, z, side, par8, par9, par10);
        }
        return false;
    }

    static boolean doRightClickItemPlace(EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        int slot;
        int current = player.field_71071_by.field_70461_c;
        int n = slot = current == 0 && Config.slotZeroPlacesEight ? 8 : current + 1;
        if (slot < 9 && player.field_71071_by.field_70462_a[slot] != null && !(player.field_71071_by.field_70462_a[slot].func_77973_b() instanceof IDarkSteelItem)) {
            if (!ItemDarkSteelPickaxe.canPlaceBlockOnRightClick(player, world, x, y, z, side, slot)) {
                return false;
            }
            boolean ret = player.field_71071_by.field_70462_a[slot].func_77973_b().func_77648_a(player.field_71071_by.field_70462_a[slot], player, world, x, y, z, side, par8, par9, par10);
            if (player.field_71071_by.field_70462_a[slot].field_77994_a <= 0) {
                player.field_71071_by.field_70462_a[slot] = null;
            }
            return ret;
        }
        return false;
    }

    static boolean canPlaceBlockOnRightClick(EntityPlayer player, World world, int x, int y, int z, int side, int slot) {
        AxisAlignedBB aabb;
        BlockCoord placeCoord = new BlockCoord(x, y, z).getLocation(ForgeDirection.getOrientation((int)side));
        ItemStack toUse = player.field_71071_by.field_70462_a[slot];
        Block blk = Block.func_149634_a((Item)toUse.func_77973_b());
        if (blk != null) {
            aabb = blk.func_149668_a(world, placeCoord.x, placeCoord.y, placeCoord.z);
        } else {
            BoundingBox bb = new BoundingBox(placeCoord);
            aabb = bb.getAxisAlignedBB();
        }
        return aabb == null || !aabb.func_72326_a(player.field_70121_D);
    }

    private void applyDamage(EntityLivingBase entity, ItemStack item, int damage) {
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(item);
        if (eu != null && eu.isAbsorbDamageWithPower() && eu.getEnergy() > 0) {
            eu.extractEnergy(damage * Config.darkSteelPickPowerUsePerDamagePoint, false);
        } else {
            damage = item.func_77960_j() + damage;
            if (damage >= this.func_77612_l()) {
                item.field_77994_a = 0;
            }
            item.func_77964_b(damage);
        }
        if (eu != null) {
            eu.writeToItem(item);
        }
    }

    public float func_150893_a(ItemStack item, Block block) {
        int energy = this.getEnergyStored(item);
        if (block == Blocks.field_150343_Z && energy > 0) {
            return super.func_150893_a(item, block) + (float)Config.darkSteelPickEffeciencyObsidian;
        }
        if (block.func_149688_o() == Material.field_151592_s) {
            return this.field_77864_a;
        }
        return super.func_150893_a(item, block);
    }

    public boolean canHarvestBlock(Block block, ItemStack item) {
        if (this.hasSpoonUpgrade(item) && this.getEnergyStored(item) > 0) {
            return block == Blocks.field_150431_aC ? true : block == Blocks.field_150433_aE || super.canHarvestBlock(block, item);
        }
        return super.canHarvestBlock(block, item);
    }

    private boolean hasSpoonUpgrade(ItemStack item) {
        return SpoonUpgrade.loadFromItem(item) != null;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            if (Config.darkSteelPickPowerUsePerDamagePoint <= 0 || this.getEnergyStored(stack) > 0) {
                return ItemDarkSteelSword.MATERIAL.func_77998_b() + Config.darkSteelPickEffeciencyBoostWhenPowered;
            }
            return ItemDarkSteelSword.MATERIAL.func_77998_b();
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        HashSet set = Sets.newHashSet((Object[])new String[]{"pickaxe"});
        if (this.hasSpoonUpgrade(stack)) {
            set.add("shovel");
        }
        return set;
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return EnergyUpgrade.receiveEnergy(container, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return EnergyUpgrade.extractEnergy(container, maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return EnergyUpgrade.getEnergyStored(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return EnergyUpgrade.getMaxEnergyStored(container);
    }

    public boolean func_82789_a(ItemStack i1, ItemStack i2) {
        return false;
    }

    @Override
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        DarkSteelRecipeManager.instance.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    @Override
    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        DarkSteelRecipeManager.instance.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    @Override
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        String str;
        if (!Config.addDurabilityTootip) {
            list.add(ItemUtil.getDurabilityString(itemstack));
        }
        if ((str = EnergyUpgrade.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgrade.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(EnumChatFormatting.WHITE + "+" + Config.darkSteelPickEffeciencyBoostWhenPowered + " " + Lang.localize("item.darkSteel_pickaxe.tooltip.effPowered"));
            list.add(EnumChatFormatting.WHITE + "+" + Config.darkSteelPickEffeciencyObsidian + " " + Lang.localize("item.darkSteel_pickaxe.tooltip.effObs") + " ");
            list.add(EnumChatFormatting.WHITE + "     (cost " + PowerDisplayUtil.formatPower(Config.darkSteelPickPowerUseObsidian / 10) + " " + PowerDisplayUtil.abrevation() + ")");
        }
        DarkSteelRecipeManager.instance.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public ItemStack createItemStack() {
        return new ItemStack((Item)this);
    }

    @Override
    public boolean isActive(EntityPlayer ep, ItemStack equipped) {
        return this.isTravelUpgradeActive(ep, equipped);
    }

    @Override
    public void extractInternal(ItemStack equipped, int power) {
        this.extractEnergy(equipped, power, false);
    }

    private boolean isTravelUpgradeActive(EntityPlayer ep, ItemStack equipped) {
        return ItemDarkSteelPickaxe.isEquipped(ep) && ep.func_70093_af() && TravelUpgrade.loadFromItem(equipped) != null;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.isTravelUpgradeActive(player, stack)) {
            if (world.field_72995_K && TravelController.instance.activateTravelAccessable(stack, world, player, TravelSource.STAFF)) {
                player.func_71038_i();
                return stack;
            }
            long ticksSinceBlink = EnderIO.proxy.getTickCount() - this.lastBlickTick;
            if (ticksSinceBlink < 0L) {
                this.lastBlickTick = -1L;
            }
            if (Config.travelStaffBlinkEnabled && world.field_72995_K && ticksSinceBlink >= (long)Config.travelStaffBlinkPauseTicks && TravelController.instance.doBlink(stack, player)) {
                player.func_71038_i();
                this.lastBlickTick = EnderIO.proxy.getTickCount();
            }
            return stack;
        }
        return super.func_77659_a(stack, world, player);
    }
}

