/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.IIoConfigurable;
import crazypants.enderio.machine.IMachine;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.MachineSound;
import crazypants.enderio.machine.PacketPowerStorage;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.ICapacitor;
import crazypants.enderio.power.IInternalPowerReceptor;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.util.BlockCoord;
import crazypants.util.InventoryWrapper;
import crazypants.util.ItemUtil;
import crazypants.util.Lang;
import crazypants.vecmath.VecmathUtil;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractMachineEntity
extends TileEntityEio
implements ISidedInventory,
IInternalPowerReceptor,
IMachine,
IRedstoneModeControlable,
IIoConfigurable {
    public short facing;
    protected int ticksSinceSync = -1;
    protected boolean forceClientUpdate = true;
    protected boolean lastActive;
    protected int ticksSinceActiveChanged = 0;
    protected float lastSyncPowerStored = -1.0f;
    protected Capacitors capacitorType;
    private int storedEnergyRF;
    protected ItemStack[] inventory;
    protected final SlotDefinition slotDefinition;
    protected RedstoneControlMode redstoneControlMode;
    protected boolean redstoneCheckPassed;
    private boolean redstoneStateDirty = true;
    protected Map<ForgeDirection, IoMode> faceModes;
    private int[] allSlots;
    protected boolean notifyNeighbours = false;
    @SideOnly(value=Side.CLIENT)
    private MachineSound sound;
    private final ResourceLocation soundRes;

    protected static ResourceLocation getSoundFor(String sound) {
        return sound == null ? null : new ResourceLocation("EnderIO:" + sound);
    }

    public AbstractMachineEntity(SlotDefinition slotDefinition) {
        this.slotDefinition = slotDefinition;
        this.facing = (short)3;
        this.capacitorType = Capacitors.BASIC_CAPACITOR;
        this.inventory = new ItemStack[slotDefinition.getNumSlots()];
        this.redstoneControlMode = RedstoneControlMode.IGNORE;
        this.soundRes = AbstractMachineEntity.getSoundFor(this.getSoundName());
        this.allSlots = new int[slotDefinition.getNumSlots()];
        for (int i = 0; i < this.allSlots.length; ++i) {
            this.allSlots[i] = i;
        }
    }

    @Override
    public IoMode toggleIoModeForFace(ForgeDirection faceHit) {
        IoMode curMode = this.getIoMode(faceHit);
        IoMode mode = curMode.next();
        while (!this.supportsMode(faceHit, mode)) {
            mode = mode.next();
        }
        this.setIoMode(faceHit, mode);
        return mode;
    }

    @Override
    public boolean supportsMode(ForgeDirection faceHit, IoMode mode) {
        return true;
    }

    @Override
    public void setIoMode(ForgeDirection faceHit, IoMode mode) {
        if (mode == IoMode.NONE && this.faceModes == null) {
            return;
        }
        if (this.faceModes == null) {
            this.faceModes = new EnumMap<ForgeDirection, IoMode>(ForgeDirection.class);
        }
        this.faceModes.put(faceHit, mode);
        this.forceClientUpdate = true;
        this.notifyNeighbours = true;
        this.updateBlock();
    }

    @Override
    public IoMode getIoMode(ForgeDirection face) {
        if (this.faceModes == null) {
            return IoMode.NONE;
        }
        IoMode res = this.faceModes.get(face);
        if (res == null) {
            return IoMode.NONE;
        }
        return res;
    }

    @Override
    public BlockCoord getLocation() {
        return new BlockCoord(this);
    }

    public SlotDefinition getSlotDefinition() {
        return this.slotDefinition;
    }

    public boolean isValidUpgrade(ItemStack itemstack) {
        for (int i = this.slotDefinition.getMinUpgradeSlot(); i <= this.slotDefinition.getMaxUpgradeSlot(); ++i) {
            if (!this.func_94041_b(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidInput(ItemStack itemstack) {
        for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
            if (!this.func_94041_b(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidOutput(ItemStack itemstack) {
        for (int i = this.slotDefinition.getMinOutputSlot(); i <= this.slotDefinition.getMaxOutputSlot(); ++i) {
            if (!this.func_94041_b(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public final boolean func_94041_b(int i, ItemStack itemstack) {
        if (this.slotDefinition.isUpgradeSlot(i)) {
            return itemstack != null && itemstack.func_77973_b() == EnderIO.itemBasicCapacitor && itemstack.func_77960_j() > 0;
        }
        return this.isMachineItemValidForSlot(i, itemstack);
    }

    protected abstract boolean isMachineItemValidForSlot(int var1, ItemStack var2);

    @Override
    public RedstoneControlMode getRedstoneControlMode() {
        return this.redstoneControlMode;
    }

    @Override
    public void setRedstoneControlMode(RedstoneControlMode redstoneControlMode) {
        this.redstoneControlMode = redstoneControlMode;
        this.redstoneStateDirty = true;
        this.updateBlock();
    }

    public short getFacing() {
        return this.facing;
    }

    public void setFacing(short facing) {
        this.facing = facing;
    }

    public abstract boolean isActive();

    public abstract float getProgress();

    public String getSoundName() {
        return null;
    }

    public boolean hasSound() {
        return this.getSoundName() != null;
    }

    public float getVolume() {
        return Config.machineSoundVolume;
    }

    public float getPitch() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSound() {
        if (Config.machineSoundsEnabled && this.hasSound()) {
            if (this.isActive() && !this.func_145837_r()) {
                if (this.sound == null) {
                    this.sound = new MachineSound(this.soundRes, (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 0.5f, (float)this.field_145849_e + 0.5f, this.getVolume(), this.getPitch());
                    FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
                }
            } else if (this.sound != null) {
                this.sound.endPlaying();
                this.sound = null;
            }
        }
    }

    public int getProgressScaled(int scale) {
        int result = (int)(this.getProgress() * (float)scale);
        return result;
    }

    @Override
    public int getMaxEnergyRecieved(ForgeDirection dir) {
        if (this.isSideDisabled(dir.ordinal())) {
            return 0;
        }
        return this.getCapacitor().getMaxEnergyReceived();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.getCapacitor().getMaxEnergyStored();
    }

    @Override
    public void setEnergyStored(int stored) {
        this.storedEnergyRF = MathHelper.func_76125_a((int)stored, (int)0, (int)this.getMaxEnergyStored());
    }

    public boolean hasPower() {
        return this.storedEnergyRF > 0;
    }

    public ICapacitor getCapacitor() {
        return this.capacitorType.capacitor;
    }

    public int getEnergyStoredScaled(int scale) {
        return VecmathUtil.clamp(Math.round((float)scale * ((float)this.storedEnergyRF / (float)this.getMaxEnergyStored())), 0, scale);
    }

    @Override
    public int getEnergyStored() {
        return this.storedEnergyRF;
    }

    public void setCapacitor(Capacitors capacitorType) {
        this.capacitorType = capacitorType;
        this.forceClientUpdate = true;
        this.setEnergyStored(this.getEnergyStored());
    }

    public int getPowerUsePerTick() {
        return this.getCapacitor().getMaxEnergyExtracted();
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.isSideDisabled(from.ordinal())) {
            return 0;
        }
        return PowerHandlerUtil.recieveInternal(this, maxReceive, from, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return !this.isSideDisabled(from.ordinal());
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaxEnergyStored();
    }

    public void func_145845_h() {
        boolean powerChanged;
        if (this.field_145850_b == null) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.isActive() != this.lastActive) {
                ++this.ticksSinceActiveChanged;
                if (this.ticksSinceActiveChanged > 20 || this.isActive()) {
                    this.ticksSinceActiveChanged = 0;
                    this.lastActive = this.isActive();
                    this.forceClientUpdate = false;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            if (this.hasSound()) {
                this.updateSound();
            }
            if (this.forceClientUpdate) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.forceClientUpdate = false;
            }
            return;
        }
        boolean requiresClientSync = this.forceClientUpdate;
        boolean prevRedCheck = this.redstoneCheckPassed;
        if (this.redstoneStateDirty) {
            this.redstoneCheckPassed = RedstoneControlMode.isConditionMet(this.redstoneControlMode, this);
            this.redstoneStateDirty = false;
        }
        if (this.field_145850_b.func_82737_E() % 5L == 0L) {
            requiresClientSync |= this.doSideIo();
        }
        requiresClientSync |= prevRedCheck != this.redstoneCheckPassed;
        boolean bl = powerChanged = this.lastSyncPowerStored != (float)this.storedEnergyRF && this.field_145850_b.func_82737_E() % 5L == 0L;
        if (requiresClientSync |= this.processTasks(this.redstoneCheckPassed)) {
            this.lastSyncPowerStored = this.storedEnergyRF;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        } else if (powerChanged) {
            this.lastSyncPowerStored = this.storedEnergyRF;
            PacketHandler.sendToAllAround(new PacketPowerStorage(this), this);
        }
        if (this.notifyNeighbours) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            this.notifyNeighbours = false;
        }
    }

    protected boolean doSideIo() {
        if (this.faceModes == null) {
            return false;
        }
        boolean res = false;
        Set<Map.Entry<ForgeDirection, IoMode>> ents = this.faceModes.entrySet();
        for (Map.Entry<ForgeDirection, IoMode> ent : ents) {
            IoMode mode = ent.getValue();
            if (mode.pulls()) {
                res |= this.doPull(ent.getKey());
            }
            if (!mode.pushes()) continue;
            res |= this.doPush(ent.getKey());
        }
        return res;
    }

    protected boolean doPush(ForgeDirection dir) {
        if (this.slotDefinition.getNumOutputSlots() <= 0) {
            return false;
        }
        if (this.field_145850_b.func_82737_E() % 20L != 0L) {
            return false;
        }
        BlockCoord loc = this.getLocation().getLocation(dir);
        TileEntity te = this.field_145850_b.func_147438_o(loc.x, loc.y, loc.z);
        if (te == null) {
            return false;
        }
        for (int i = this.slotDefinition.minOutputSlot; i <= this.slotDefinition.maxOutputSlot; ++i) {
            int num;
            ItemStack item = this.inventory[i];
            if (item == null || (num = ItemUtil.doInsertItem(te, item, dir.getOpposite())) <= 0) continue;
            item.field_77994_a -= num;
            if (item.field_77994_a <= 0) {
                item = null;
            }
            this.inventory[i] = item;
            this.func_70296_d();
        }
        return false;
    }

    protected boolean doPull(ForgeDirection dir) {
        if (this.slotDefinition.getNumInputSlots() <= 0) {
            return false;
        }
        if (this.field_145850_b.func_82737_E() % 20L != 0L) {
            return false;
        }
        boolean hasSpace = false;
        for (int slot = this.slotDefinition.minInputSlot; slot <= this.slotDefinition.maxInputSlot && !hasSpace; ++slot) {
            hasSpace = this.inventory[slot] == null ? true : this.inventory[slot].field_77994_a < this.inventory[slot].func_77976_d();
        }
        if (!hasSpace) {
            return false;
        }
        BlockCoord loc = this.getLocation().getLocation(dir);
        TileEntity te = this.field_145850_b.func_147438_o(loc.x, loc.y, loc.z);
        if (te == null) {
            return false;
        }
        if (!(te instanceof IInventory)) {
            return false;
        }
        Object target = te instanceof ISidedInventory ? (ISidedInventory)te : new InventoryWrapper((IInventory)te);
        int[] targetSlots = target.func_94128_d(dir.getOpposite().ordinal());
        if (targetSlots == null) {
            return false;
        }
        for (int inputSlot = this.slotDefinition.minInputSlot; inputSlot <= this.slotDefinition.maxInputSlot; ++inputSlot) {
            if (!this.doPull(inputSlot, (ISidedInventory)target, targetSlots, dir)) continue;
            return false;
        }
        return false;
    }

    protected boolean doPull(int inputSlot, ISidedInventory target, int[] targetSlots, ForgeDirection side) {
        ItemStack curStack = this.inventory[inputSlot];
        for (int i = 0; i < targetSlots.length; ++i) {
            int res;
            int tSlot = targetSlots[i];
            ItemStack targetStack = target.func_70301_a(tSlot);
            if (targetStack == null || !target.func_102008_b(i, targetStack, side.getOpposite().ordinal()) || (res = ItemUtil.doInsertItem(this, targetStack, side.getOpposite())) <= 0) continue;
            targetStack = targetStack.func_77946_l();
            targetStack.field_77994_a -= res;
            if (targetStack.field_77994_a <= 0) {
                targetStack = null;
            }
            target.func_70299_a(tSlot, targetStack);
            return true;
        }
        return false;
    }

    protected abstract boolean processTasks(boolean var1);

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        this.facing = nbtRoot.func_74765_d("facing");
        this.redstoneCheckPassed = nbtRoot.func_74767_n("redstoneCheckPassed");
        this.forceClientUpdate = nbtRoot.func_74767_n("forceClientUpdate");
        this.readCommon(nbtRoot);
    }

    public void readCommon(NBTTagCompound nbtRoot) {
        int rsContr;
        int energy;
        this.setCapacitor(Capacitors.values()[nbtRoot.func_74765_d("capacitorType")]);
        if (nbtRoot.func_74764_b("storedEnergy")) {
            float storedEnergyMJ = nbtRoot.func_74760_g("storedEnergy");
            energy = (int)(storedEnergyMJ * 10.0f);
        } else {
            energy = nbtRoot.func_74762_e("storedEnergyRF");
        }
        this.setEnergyStored(energy);
        this.inventory = new ItemStack[this.slotDefinition.getNumSlots()];
        NBTTagList itemList = (NBTTagList)nbtRoot.func_74781_a("Items");
        if (itemList != null) {
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                NBTTagCompound itemStack = itemList.func_150305_b(i);
                byte slot = itemStack.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)itemStack);
            }
        }
        if ((rsContr = nbtRoot.func_74762_e("redstoneControlMode")) < 0 || rsContr >= RedstoneControlMode.values().length) {
            rsContr = 0;
        }
        this.redstoneControlMode = RedstoneControlMode.values()[rsContr];
        if (nbtRoot.func_74764_b("hasFaces")) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!nbtRoot.func_74764_b("face" + dir.ordinal())) continue;
                this.setIoMode(dir, IoMode.values()[nbtRoot.func_74765_d("face" + dir.ordinal())]);
            }
        }
    }

    public void readFromItemStack(ItemStack stack) {
        if (stack == null || stack.field_77990_d == null) {
            return;
        }
        NBTTagCompound root = stack.field_77990_d;
        if (!root.func_74764_b("eio.abstractMachine")) {
            return;
        }
        this.readCommon(root);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74777_a("facing", this.facing);
        nbtRoot.func_74757_a("redstoneCheckPassed", this.redstoneCheckPassed);
        nbtRoot.func_74757_a("forceClientUpdate", this.forceClientUpdate);
        this.forceClientUpdate = false;
        this.writeCommon(nbtRoot);
    }

    public void writeCommon(NBTTagCompound nbtRoot) {
        nbtRoot.func_74768_a("storedEnergyRF", this.storedEnergyRF);
        nbtRoot.func_74777_a("capacitorType", (short)this.capacitorType.ordinal());
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound itemStackNBT = new NBTTagCompound();
            itemStackNBT.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(itemStackNBT);
            itemList.func_74742_a((NBTBase)itemStackNBT);
        }
        nbtRoot.func_74782_a("Items", (NBTBase)itemList);
        nbtRoot.func_74768_a("redstoneControlMode", this.redstoneControlMode.ordinal());
        if (this.faceModes != null) {
            nbtRoot.func_74774_a("hasFaces", (byte)1);
            for (Map.Entry<ForgeDirection, IoMode> e : this.faceModes.entrySet()) {
                nbtRoot.func_74777_a("face" + e.getKey().ordinal(), (short)e.getValue().ordinal());
            }
        }
    }

    public void writeToItemStack(ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        NBTTagCompound root = stack.field_77990_d;
        root.func_74757_a("eio.abstractMachine", true);
        this.writeCommon(root);
        String name = stack.func_82837_s() ? stack.func_82833_r() : Lang.localize(stack.func_77977_a() + ".name", false);
        name = name + " " + Lang.localize("machine.tooltip.configured");
        stack.func_151001_c(name);
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public int func_70302_i_() {
        return this.slotDefinition.getNumSlots();
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int fromSlot, int amount) {
        ItemStack fromStack = this.inventory[fromSlot];
        if (fromStack == null) {
            return null;
        }
        if (fromStack.field_77994_a <= amount) {
            this.inventory[fromSlot] = null;
            this.updateCapacitorFromSlot();
            return fromStack;
        }
        ItemStack result = new ItemStack(fromStack.func_77973_b(), amount, fromStack.func_77960_j());
        if (fromStack.field_77990_d != null) {
            result.field_77990_d = (NBTTagCompound)fromStack.field_77990_d.func_74737_b();
        }
        fromStack.field_77994_a -= amount;
        return result;
    }

    public void func_70299_a(int slot, ItemStack contents) {
        this.inventory[slot] = contents == null ? contents : contents.func_77946_l();
        if (contents != null && contents.field_77994_a > this.func_70297_j_()) {
            contents.field_77994_a = this.func_70297_j_();
        }
        if (this.slotDefinition.isUpgradeSlot(slot)) {
            this.updateCapacitorFromSlot();
        }
    }

    private void updateCapacitorFromSlot() {
        if (this.slotDefinition.getNumUpgradeSlots() <= 0) {
            this.setCapacitor(Capacitors.BASIC_CAPACITOR);
            return;
        }
        ItemStack contents = this.inventory[this.slotDefinition.minUpgradeSlot];
        if (contents == null || contents.func_77973_b() != EnderIO.itemBasicCapacitor) {
            this.setCapacitor(Capacitors.BASIC_CAPACITOR);
        } else {
            this.setCapacitor(Capacitors.values()[contents.func_77960_j()]);
        }
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public String func_145825_b() {
        return this.getMachineName();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_94128_d(int var1) {
        if (this.isSideDisabled(var1)) {
            return new int[0];
        }
        return this.allSlots;
    }

    public boolean func_102007_a(int slot, ItemStack var2, int side) {
        if (this.isSideDisabled(side)) {
            return false;
        }
        return this.slotDefinition.isInputSlot(slot) && this.isMachineItemValidForSlot(slot, var2);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        if (this.isSideDisabled(side)) {
            return false;
        }
        if (!this.slotDefinition.isOutputSlot(slot)) {
            return false;
        }
        if (this.inventory[slot] == null || this.inventory[slot].field_77994_a < itemstack.field_77994_a) {
            return false;
        }
        return itemstack.func_77973_b() == this.inventory[slot].func_77973_b();
    }

    public boolean isSideDisabled(int var1) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)var1);
        IoMode mode = this.getIoMode(dir);
        return mode == IoMode.DISABLED;
    }

    public void onNeighborBlockChange(Block blockId) {
        this.redstoneStateDirty = true;
    }

    @Override
    public boolean displayPower() {
        return true;
    }
}

