/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconButtonEIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.IoConfigRenderer;
import crazypants.enderio.gui.RedstoneModeButton;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.GuiOverlayIoConfig;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.gui.GuiContainerBase;
import crazypants.gui.GuiToolTip;
import crazypants.render.RenderUtil;
import crazypants.util.BlockCoord;
import crazypants.util.Lang;
import crazypants.vecmath.Vector4f;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import org.lwjgl.opengl.GL11;

public abstract class GuiMachineBase
extends GuiContainerBase {
    public static final Vector4f PUSH_COLOR = new Vector4f(0.8f, 0.4f, 0.1f, 0.5f);
    public static final Vector4f PULL_COLOR = new Vector4f(0.1f, 0.4f, 0.8f, 0.5f);
    protected static final int POWER_Y = 14;
    protected final int POWER_X = 15;
    protected static final int POWER_WIDTH = 10;
    protected static final int POWER_HEIGHT = 42;
    protected static final int BOTTOM_POWER_Y = 56;
    public static final int BUTTON_SIZE = 16;
    private static final int CONFIG_ID = 8962349;
    private AbstractMachineEntity tileEntity;
    protected RedstoneModeButton redstoneButton;
    private GuiOverlayIoConfig configOverlay;
    protected IconButtonEIO configB;

    public GuiMachineBase(AbstractMachineEntity machine, Container container) {
        super(container);
        this.tileEntity = machine;
        if (this.renderPowerBar()) {
            this.addToolTip(new GuiToolTip(new Rectangle(this.getPowerX(), this.getPowerY(), this.getPowerWidth(), this.getPowerHeight()), new String[]{""}){

                @Override
                protected void updateText() {
                    this.text.clear();
                    if (GuiMachineBase.this.renderPowerBar()) {
                        GuiMachineBase.this.updatePowerBarTooltip(this.text);
                    }
                }
            });
        }
        this.field_146999_f = this.getXSize();
        this.field_147000_g = this.getYSize();
        int x = this.getXSize() - 5 - 16;
        int y = 5;
        this.redstoneButton = new RedstoneModeButton(this, -1, x, y, this.tileEntity, new BlockCoord(this.tileEntity));
        this.configB = new IconButtonEIO(this, 8962349, x, y += 19, IconEIO.IO_CONFIG_UP);
        this.configB.setToolTip(Lang.localize("gui.machine.ioMode.overlay.tooltip"));
        this.configOverlay = new GuiOverlayIoConfig(machine){

            @Override
            public void setVisible(boolean visible) {
                super.setVisible(visible);
                GuiMachineBase.this.configB.setIcon(visible ? IconEIO.IO_CONFIG_DOWN : IconEIO.IO_CONFIG_UP);
            }
        };
        this.addOverlay(this.configOverlay);
    }

    protected boolean showRecipeButton() {
        return EnderIO.proxy.isNeiInstalled();
    }

    protected String getPowerOutputLabel() {
        return "Max: ";
    }

    protected int getPowerOutputValue() {
        return this.tileEntity.getPowerUsePerTick();
    }

    protected void updatePowerBarTooltip(List<String> text) {
        text.add(this.getPowerOutputLabel() + PowerDisplayUtil.formatPower(this.getPowerOutputValue()) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr());
        text.add(PowerDisplayUtil.formatStoredPower(this.tileEntity.getEnergyStored(), this.tileEntity.getCapacitor().getMaxEnergyStored()));
    }

    public void renderSlotHighlights() {
        IoMode mode;
        IoConfigRenderer.SelectedFace sel = this.configOverlay.getSelection();
        if (sel != null && (mode = sel.config.getIoMode(sel.face)) != null) {
            this.renderSlotHighlights(mode);
        }
    }

    public void renderSlotHighlights(IoMode mode) {
        int slot;
        SlotDefinition slotDef = this.tileEntity.getSlotDefinition();
        if (slotDef.getNumInputSlots() > 0 && (mode == IoMode.PULL || mode == IoMode.PUSH_PULL)) {
            for (slot = slotDef.getMinInputSlot(); slot <= slotDef.getMaxInputSlot(); ++slot) {
                this.renderSlotHighlight(slot, PULL_COLOR);
            }
        }
        if (slotDef.getNumOutputSlots() > 0 && (mode == IoMode.PUSH || mode == IoMode.PUSH_PULL)) {
            for (slot = slotDef.getMinOutputSlot(); slot <= slotDef.getMaxOutputSlot(); ++slot) {
                this.renderSlotHighlight(slot, PUSH_COLOR);
            }
        }
    }

    protected void renderSlotHighlight(int slot, Vector4f col) {
        Slot invSlot = (Slot)this.field_147002_h.field_75151_b.get(slot);
        this.renderSlotHighlight(col, invSlot.field_75223_e, invSlot.field_75221_f, 16, 16);
    }

    protected void renderSlotHighlight(Vector4f col, int x, int y, int width, int height) {
        GL11.glEnable((int)3042);
        RenderUtil.renderQuad2D((double)(this.getGuiLeft() + x), (double)(this.getGuiTop() + y), 0.0, (double)width, (double)height, col);
        GL11.glDisable((int)3042);
    }

    public void renderPowerBar(int k, int l) {
        if (this.renderPowerBar()) {
            int i1 = this.tileEntity.getEnergyStoredScaled(this.getPowerHeight());
            this.func_73729_b(k + this.getPowerX(), l + (this.getPowerY() + this.getPowerHeight()) - i1, this.getPowerU(), this.getPowerV(), this.getPowerWidth(), i1);
        }
    }

    protected int getPowerX() {
        return 15;
    }

    protected int getPowerY() {
        return 14;
    }

    protected int getPowerWidth() {
        return 10;
    }

    protected int getPowerHeight() {
        return 42;
    }

    protected void func_146284_a(GuiButton b) {
        super.func_146284_a(b);
        if (b.field_146127_k == 8962349) {
            boolean vis = !this.configOverlay.isVisible();
            this.configOverlay.setVisible(vis);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.redstoneButton.onGuiInit();
        this.configB.onGuiInit();
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.renderPowerBar(k, l);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(i);
            guibutton.func_146112_a(this.field_146297_k, 0, 0);
        }
        if (this.showRecipeButton()) {
            IconEIO.RECIPE.renderIcon(k + 155, l + 43, 16.0, 16.0, 0.0, true);
        }
        this.renderSlotHighlights();
    }

    protected int getPowerV() {
        return 31;
    }

    protected int getPowerU() {
        return 176;
    }

    protected boolean renderPowerBar() {
        return true;
    }
}

