/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class MachineRecipeInput {
    public final int slotNumber;
    public final ItemStack item;
    public final FluidStack fluid;

    public static ItemStack getInputForSlot(int slot, MachineRecipeInput ... inputs) {
        for (MachineRecipeInput ri : inputs) {
            if (ri.slotNumber != slot) continue;
            return ri.item;
        }
        return null;
    }

    public static MachineRecipeInput create(int slotNumber, ItemStack item) {
        return new MachineRecipeInput(slotNumber, item);
    }

    public MachineRecipeInput(int slotNumber, ItemStack item) {
        this.slotNumber = slotNumber;
        this.item = item;
        this.fluid = null;
    }

    public MachineRecipeInput(int slotNumber, FluidStack fluid) {
        this.slotNumber = slotNumber;
        this.item = null;
        this.fluid = fluid;
    }

    public MachineRecipeInput(int slotNumber, ItemStack item, FluidStack fluid) {
        this.slotNumber = slotNumber;
        this.item = item;
        this.fluid = fluid;
    }

    public static MachineRecipeInput readFromNBT(NBTTagCompound root) {
        int slotNum = root.func_74762_e("slotNum");
        ItemStack item = null;
        FluidStack fluid = null;
        if (root.func_74764_b("itemStack")) {
            NBTTagCompound stackRoot = root.func_74775_l("itemStack");
            item = ItemStack.func_77949_a((NBTTagCompound)stackRoot);
        } else if (root.func_74764_b("fluidStack")) {
            NBTTagCompound stackRoot = root.func_74775_l("fluidStack");
            fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stackRoot);
        }
        return new MachineRecipeInput(slotNum, item, fluid);
    }

    public void writeToNbt(NBTTagCompound root) {
        if (this.item != null) {
            NBTTagCompound stackRoot = new NBTTagCompound();
            this.item.func_77955_b(stackRoot);
            root.func_74782_a("itemStack", (NBTBase)stackRoot);
        } else if (this.fluid != null) {
            NBTTagCompound stackRoot = new NBTTagCompound();
            this.fluid.writeToNBT(stackRoot);
            root.func_74782_a("fluidStack", (NBTBase)stackRoot);
        }
        root.func_74768_a("slotNum", this.slotNumber);
    }

    public boolean isFluid() {
        return this.fluid != null;
    }
}

