/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.attractor;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.attractor.BlockAttractor;
import crazypants.enderio.machine.generator.combustion.TranslatedCubeRenderer;
import crazypants.enderio.material.Material;
import crazypants.render.BoundingBox;
import crazypants.render.CubeRenderer;
import crazypants.render.VertexTransform;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vector3f;
import crazypants.vecmath.Vertex;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class AttractorRenderer
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    private VertXForm xform = new VertXForm();
    private VertXForm2 xform2 = new VertXForm2();
    private ItemStack floatingStack;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)-2.0f, (float)3.0f, (float)0.0f);
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderInventoryBlock((Block)EnderIO.blockAttractor, item.func_77960_j(), 0, (RenderBlocks)data[0]);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            float scale = 0.4f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glTranslatef((float)12.0f, (float)2.0f, (float)0.0f);
            RenderItem ri = new RenderItem();
            ri.func_82406_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().field_71446_o, this.getFloatingStack(null, 0.0, 0.0, 0.0, 0.0f), 0, 0);
            GL11.glPopMatrix();
            GL11.glEnable((int)2896);
        } else {
            GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            this.renderInventoryBlock((Block)EnderIO.blockAttractor, item.func_77960_j(), 0, (RenderBlocks)data[0]);
        }
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float tick) {
        World world = te.func_145831_w();
        float f = world.func_72957_l(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        int l = world.func_72802_i(te.field_145851_c, te.field_145848_d, te.field_145849_e, 0);
        int l1 = l % 65536;
        int l2 = l / 65536;
        Tessellator.field_78398_a.func_78386_a(f, f, f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)l1, (float)l2);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glPopMatrix();
        EntityItem ei = new EntityItem(world, x, y, z, this.getFloatingStack(te, x, y, z, tick));
        ei.field_70292_b = (int)world.func_82737_E();
        float bob = ((float)ei.field_70292_b + tick) / 10.0f;
        ei.field_70290_d = -bob;
        RenderManager.field_78727_a.func_78713_a((Entity)ei).func_76986_a((Entity)ei, x + 0.5, y + 0.55, z + 0.5, 0.0f, tick);
    }

    protected ItemStack getFloatingStack(TileEntity te, double x, double y, double z, float tick) {
        if (this.floatingStack == null) {
            this.floatingStack = new ItemStack((Item)EnderIO.itemMaterial, 1, Material.ATTRACTOR_CRYSTAL.ordinal());
        }
        return this.floatingStack;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glDisable((int)2896);
        Tessellator.field_78398_a.func_78382_b();
        this.renderWorldBlock(null, 0, 0, 0, block, 0, renderer);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glEnable((int)2896);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        BoundingBox bb = BoundingBox.UNIT_CUBE;
        TranslatedCubeRenderer.instance.renderBoundingBox(x, y, z, block, bb, this.xform, null, world != null);
        Tessellator.field_78398_a.func_78372_c((float)x, (float)y, (float)z);
        IIcon icon = EnderIO.blockAttractor.getOnIcon();
        if (world != null) {
            icon = block.func_149673_e(world, x, y, z, 0);
        }
        float height = 0.475f;
        float width = 0.5f;
        bb = BoundingBox.UNIT_CUBE.scale(width, height, 1.0f).translate(0.0f, -0.5f + height / 2.0f, 0.0f);
        this.xform2.isX = false;
        CubeRenderer.render(bb, icon, (VertexTransform)this.xform2, true);
        bb = BoundingBox.UNIT_CUBE.scale(1.0f, height, width).translate(0.0f, -0.5f + height / 2.0f, 0.0f);
        this.xform2.isX = true;
        CubeRenderer.render(bb, icon, (VertexTransform)this.xform2, true);
        Tessellator.field_78398_a.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockAttractor.renderId;
    }

    private static class VertXForm2
    implements VertexTransform {
        boolean isX = true;

        @Override
        public void apply(Vertex vertex) {
            this.apply(vertex.xyz);
        }

        @Override
        public void apply(Vector3d vec) {
            double pinch = 0.9;
            if (vec.y > 0.2) {
                pinch = 0.5;
            }
            if (this.isX) {
                vec.x -= 0.5;
                vec.x *= pinch;
                vec.x += 0.5;
            } else {
                vec.z -= 0.5;
                vec.z *= pinch;
                vec.z += 0.5;
            }
        }

        @Override
        public void applyToNormal(Vector3f vec) {
        }
    }

    private static class VertXForm
    implements VertexTransform {
        @Override
        public void apply(Vertex vertex) {
            this.apply(vertex.xyz);
        }

        @Override
        public void apply(Vector3d vec) {
            double pinch = 0.8;
            if (vec.y > 0.5) {
                pinch = 0.4;
            }
            vec.x -= 0.5;
            vec.x *= pinch;
            vec.x += 0.5;
            vec.z -= 0.5;
            vec.z *= pinch;
            vec.z += 0.5;
            double scale = 0.5;
            vec.y -= 0.5;
            vec.y *= scale;
            vec.y += 0.5 * scale;
        }

        @Override
        public void applyToNormal(Vector3f vec) {
        }
    }
}

