/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.attractor;

import com.mojang.authlib.GameProfile;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.ICapacitor;
import crazypants.render.BoundingBox;
import crazypants.util.BlockCoord;
import crazypants.vecmath.Vector3d;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.FakePlayer;

public class TileAttractor
extends AbstractMachineEntity {
    private AxisAlignedBB attractorBounds;
    private FakePlayer target;
    private int rangeSqu;
    private int range;
    private int powerPerTick;
    private Set<EntityLiving> tracking = new HashSet<EntityLiving>();
    private int tickCounter = 0;
    private int maxMobsAttracted = 20;
    private ICapacitor capacitor;

    public TileAttractor() {
        super(new SlotDefinition(12, 0));
        this.setUpdrade(Capacitors.BASIC_CAPACITOR);
    }

    @Override
    public void setCapacitor(Capacitors capacitorType) {
        this.setUpdrade(capacitorType);
        super.setCapacitor(capacitorType);
    }

    @Override
    public ICapacitor getCapacitor() {
        return this.capacitor;
    }

    public int getRange() {
        return this.range;
    }

    private void setUpdrade(Capacitors capacitorType) {
        switch (capacitorType) {
            case ACTIVATED_CAPACITOR: {
                this.range = Config.attractorRangeLevelTwo;
                this.powerPerTick = Config.attractorPowerPerTickLevelTwo;
                break;
            }
            case ENDER_CAPACITOR: {
                this.range = Config.attractorRangeLevelThree;
                this.powerPerTick = Config.attractorPowerPerTickLevelThree;
                break;
            }
            default: {
                this.range = Config.attractorRangeLevelOne;
                this.powerPerTick = Config.attractorPowerPerTickLevelOne;
            }
        }
        this.rangeSqu = this.range * this.range;
        BoundingBox bb = new BoundingBox(new BlockCoord(this));
        bb = bb.scale(this.range, this.range, this.range);
        this.attractorBounds = AxisAlignedBB.func_72330_a((double)bb.minX, (double)bb.minY, (double)bb.minZ, (double)bb.maxX, (double)bb.maxY, (double)bb.maxZ);
        this.capacitor = new BasicCapacitor(this.powerPerTick * 8, capacitorType.capacitor.getMaxEnergyStored(), this.powerPerTick);
    }

    @Override
    public String getMachineName() {
        return ModObject.blockAttractor.unlocalisedName;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (!this.slotDefinition.isInputSlot(i)) {
            return false;
        }
        String mob = EnderIO.itemSoulVessel.getMobTypeFromStack(itemstack);
        if (mob == null) {
            return false;
        }
        Class cl = (Class)EntityList.field_75625_b.get(mob);
        if (cl == null) {
            return false;
        }
        return EntityLiving.class.isAssignableFrom(cl);
    }

    @Override
    public boolean isActive() {
        return this.hasPower();
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        if (!redstoneCheckPassed || !this.hasPower()) {
            return false;
        }
        this.usePower();
        ++this.tickCounter;
        if (this.tickCounter < 10) {
            for (EntityLiving ent : this.tracking) {
                this.onEntityTick(ent);
            }
            return false;
        }
        this.tickCounter = 0;
        HashSet<EntityLiving> trackingThisTick = new HashSet<EntityLiving>();
        List entsInBounds = this.field_145850_b.func_72872_a(EntityLiving.class, this.attractorBounds);
        int candidates = 0;
        for (EntityLiving ent : entsInBounds) {
            if (ent.field_70128_L || !this.isMobInFilter(ent)) continue;
            ++candidates;
            if (this.tracking.contains(ent)) {
                trackingThisTick.add(ent);
                this.onEntityTick(ent);
                continue;
            }
            if (this.tracking.size() >= this.maxMobsAttracted || !this.trackMob(ent)) continue;
            trackingThisTick.add(ent);
        }
        this.tracking.clear();
        this.tracking = trackingThisTick;
        return false;
    }

    protected double usePower() {
        return this.usePower(this.getPowerUsePerTick());
    }

    protected int usePower(int wantToUse) {
        int used = Math.min(this.getEnergyStored(), wantToUse);
        this.setEnergyStored(Math.max(0, this.getEnergyStored() - used));
        return used;
    }

    @Override
    public int getPowerUsePerTick() {
        return this.powerPerTick;
    }

    FakePlayer getTarget() {
        if (this.target == null) {
            this.target = new Target();
        }
        return this.target;
    }

    public boolean canAttract(String entityId, EntityLiving mob) {
        return this.redstoneCheckPassed && this.hasPower() && this.isMobInFilter(entityId) && this.isMobInRange(mob);
    }

    private boolean isMobInRange(EntityLiving mob) {
        return this.isMobInRange(mob, this.rangeSqu);
    }

    private boolean isMobInRange(EntityLiving mob, int range) {
        if (mob == null) {
            return false;
        }
        return new Vector3d(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v).distanceSquared(new Vector3d(this.field_145851_c, this.field_145848_d, this.field_145849_e)) <= (double)range;
    }

    private boolean isMobInFilter(EntityLiving ent) {
        return this.isMobInFilter(EntityList.func_75621_b((Entity)ent));
    }

    private boolean isMobInFilter(String entityId) {
        for (int i = this.slotDefinition.minInputSlot; i <= this.slotDefinition.maxInputSlot; ++i) {
            String mob;
            if (this.inventory[i] == null || (mob = EnderIO.itemSoulVessel.getMobTypeFromStack(this.inventory[i])) == null || !mob.equals(entityId)) continue;
            return true;
        }
        return false;
    }

    private boolean trackMob(EntityLiving ent) {
        if (this.useSetTarget(ent)) {
            ((EntityMob)ent).func_70784_b((Entity)this.getTarget());
            return true;
        }
        if (this.useSpecialCase(ent)) {
            return this.applySpecialCase(ent);
        }
        return this.attractyUsingAITask(ent);
    }

    private boolean attractyUsingAITask(EntityLiving ent) {
        this.tracking.add(ent);
        List entries = ent.field_70714_bg.field_75782_a;
        boolean hasTask = false;
        EntityAIBase remove = null;
        for (EntityAITasks.EntityAITaskEntry entry : entries) {
            if (!(entry.field_75733_a instanceof AttractTask)) continue;
            AttractTask at = (AttractTask)entry.field_75733_a;
            if (at.coord.equals(new BlockCoord(this)) || !at.func_75253_b()) {
                remove = entry.field_75733_a;
                continue;
            }
            return false;
        }
        if (remove != null) {
            ent.field_70714_bg.func_85156_a(remove);
        }
        this.cancelCurrentTasks(ent);
        ent.field_70714_bg.func_75776_a(0, (EntityAIBase)new AttractTask(ent, this.getTarget(), new BlockCoord(this)));
        return true;
    }

    private void cancelCurrentTasks(EntityLiving ent) {
        Iterator iterator = ent.field_70714_bg.field_75782_a.iterator();
        ArrayList<EntityAITasks.EntityAITaskEntry> currentTasks = new ArrayList<EntityAITasks.EntityAITaskEntry>();
        while (iterator.hasNext()) {
            EntityAITasks.EntityAITaskEntry entityaitaskentry = (EntityAITasks.EntityAITaskEntry)iterator.next();
            if (entityaitaskentry == null) continue;
            currentTasks.add(entityaitaskentry);
        }
        for (EntityAITasks.EntityAITaskEntry task : currentTasks) {
            ent.field_70714_bg.func_85156_a(task.field_75733_a);
            ent.field_70714_bg.func_75776_a(task.field_75731_b, task.field_75733_a);
        }
    }

    private boolean applySpecialCase(EntityLiving ent) {
        return ent instanceof EntitySlime || ent instanceof EntitySilverfish || ent instanceof EntityBlaze;
    }

    private boolean useSpecialCase(EntityLiving ent) {
        if (ent instanceof EntitySlime) {
            ent.func_70625_a((Entity)this.getTarget(), 10.0f, 20.0f);
            return true;
        }
        if (ent instanceof EntitySilverfish) {
            PathEntity pathentity = this.field_145850_b.func_72865_a((Entity)ent, (Entity)this.getTarget(), (float)this.getRange(), true, false, false, true);
            ((EntityCreature)ent).func_70778_a(pathentity);
            return true;
        }
        return ent instanceof EntityBlaze;
    }

    private void onEntityTick(EntityLiving ent) {
        if (ent instanceof EntitySlime) {
            ent.func_70625_a((Entity)this.getTarget(), 10.0f, 20.0f);
        } else if (ent instanceof EntitySilverfish) {
            if (this.tickCounter < 10) {
                return;
            }
            EntitySilverfish sf = (EntitySilverfish)ent;
            PathEntity pathentity = this.field_145850_b.func_72865_a((Entity)ent, (Entity)this.getTarget(), (float)this.getRange(), true, false, false, true);
            sf.func_70778_a(pathentity);
        } else if (ent instanceof EntityBlaze) {
            EntityBlaze mob = (EntityBlaze)ent;
            double x = (double)this.field_145851_c + 0.5 - ent.field_70165_t;
            double y = (double)this.field_145848_d + 1.0 - ent.field_70163_u;
            double z = (double)this.field_145849_e + 0.5 - ent.field_70161_v;
            double distance = Math.sqrt(x * x + y * y + z * z);
            if (distance > 1.25) {
                double speed = 0.01;
                ent.field_70159_w += x / distance * speed;
                if (y > 0.0) {
                    ent.field_70181_x += ((double)0.3f - ent.field_70181_x) * (double)0.3f;
                }
                ent.field_70179_y += z / distance * speed;
            }
        } else if (ent instanceof EntityPigZombie || ent instanceof EntitySpider) {
            this.forceMove(ent);
        }
    }

    private void forceMove(EntityLiving ent) {
        double x = (double)this.field_145851_c + 0.5 - ent.field_70165_t;
        double y = (double)this.field_145848_d + 1.0 - ent.field_70163_u;
        double z = (double)this.field_145849_e + 0.5 - ent.field_70161_v;
        double distance = Math.sqrt(x * x + y * y + z * z);
        if (distance > 2.0) {
            EntityMob mod = (EntityMob)ent;
            mod.func_70625_a((Entity)this.getTarget(), 180.0f, 0.0f);
            mod.func_70612_e(0.0f, 1.0f);
            if (mod.field_70163_u < (double)this.field_145848_d) {
                mod.func_70637_d(true);
            } else {
                mod.func_70637_d(false);
            }
        }
    }

    private boolean useSetTarget(EntityLiving ent) {
        return ent instanceof EntityEnderman || ent instanceof EntityPigZombie || ent instanceof EntitySpider || ent instanceof EntitySilverfish;
    }

    private static class AttractTask
    extends EntityAIBase {
        private EntityLiving mob;
        private BlockCoord coord;
        private FakePlayer target;
        private String entityId;
        private int updatesSincePathing;
        private boolean started = false;

        private AttractTask(EntityLiving mob, FakePlayer target, BlockCoord coord) {
            this.mob = mob;
            this.coord = coord;
            this.target = target;
            this.entityId = EntityList.func_75621_b((Entity)mob);
        }

        public boolean func_75250_a() {
            return this.func_75253_b();
        }

        public void func_75251_c() {
            this.started = false;
            this.updatesSincePathing = 0;
        }

        public boolean func_75253_b() {
            boolean res = false;
            TileEntity te = this.mob.field_70170_p.func_147438_o(this.coord.x, this.coord.y, this.coord.z);
            if (te instanceof TileAttractor) {
                TileAttractor attractor = (TileAttractor)te;
                res = attractor.canAttract(this.entityId, this.mob);
            }
            return res;
        }

        public boolean func_75252_g() {
            return true;
        }

        public void func_75246_d() {
            if (!this.started || this.updatesSincePathing > 20) {
                this.started = true;
                boolean speed = true;
                this.mob.func_70661_as().func_75491_a(false);
                boolean res = this.mob.func_70661_as().func_75497_a((Entity)this.target, (double)speed);
                if (!res) {
                    this.mob.func_70661_as().func_75492_a(this.target.field_70165_t, this.target.field_70163_u + 1.0, this.target.field_70161_v, (double)speed);
                }
                this.updatesSincePathing = 0;
            } else {
                ++this.updatesSincePathing;
            }
        }
    }

    private class Target
    extends FakePlayer {
        ItemStack prevWeapon;

        public Target() {
            super(MinecraftServer.func_71276_C().func_71218_a(TileAttractor.this.func_145831_w().field_73011_w.field_76574_g), new GameProfile(null, ModObject.blockAttractor.unlocalisedName + ":" + TileAttractor.this.getLocation()));
            this.field_70165_t = (double)TileAttractor.this.field_145851_c + 0.5;
            this.field_70163_u = (double)TileAttractor.this.field_145848_d + 1.5;
            this.field_70161_v = (double)TileAttractor.this.field_145849_e + 0.5;
        }
    }
}

