/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.crafter;

import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.crafter.DummyCraftingGrid;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.ICapacitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileCrafter
extends AbstractMachineEntity {
    DummyCraftingGrid craftingGrid = new DummyCraftingGrid();
    private List<ItemStack> containerItems = new ArrayList<ItemStack>();
    private ICapacitor capacitor;

    public TileCrafter() {
        super(new SlotDefinition(9, 1));
        this.setCapacitor(Capacitors.BASIC_CAPACITOR);
    }

    @Override
    public ICapacitor getCapacitor() {
        return this.capacitor;
    }

    @Override
    public void setCapacitor(Capacitors capacitorType) {
        ICapacitor refCap = capacitorType.capacitor;
        int maxUse = this.getPowerUsePerTick(capacitorType);
        int io = Math.max(maxUse, refCap.getMaxEnergyExtracted());
        this.capacitor = new BasicCapacitor(io * 4, refCap.getMaxEnergyStored(), io);
        super.setCapacitor(capacitorType);
    }

    @Override
    public String getMachineName() {
        return ModObject.blockCrafter.unlocalisedName;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int slot, ItemStack itemstack) {
        if (!this.slotDefinition.isInputSlot(slot)) {
            return false;
        }
        return this.craftingGrid.inv[slot] != null && this.craftingGrid.inv[slot].func_77969_a(itemstack);
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public float getProgress() {
        return 0.5f;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        if (!(redstoneCheckPassed && this.craftingGrid.hasValidRecipe() && this.canMergeOutput() && this.hasRequiredPower())) {
            return false;
        }
        int ticksPerCraft = this.getTicksPerCraft(this.capacitorType);
        if (this.field_145850_b.func_82737_E() % (long)ticksPerCraft != 0L) {
            return false;
        }
        if (!this.containerItems.isEmpty()) {
            Iterator<ItemStack> iter = this.containerItems.iterator();
            while (iter.hasNext()) {
                ItemStack stack = iter.next();
                if (this.inventory[9] == null) {
                    this.inventory[9] = stack;
                    iter.remove();
                    continue;
                }
                if (!ItemStack.func_77989_b((ItemStack)this.inventory[9], (ItemStack)stack) || this.inventory[9].field_77994_a + stack.field_77994_a > this.inventory[9].func_77976_d()) continue;
                this.inventory[9].field_77994_a += stack.field_77994_a;
                iter.remove();
            }
            return false;
        }
        ArrayList<ItemStack> required = new ArrayList<ItemStack>();
        this.craftingGrid.copyRequiredInputs(required);
        if (this.hasRequiredInput(required)) {
            this.craftRecipe();
            int used = Math.min(this.getEnergyStored(), Config.crafterRfPerCraft);
            this.setEnergyStored(this.getEnergyStored() - used);
        }
        return false;
    }

    private boolean hasRequiredPower() {
        return this.getEnergyStored() >= Config.crafterRfPerCraft;
    }

    @Override
    public int getPowerUsePerTick() {
        return this.getPowerUsePerTick(this.capacitorType);
    }

    public int getPowerUsePerTick(Capacitors type) {
        int ticks = this.getTicksPerCraft(type);
        return (int)Math.ceil((double)Config.crafterRfPerCraft / (double)ticks);
    }

    public int getTicksPerCraft(Capacitors type) {
        if (type == Capacitors.BASIC_CAPACITOR) {
            return 20;
        }
        if (type == Capacitors.ACTIVATED_CAPACITOR) {
            return 10;
        }
        return 2;
    }

    private void craftRecipe() {
        ArrayList<ItemStack> required = new ArrayList<ItemStack>();
        this.craftingGrid.copyRequiredInputs(required);
        for (ItemStack req : required) {
            for (int i = 0; i < 9 && req.field_77994_a > 0; ++i) {
                ItemStack used;
                ItemStack avail = this.inventory[i];
                if (avail == null || avail.field_77994_a <= 0 || !avail.func_77969_a(req)) continue;
                --req.field_77994_a;
                avail = avail.func_77946_l();
                --avail.field_77994_a;
                if (avail.field_77994_a <= 0 && (used = avail.func_77973_b().getContainerItem(avail)) != null) {
                    if (used.func_77969_a(avail)) {
                        ++avail.field_77994_a;
                    } else {
                        this.containerItems.add(used.func_77946_l());
                        avail = null;
                    }
                }
                if (avail != null && avail.field_77994_a == 0) {
                    avail = null;
                }
                this.func_70299_a(i, avail);
            }
        }
        ItemStack output = this.craftingGrid.getOutput().func_77946_l();
        if (this.inventory[9] == null) {
            this.func_70299_a(9, output);
        } else {
            ItemStack cur = this.inventory[9].func_77946_l();
            cur.field_77994_a += output.field_77994_a;
            this.func_70299_a(9, cur);
        }
    }

    private boolean canMergeOutput() {
        if (this.inventory[9] == null) {
            return true;
        }
        ItemStack output = this.craftingGrid.getOutput();
        if (!this.inventory[9].func_77969_a(output)) {
            return false;
        }
        return output.func_77976_d() >= this.inventory[9].field_77994_a + output.field_77994_a;
    }

    private boolean hasRequiredInput(List<ItemStack> required) {
        ArrayList<ItemStack> available = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            ItemStack is = this.inventory[i];
            if (is == null) continue;
            available.add(is.func_77946_l());
        }
        for (ItemStack req : required) {
            boolean foundReq = false;
            for (ItemStack avail : available) {
                if (!req.func_77969_a(avail) || avail.field_77994_a <= 0) continue;
                --avail.field_77994_a;
                foundReq = true;
                break;
            }
            if (foundReq) continue;
            return false;
        }
        return true;
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        NBTTagCompound craftRoot = nbtRoot.func_74775_l("craftingGrid");
        this.craftingGrid.readFromNBT(craftRoot);
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        NBTTagCompound craftingRoot = new NBTTagCompound();
        this.craftingGrid.writeToNBT(craftingRoot);
        nbtRoot.func_74782_a("craftingGrid", (NBTBase)craftingRoot);
    }

    public void updateCraftingOutput() {
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.func_70299_a(i, this.craftingGrid.func_70301_a(i));
        }
        ItemStack matches = CraftingManager.func_77594_a().func_82787_a(inv, this.field_145850_b);
        this.craftingGrid.func_70299_a(9, matches);
        this.func_70296_d();
    }
}

