/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.enchanter;

import cpw.mods.fml.common.network.IGuiHandler;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.gui.IResourceTooltipProvider;
import crazypants.enderio.machine.enchanter.ContainerEnchanter;
import crazypants.enderio.machine.enchanter.GuiEnchanter;
import crazypants.enderio.machine.enchanter.TileEnchanter;
import crazypants.enderio.tool.ITool;
import crazypants.enderio.tool.ToolUtil;
import crazypants.util.Util;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockEnchanter
extends BlockEio
implements IGuiHandler,
IResourceTooltipProvider {
    public static int renderId = -1;

    public static BlockEnchanter create() {
        BlockEnchanter res = new BlockEnchanter();
        res.init();
        return res;
    }

    protected BlockEnchanter() {
        super(ModObject.blockEnchanter.unlocalisedName, TileEnchanter.class);
        this.func_149658_d("enderio:blockEnchanter");
        this.func_149713_g(4);
    }

    @Override
    protected void init() {
        super.init();
        EnderIO.guiHandler.registerGuiHandler(91, this);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        super.func_149689_a(world, x, y, z, player, stack);
        int heading = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileEnchanter te = (TileEnchanter)world.func_147438_o(x, y, z);
        switch (heading) {
            case 0: {
                te.setFacing((short)2);
                break;
            }
            case 1: {
                te.setFacing((short)5);
                break;
            }
            case 2: {
                te.setFacing((short)3);
                break;
            }
            case 3: {
                te.setFacing((short)4);
                break;
            }
        }
        if (world.field_72995_K) {
            return;
        }
        world.func_147471_g(x, y, z);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float par7, float par8, float par9) {
        ITool tool = ToolUtil.getEquippedTool(entityPlayer);
        if (tool != null && entityPlayer.func_70093_af() && tool.canUse(entityPlayer.func_71045_bC(), entityPlayer, x, y, z)) {
            this.removedByPlayer(world, entityPlayer, x, y, z, false);
            tool.used(entityPlayer.func_71045_bC(), entityPlayer, x, y, z);
            return true;
        }
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K) {
            entityPlayer.openGui((Object)EnderIO.instance, 91, world, x, y, z);
        }
        return true;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harvested) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof TileEnchanter) {
            TileEnchanter enchanter = (TileEnchanter)te;
            if (!player.field_71075_bZ.field_75098_d) {
                ItemStack itemStack = new ItemStack((Block)this);
                float f = 0.7f;
                double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, itemStack);
                entityitem.field_145804_b = 10;
                world.func_72838_d((Entity)entityitem);
                if (enchanter.func_70301_a(0) != null) {
                    Util.dropItems(world, enchanter.func_70301_a(0), x, y, z, true);
                }
                if (enchanter.func_70301_a(1) != null) {
                    Util.dropItems(world, enchanter.func_70301_a(1), x, y, z, true);
                }
            }
        }
        return super.removedByPlayer(world, player, x, y, z, harvested);
    }

    public int func_149745_a(Random p_149745_1_) {
        return 0;
    }

    public int func_149645_b() {
        return renderId;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEnchanter) {
            return new ContainerEnchanter(player, player.field_71071_by, (TileEnchanter)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEnchanter) {
            return new GuiEnchanter(player, player.field_71071_by, (TileEnchanter)te);
        }
        return null;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int p_149749_6_) {
        super.func_149749_a(world, x, y, z, block, p_149749_6_);
        world.func_147475_p(x, y, z);
    }

    @Override
    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_149739_a();
    }
}

