/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.enchanter;

import crazypants.enderio.machine.recipe.RecipeInput;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;

public class EnchanterRecipe {
    private final RecipeInput input;
    private final Enchantment enchantment;
    private final int costPerLevel;

    public static Enchantment getEnchantmentFromName(String enchantmentName) {
        for (Enchantment ench : Enchantment.field_77331_b) {
            if (ench == null || ench.func_77320_a() == null || !ench.func_77320_a().equals(enchantmentName)) continue;
            return ench;
        }
        return null;
    }

    public EnchanterRecipe(RecipeInput curInput, String enchantmentName, int costPerLevel) {
        this.input = curInput;
        this.enchantment = EnchanterRecipe.getEnchantmentFromName(enchantmentName);
        this.costPerLevel = costPerLevel;
    }

    public EnchanterRecipe(RecipeInput input, Enchantment enchantment, int costPerLevel) {
        this.input = input;
        this.enchantment = enchantment;
        this.costPerLevel = costPerLevel;
    }

    public boolean isInput(ItemStack stack) {
        if (stack == null || !this.isValid()) {
            return false;
        }
        return this.input.isInput(stack);
    }

    public boolean isValid() {
        return this.enchantment != null && this.input != null && this.input.getInput() != null && this.costPerLevel > -1;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public RecipeInput getInput() {
        return this.input;
    }

    public int getCostPerLevel() {
        return this.costPerLevel;
    }
}

