/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm;

import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.machine.farm.farmers.CustomSeedFarmer;
import crazypants.enderio.machine.farm.farmers.FarmersCommune;
import crazypants.enderio.machine.farm.farmers.MelonFarmer;
import crazypants.enderio.machine.farm.farmers.NaturaBerryFarmer;
import crazypants.enderio.machine.farm.farmers.NetherWartFarmer;
import crazypants.enderio.machine.farm.farmers.PickableFarmer;
import crazypants.enderio.machine.farm.farmers.PlantableFarmer;
import crazypants.enderio.machine.farm.farmers.RubberTreeFarmerIC2;
import crazypants.enderio.machine.farm.farmers.StemFarmer;
import crazypants.enderio.machine.farm.farmers.TreeFarmer;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class FarmersRegistry {
    public static final PlantableFarmer DEFAULT_FARMER = new PlantableFarmer();

    public static void addFarmers() {
        FarmersRegistry.addExtraUtilities();
        FarmersRegistry.addNutura();
        FarmersRegistry.addTiC();
        FarmersRegistry.addStillHungry();
        FarmersRegistry.addIC2();
        FarmersRegistry.addMFR();
        FarmersCommune.joinCommune(new StemFarmer(Blocks.field_150436_aH, new ItemStack(Items.field_151120_aE)));
        FarmersCommune.joinCommune(new StemFarmer(Blocks.field_150434_aF, new ItemStack(Blocks.field_150434_aF)));
        FarmersCommune.joinCommune(new TreeFarmer(Blocks.field_150345_g, Blocks.field_150364_r));
        FarmersCommune.joinCommune(new TreeFarmer(Blocks.field_150345_g, Blocks.field_150363_s));
        FarmersCommune.joinCommune(new MelonFarmer(Blocks.field_150394_bc, Blocks.field_150440_ba, new ItemStack(Items.field_151081_bc)));
        FarmersCommune.joinCommune(new MelonFarmer(Blocks.field_150393_bb, Blocks.field_150423_aK, new ItemStack(Items.field_151080_bb)));
        FarmersCommune.joinCommune(new NetherWartFarmer());
        FarmersCommune.joinCommune(DEFAULT_FARMER);
    }

    public static void addPickable(String mod, String blockName, String itemName) {
        Item seedItem;
        Block cropBlock = GameRegistry.findBlock((String)mod, (String)blockName);
        if (cropBlock != null && (seedItem = GameRegistry.findItem((String)mod, (String)itemName)) != null) {
            FarmersCommune.joinCommune(new PickableFarmer(cropBlock, new ItemStack(seedItem)));
        }
    }

    public static CustomSeedFarmer addSeed(String mod, String blockName, String itemName, Block ... extraFarmland) {
        Item seedItem;
        Block cropBlock = GameRegistry.findBlock((String)mod, (String)blockName);
        if (cropBlock != null && (seedItem = GameRegistry.findItem((String)mod, (String)itemName)) != null) {
            CustomSeedFarmer farmer = new CustomSeedFarmer(cropBlock, new ItemStack(seedItem));
            if (extraFarmland != null) {
                for (Block farmland : extraFarmland) {
                    if (farmland == null) continue;
                    farmer.addTilledBlock(farmland);
                }
            }
            FarmersCommune.joinCommune(farmer);
            return farmer;
        }
        return null;
    }

    private static void addTiC() {
        NaturaBerryFarmer farmer;
        int i;
        Item seedItem;
        String mod = "TConstruct";
        String blockName = "ore.berries.two";
        Block cropBlock = GameRegistry.findBlock((String)mod, (String)blockName);
        if (cropBlock != null && (seedItem = GameRegistry.findItem((String)mod, (String)blockName)) != null) {
            for (i = 0; i < 2; ++i) {
                farmer = new NaturaBerryFarmer(cropBlock, i, 12 + i, new ItemStack(seedItem, 1, 8 + i));
                farmer.setRequiresFarmland(false);
                FarmersCommune.joinCommune(farmer);
            }
        }
        if ((cropBlock = GameRegistry.findBlock((String)mod, (String)(blockName = "ore.berries.one"))) != null && (seedItem = GameRegistry.findItem((String)mod, (String)blockName)) != null) {
            for (i = 0; i < 4; ++i) {
                farmer = new NaturaBerryFarmer(cropBlock, i, 12 + i, new ItemStack(seedItem, 1, 8 + i));
                farmer.setRequiresFarmland(false);
                FarmersCommune.joinCommune(farmer);
            }
        }
    }

    private static void addNutura() {
        Block saplingBlock;
        Item seedItem;
        String mod = "Natura";
        String blockName = "N Crops";
        Block cropBlock = GameRegistry.findBlock((String)mod, (String)blockName);
        if (cropBlock != null) {
            DEFAULT_FARMER.addHarvestExlude(cropBlock);
            seedItem = GameRegistry.findItem((String)mod, (String)"barley.seed");
            if (seedItem != null) {
                FarmersCommune.joinCommune(new CustomSeedFarmer(cropBlock, 3, new ItemStack(seedItem)));
                FarmersCommune.joinCommune(new PickableFarmer(cropBlock, 4, 8, new ItemStack(seedItem, 1, 1)));
            }
        }
        if ((cropBlock = GameRegistry.findBlock((String)mod, (String)(blockName = "BerryBush"))) != null && (seedItem = GameRegistry.findItem((String)mod, (String)blockName)) != null) {
            for (int i = 0; i < 4; ++i) {
                NaturaBerryFarmer farmer = new NaturaBerryFarmer(cropBlock, i, 12 + i, new ItemStack(seedItem, 1, 12 + i));
                farmer.setRequiresFarmland(false);
                FarmersCommune.joinCommune(farmer);
            }
        }
        if ((saplingBlock = GameRegistry.findBlock((String)mod, (String)(blockName = "florasapling"))) != null) {
            FarmersCommune.joinCommune(new TreeFarmer(saplingBlock, GameRegistry.findBlock((String)mod, (String)"tree"), GameRegistry.findBlock((String)mod, (String)"willow"), GameRegistry.findBlock((String)mod, (String)"Dark Tree")));
        }
        if ((saplingBlock = GameRegistry.findBlock((String)mod, (String)(blockName = "Rare Sapling"))) != null) {
            FarmersCommune.joinCommune(new TreeFarmer(saplingBlock, GameRegistry.findBlock((String)mod, (String)"Rare Tree")));
        }
    }

    private static void addMFR() {
        String mod = "MineFactoryReloaded";
        String blockName = "tile.mfr.rubberwood.sapling";
        Block saplingBlock = GameRegistry.findBlock((String)mod, (String)blockName);
        if (saplingBlock != null) {
            FarmersCommune.joinCommune(new TreeFarmer(saplingBlock, GameRegistry.findBlock((String)mod, (String)"tile.mfr.rubberwood.log")));
        }
    }

    private static void addIC2() {
        RubberTreeFarmerIC2 rtf = new RubberTreeFarmerIC2();
        if (rtf.isValid()) {
            FarmersCommune.joinCommune(rtf);
        }
    }

    private static void addStillHungry() {
        String mod = "stillhungry";
        FarmersRegistry.addPickable(mod, "grapeBlock", "StillHungry_grapeSeed");
    }

    private static void addExtraUtilities() {
        String mod = "ExtraUtilities";
        String name = "plant/ender_lilly";
        CustomSeedFarmer farmer = FarmersRegistry.addSeed(mod, name, name, Blocks.field_150377_bs, GameRegistry.findBlock((String)mod, (String)"decorativeBlock1"));
        if (farmer != null) {
            farmer.setIgnoreGroundCanSustainCheck(true);
        }
    }

    private FarmersRegistry() {
    }
}

