/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.IFarmerJoe;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.util.BlockCoord;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;

public class FarmersCommune
implements IFarmerJoe {
    public static FarmersCommune instance = new FarmersCommune();
    private List<IFarmerJoe> farmers = new ArrayList<IFarmerJoe>();
    private Set<Class<?>> toolTypes = new HashSet();

    public static void joinCommune(IFarmerJoe joe) {
        FarmersCommune.instance.farmers.add(joe);
    }

    public static void leaveCommune(IFarmerJoe joe) {
        throw new UnsupportedOperationException("As if this would be implemented. The commune is for life!");
    }

    private FarmersCommune() {
        this.registerToolType(ItemHoe.class);
        this.registerToolType(ItemAxe.class);
    }

    public void registerToolType(Class<?> clz) {
        this.toolTypes.add(clz);
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        for (IFarmerJoe joe : this.farmers) {
            if (!joe.canHarvest(farm, bc, block, meta)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        for (IFarmerJoe joe : this.farmers) {
            if (!joe.canHarvest(farm, bc, block, meta)) continue;
            return joe.harvestBlock(farm, bc, block, meta);
        }
        return null;
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        for (IFarmerJoe joe : this.farmers) {
            if (!joe.prepareBlock(farm, bc, block, meta)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        for (IFarmerJoe joe : this.farmers) {
            if (!joe.canPlant(stack)) continue;
            return true;
        }
        return false;
    }

    public Set<Class<?>> getToolTypes() {
        return this.toolTypes;
    }
}

