/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.FarmersCommune;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.enderio.machine.farm.farmers.TreeFarmer;
import crazypants.util.BlockCoord;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class RubberTreeFarmerIC2
extends TreeFarmer {
    private Class<?> treeTap;
    private ItemStack stickyResin;

    public RubberTreeFarmerIC2() {
        super(GameRegistry.findBlock((String)"IC2", (String)"blockRubSapling"), GameRegistry.findBlock((String)"IC2", (String)"blockRubWood"));
        Item item = GameRegistry.findItem((String)"IC2", (String)"itemTreetap");
        if (item != null) {
            this.treeTap = item.getClass();
            FarmersCommune.instance.registerToolType(this.treeTap);
        }
        if ((item = GameRegistry.findItem((String)"IC2", (String)"itemHarz")) != null) {
            this.stickyResin = new ItemStack(item);
        }
    }

    public boolean isValid() {
        return this.woods != null && this.woods.length > 0 && this.sapling != null && this.saplingItem != null && this.treeTap != null && this.stickyResin != null;
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                Block blk = farm.getBlock(bc.x + x, bc.y, bc.z + z);
                if (!this.isWood(blk) && this.sapling != blk) continue;
                return false;
            }
        }
        return super.prepareBlock(farm, bc, block, meta);
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        HarvestResult res = new HarvestResult();
        int y = bc.y;
        boolean done = false;
        while (!done && farm.hasTool(this.treeTap)) {
            bc = new BlockCoord(bc.x, y, bc.z);
            block = farm.getBlock(bc);
            if (!this.isWood(block)) {
                done = true;
            } else {
                meta = farm.getBlockMeta(bc);
                if (this.attemptHarvest(res, farm.func_145831_w(), bc.x, y, bc.z, meta)) {
                    farm.damageTool(this.treeTap, this.woods[0], bc, 1);
                }
            }
            ++y;
        }
        return res;
    }

    private boolean attemptHarvest(HarvestResult res, World world, int x, int y, int z, int meta) {
        if (meta > 1 && meta < 6) {
            world.func_72921_c(x, y, z, meta + 6, 3);
            world.func_147464_a(x, y, z, this.woods[0], this.woods[0].func_149738_a(world));
            ItemStack drop = this.stickyResin.func_77946_l();
            drop.field_77994_a = world.field_73012_v.nextInt(3) + 1;
            EntityItem dropEnt = new EntityItem(world, (double)x + 0.5, (double)(y + 1), (double)z + 0.5, drop);
            res.getDrops().add(dropEnt);
            return true;
        }
        return false;
    }
}

