/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import crazypants.enderio.config.Config;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IFarmerJoe;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.enderio.machine.farm.farmers.TreeHarvestUtil;
import crazypants.util.BlockCoord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class TreeFarmer
implements IFarmerJoe {
    private static final HeightComparator comp = new HeightComparator();
    protected Block sapling;
    protected ItemStack saplingItem;
    protected Block[] woods;
    protected TreeHarvestUtil harvester = new TreeHarvestUtil();

    public TreeFarmer(Block sapling, Block ... wood) {
        this.sapling = sapling;
        if (sapling != null) {
            this.saplingItem = new ItemStack(sapling);
        }
        this.woods = wood;
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        return this.isWood(block);
    }

    protected boolean isWood(Block block) {
        for (Block wood : this.woods) {
            if (block != wood) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        return stack != null && stack.func_77973_b() == this.saplingItem.func_77973_b();
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        if (block == this.sapling) {
            return true;
        }
        return this.plantFromInventory(farm, bc, block, meta);
    }

    protected boolean plantFromInventory(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        ItemStack seed;
        World worldObj = farm.func_145831_w();
        if (this.canPlant(worldObj, bc) && (seed = farm.takeSeedFromSupplies(this.saplingItem, bc, false)) != null) {
            return this.plant(farm, worldObj, bc, seed);
        }
        return false;
    }

    protected boolean canPlant(World worldObj, BlockCoord bc) {
        Block ground = worldObj.func_147439_a(bc.x, bc.y - 1, bc.z);
        IPlantable plantable = (IPlantable)this.sapling;
        return this.sapling.func_149742_c(worldObj, bc.x, bc.y, bc.z) && this.sapling.func_149718_j(worldObj, bc.x, bc.y, bc.z) && ground.canSustainPlant((IBlockAccess)worldObj, bc.x, bc.y - 1, bc.z, ForgeDirection.UP, plantable);
    }

    protected boolean plant(TileFarmStation farm, World worldObj, BlockCoord bc, ItemStack seed) {
        worldObj.func_147465_d(bc.x, bc.y, bc.z, Blocks.field_150350_a, 0, 3);
        if (this.canPlant(worldObj, bc)) {
            worldObj.func_147465_d(bc.x, bc.y, bc.z, this.sapling, seed.func_77960_j(), 3);
            farm.actionPerformed(false);
            return true;
        }
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        HarvestResult res = new HarvestResult();
        if (!farm.hasAxe()) {
            return res;
        }
        this.harvester.harvest(farm, this, bc, res);
        Collections.sort(res.harvestedBlocks, comp);
        ArrayList<BlockCoord> actualHarvests = new ArrayList<BlockCoord>();
        for (int i = 0; i < res.harvestedBlocks.size() && farm.hasAxe(); ++i) {
            BlockCoord coord = res.harvestedBlocks.get(i);
            Block blk = farm.getBlock(coord);
            ArrayList drops = blk.getDrops(farm.func_145831_w(), bc.x, bc.y, bc.z, farm.getBlockMeta(coord), farm.getAxeLootingValue());
            if (drops != null) {
                for (ItemStack drop : drops) {
                    res.drops.add(new EntityItem(farm.func_145831_w(), (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, drop.func_77946_l()));
                }
            }
            boolean isWood = true;
            if (!this.isWood(blk)) {
                isWood = Config.farmAxeDamageOnLeafBreak;
                int leaveMeta = farm.getBlockMeta(coord);
                if (TreeHarvestUtil.canDropApples(blk, leaveMeta) && farm.func_145831_w().field_73012_v.nextInt(200) == 0) {
                    res.drops.add(new EntityItem(farm.func_145831_w(), (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, new ItemStack(Items.field_151034_e)));
                }
            }
            farm.actionPerformed(isWood);
            if (isWood) {
                farm.damageAxe(blk, coord);
            }
            farm.func_145831_w().func_147468_f(coord.x, coord.y, coord.z);
            actualHarvests.add(coord);
        }
        if (!farm.hasAxe()) {
            farm.setNotification("noAxe");
        }
        res.harvestedBlocks.clear();
        res.harvestedBlocks.addAll(actualHarvests);
        return res;
    }

    private static class HeightComparator
    implements Comparator<BlockCoord> {
        private HeightComparator() {
        }

        @Override
        public int compare(BlockCoord o1, BlockCoord o2) {
            return HeightComparator.compare(o2.y, o1.y);
        }

        public static int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

