/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.TreeFarmer;
import crazypants.util.BlockCoord;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TreeHarvestUtil {
    private int horizontalRange;
    private int verticalRange;
    protected Block[] woods;
    private BlockCoord origin;

    public static boolean canDropApples(Block block, int meta) {
        return block instanceof BlockOldLeaf && (meta == 0 || meta == 8) || block instanceof BlockNewLeaf && (meta == 1 || meta == 9);
    }

    public void harvest(TileFarmStation farm, TreeFarmer farmer, BlockCoord bc, HarvestResult res) {
        this.woods = farmer.woods;
        this.horizontalRange = farm.getFarmSize() + 7;
        this.verticalRange = 30;
        this.harvest(farm.func_145831_w(), farm.getLocation(), bc, res);
    }

    public void harvest(World world, BlockCoord bc, HarvestResult res) {
        this.horizontalRange = 12;
        this.verticalRange = 30;
        this.origin = new BlockCoord(bc);
        this.woods = new Block[]{world.func_147439_a(bc.x, bc.y, bc.z)};
        this.harvestUp(world, bc, res);
    }

    private void harvest(World farm, BlockCoord origin, BlockCoord bc, HarvestResult res) {
        this.origin = new BlockCoord(origin);
        this.harvestUp(farm, bc, res);
    }

    protected void harvestUp(World world, BlockCoord bc, HarvestResult res) {
        if (!this.isInHarvestBounds(bc) || res.harvestedBlocks.contains(bc)) {
            return;
        }
        Block blk = world.func_147439_a(bc.x, bc.y, bc.z);
        boolean isLeaves = blk instanceof BlockLeaves;
        if (this.isWood(blk) || isLeaves) {
            res.harvestedBlocks.add(bc);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (dir == ForgeDirection.DOWN) continue;
                this.harvestUp(world, bc.getLocation(dir), res);
            }
        } else {
            this.harvestAdjacentWood(world, bc, res);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (dir.offsetY != 0) continue;
                BlockCoord loc = bc.getLocation(dir);
                Block targetBlock = world.func_147439_a(loc.x, loc.y, loc.z);
                if (!(targetBlock instanceof BlockLeaves)) continue;
                this.harvestAdjacentWood(world, bc, res);
            }
        }
    }

    private void harvestAdjacentWood(World world, BlockCoord bc, HarvestResult res) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (dir.offsetY != 0) continue;
            BlockCoord loc = bc.getLocation(dir);
            Block targetBlock = world.func_147439_a(loc.x, loc.y, loc.z);
            if (!this.isWood(targetBlock)) continue;
            this.harvestUp(world, bc.getLocation(dir), res);
        }
    }

    private boolean isInHarvestBounds(BlockCoord bc) {
        int dist = Math.abs(this.origin.x - bc.x);
        if (dist > this.horizontalRange) {
            return false;
        }
        dist = Math.abs(this.origin.z - bc.z);
        if (dist > this.horizontalRange) {
            return false;
        }
        dist = Math.abs(this.origin.y - bc.y);
        return dist <= this.verticalRange;
    }

    protected boolean isWood(Block block) {
        for (Block wood : this.woods) {
            if (block != wood) continue;
            return true;
        }
        return false;
    }
}

