/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.combustion;

import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.machine.GuiMachineBase;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.generator.combustion.ContainerCombustionEngine;
import crazypants.enderio.machine.generator.combustion.TileCombustionGenerator;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.gui.GuiToolTip;
import crazypants.render.ColorUtil;
import crazypants.render.RenderUtil;
import crazypants.util.Lang;
import java.awt.Color;
import java.awt.Rectangle;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

public class GuiCombustionGenerator
extends GuiMachineBase {
    private TileCombustionGenerator gen;

    public GuiCombustionGenerator(InventoryPlayer par1InventoryPlayer, TileCombustionGenerator te) {
        super(te, new ContainerCombustionEngine(par1InventoryPlayer, te));
        this.gen = te;
        this.addToolTip(new GuiToolTip(new Rectangle(114, 21, 15, 47), new String[]{""}){

            @Override
            protected void updateText() {
                this.text.clear();
                String heading = Lang.localize("combustionGenerator.coolantTank");
                if (GuiCombustionGenerator.this.gen.getCoolantTank().getFluid() != null) {
                    heading = heading + ": " + GuiCombustionGenerator.this.gen.getCoolantTank().getFluid().getFluid().getLocalizedName();
                }
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)GuiCombustionGenerator.this.gen.getCoolantTank()));
            }
        });
        this.addToolTip(new GuiToolTip(new Rectangle(48, 21, 15, 47), new String[]{""}){

            @Override
            protected void updateText() {
                this.text.clear();
                String heading = Lang.localize("combustionGenerator.fuelTank");
                if (GuiCombustionGenerator.this.gen.getFuelTank().getFluid() != null) {
                    heading = heading + ": " + GuiCombustionGenerator.this.gen.getFuelTank().getFluid().getFluid().getLocalizedName();
                }
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)GuiCombustionGenerator.this.gen.getFuelTank()));
            }
        });
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    public void renderSlotHighlights(IoMode mode) {
        super.renderSlotHighlights(mode);
        if (mode == IoMode.PULL || mode == IoMode.PUSH_PULL) {
            int x = 46;
            int y = 19;
            int w = 19;
            int h = 51;
            this.renderSlotHighlight(PULL_COLOR, x, y, w, h);
            x = 112;
            this.renderSlotHighlight(PULL_COLOR, x, y, w, h);
        }
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture("enderio:textures/gui/combustionGen.png");
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        FontRenderer fr = this.getFontRenderer();
        int output = 0;
        if (this.gen.isActive()) {
            output = this.gen.getGeneratedLastTick();
        }
        String txt = Lang.localize("combustionGenerator.output") + " " + PowerDisplayUtil.formatPower(output) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr();
        int sw = fr.func_78256_a(txt);
        fr.func_78261_a(txt, this.field_147003_i + this.field_146999_f / 2 - sw / 2, this.field_147009_r + fr.field_78288_b / 2 + 3, ColorUtil.getRGB(Color.WHITE));
        int x = this.field_147003_i + 48;
        int y = this.field_147009_r + 21;
        if (this.gen.getCoolantTank().getFluidAmount() > 0) {
            x = this.field_147003_i + 114;
            RenderUtil.renderGuiTank(this.gen.getCoolantTank().getFluid(), 4000, this.gen.getCoolantTank().getFluidAmount() - 1000, x, y, this.field_73735_i, 15.0, 47.0);
            if (this.gen.isActive()) {
                txt = this.gen.getNumTicksPerMbCoolant() + " t/MB";
                sw = fr.func_78256_a(txt);
                fr.func_78261_a(txt, x - sw / 2 + 7, y + fr.field_78288_b / 2 + 47, ColorUtil.getRGB(Color.WHITE));
            }
            x = this.field_147003_i + 72;
            y = this.field_147009_r + 14;
            RenderUtil.renderGuiTank(this.gen.getCoolantTank().getFluid(), 1000, Math.min(this.gen.getCoolantTank().getFluidAmount(), 1000), x, y + 14, this.field_73735_i, 33.0, 33.0);
            RenderUtil.bindTexture("enderio:textures/gui/combustionGen.png");
            this.func_73729_b(x, y + 14, 0, 223, 33, 33);
            y += 7;
        }
        if (this.gen.getFuelTank().getFluidAmount() > 0) {
            x = this.field_147003_i + 48;
            RenderUtil.renderGuiTank(this.gen.getFuelTank().getFluid(), 4000, this.gen.getFuelTank().getFluidAmount() - 1000, x, y, this.field_73735_i, 15.0, 47.0);
            if (this.gen.isActive()) {
                txt = this.gen.getNumTicksPerMbFuel() + " t/MB";
                sw = fr.func_78256_a(txt);
                fr.func_78261_a(txt, x - sw / 2 + 7, y + fr.field_78288_b / 2 + 47, ColorUtil.getRGB(Color.WHITE));
            }
            RenderUtil.renderGuiTank(this.gen.getFuelTank().getFluid(), 1000, Math.min(this.gen.getFuelTank().getFluidAmount(), 1000), this.field_147003_i + 81, this.field_147009_r + 38, this.field_73735_i, 14.0, 14.0);
        }
        RenderUtil.bindTexture("enderio:textures/gui/combustionGen.png");
        super.func_146976_a(par1, par2, par3);
    }

    @Override
    protected int getPowerX() {
        return 10;
    }

    @Override
    protected int getPowerY() {
        return 13;
    }

    @Override
    protected int getPowerHeight() {
        return 60;
    }
}

