/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.zombie;

import crazypants.enderio.machine.generator.zombie.ModelZombieJar;
import crazypants.enderio.machine.generator.zombie.NutrientTank;
import crazypants.enderio.machine.generator.zombie.TileZombieGenerator;
import crazypants.render.BoundingBox;
import crazypants.render.CubeRenderer;
import crazypants.render.RenderUtil;
import crazypants.util.ForgeDirectionOffsets;
import crazypants.vecmath.Vector3d;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class ZombieGeneratorRenderer
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private static final String TEXTURE = "enderio:models/ZombieJar.png";
    private ModelZombieJar model = new ModelZombieJar();

    public void func_147500_a(TileEntity te, double x, double y, double z, float tick) {
        World world = te.func_145831_w();
        TileZombieGenerator gen = (TileZombieGenerator)te;
        float f = world.func_72957_l(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        int l = world.func_72802_i(te.field_145851_c, te.field_145848_d, te.field_145849_e, 0);
        int l1 = l % 65536;
        int l2 = l / 65536;
        Tessellator.field_78398_a.func_78386_a(f, f, f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)l1, (float)l2);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        this.renderModel(gen.facing);
        this.renderFluid(gen);
        GL11.glPopMatrix();
    }

    protected void renderFluid(TileZombieGenerator gen) {
        NutrientTank tank = gen.fuelTank;
        if (tank.getFluidAmount() <= 0) {
            return;
        }
        IIcon icon = tank.getFluid().getFluid().getStillIcon();
        if (icon != null) {
            RenderUtil.bindBlockTexture();
            Tessellator tes = Tessellator.field_78398_a;
            tes.func_78382_b();
            float fullness = (float)tank.getFluidAmount() / (float)tank.getCapacity();
            BoundingBox bb = BoundingBox.UNIT_CUBE.scale(0.85, 0.96, 0.85);
            bb = bb.scale(1.0, 0.85 * (double)fullness, 1.0);
            float ty = -(0.85f - (bb.maxY - bb.minY)) / 2.0f;
            Vector3d offset = ForgeDirectionOffsets.offsetScaled(ForgeDirection.values()[gen.facing], -0.075);
            bb = bb.translate((float)offset.x, ty, (float)offset.z);
            int brightness = gen.func_145831_w() == null ? 0xF000F0 : gen.func_145831_w().func_72802_i(gen.field_145851_c, gen.field_145848_d, gen.field_145849_e, 0);
            tes.func_78380_c(brightness);
            CubeRenderer.render(bb, icon);
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            tes.func_78381_a();
            GL11.glDepthMask((boolean)true);
            GL11.glPopAttrib();
        }
    }

    private void renderModel(int facing) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)1.2f, (float)0.9f, (float)1.2f);
        ForgeDirection dir = ForgeDirection.getOrientation((int)facing);
        if (dir == ForgeDirection.SOUTH) {
            facing = 0;
        } else if (dir == ForgeDirection.WEST) {
            facing = -1;
        }
        GL11.glRotatef((float)((float)facing * -90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderUtil.bindTexture(TEXTURE);
        this.model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        GL11.glPopMatrix();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.renderItem(0.0f, 0.0f, 0.0f);
    }

    private void renderItem(float x, float y, float z) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.renderModel(ForgeDirection.SOUTH.ordinal());
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }
}

