/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.killera;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.killera.ContainerKillerJoe;
import crazypants.enderio.machine.killera.GuiKillerJoe;
import crazypants.enderio.machine.killera.PacketNutrientLevel;
import crazypants.enderio.machine.killera.PacketSwing;
import crazypants.enderio.machine.killera.TileKillerJoe;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.xp.PacketExperianceContainer;
import crazypants.enderio.xp.PacketGivePlayerXP;
import crazypants.util.FluidUtil;
import crazypants.util.Util;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fluids.FluidStack;

public class BlockKillerJoe
extends AbstractMachineBlock<TileKillerJoe> {
    static final String USERNAME = "KillerJoe";

    public static BlockKillerJoe create() {
        PacketHandler.INSTANCE.registerMessage(PacketNutrientLevel.class, PacketNutrientLevel.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketSwing.class, PacketSwing.class, PacketHandler.nextID(), Side.CLIENT);
        PacketGivePlayerXP.register();
        PacketExperianceContainer.register();
        BlockKillerJoe res = new BlockKillerJoe();
        MinecraftForge.EVENT_BUS.register((Object)res);
        res.init();
        return res;
    }

    protected BlockKillerJoe() {
        super(ModObject.blockKillerJoe, TileKillerJoe.class);
        this.func_149672_a(Block.field_149778_k);
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return 2000.0f;
    }

    @SubscribeEvent
    public void getKillDisplayName(PlayerEvent.NameFormat nameEvt) {
        if (nameEvt.username != null && nameEvt.username.startsWith(USERNAME)) {
            nameEvt.displayname = this.func_149732_F();
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int par6, float par7, float par8, float par9) {
        int filled;
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileKillerJoe)) {
            return super.func_149727_a(world, x, y, z, entityPlayer, par6, par7, par8, par9);
        }
        TileKillerJoe gen = (TileKillerJoe)te;
        ItemStack item = entityPlayer.field_71071_by.func_70448_g();
        if (item == null) {
            return super.func_149727_a(world, x, y, z, entityPlayer, par6, par7, par8, par9);
        }
        FluidStack fluid = FluidUtil.getFluidFromItem(item);
        if (fluid != null && (filled = gen.fill(ForgeDirection.UP, fluid, false)) >= fluid.amount) {
            gen.fill(ForgeDirection.UP, fluid, true);
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, Util.consumeItem(item));
            }
            return true;
        }
        return super.func_149727_a(world, x, y, z, entityPlayer, par6, par7, par8, par9);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerKillerJoe(player.field_71071_by, (TileKillerJoe)world.func_147438_o(x, y, z));
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GuiKillerJoe(player.field_71071_by, (TileKillerJoe)world.func_147438_o(x, y, z));
    }

    @Override
    protected int getGuiId() {
        return 92;
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        return "enderio:blankMachinePanel";
    }

    @Override
    public int func_149645_b() {
        return -1;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    protected short getFacingForHeading(int heading) {
        switch (heading) {
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 2;
            }
        }
        return 5;
    }
}

