/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.light;

import crazypants.enderio.EnderIO;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.light.TileLightNode;
import crazypants.enderio.machine.wireless.IWirelessCharger;
import crazypants.enderio.machine.wireless.WirelessChargerController;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.ICapacitor;
import crazypants.enderio.power.IInternalPowerReceptor;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.util.BlockCoord;
import crazypants.util.ForgeDirectionOffsets;
import crazypants.vecmath.Vector3d;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.util.ForgeDirection;

public class TileElectricLight
extends TileEntityEio
implements IInternalPowerReceptor {
    private ForgeDirection face = ForgeDirection.DOWN;
    public static final int RF_USE_PER_TICK = 1;
    private boolean init = true;
    private List<TileLightNode> lightNodes;
    private int[] lightNodeCoords;
    private boolean updatingLightNodes = false;
    private boolean lastActive = false;
    private boolean isInvereted;
    private boolean requiresPower = true;
    private boolean isWireless;
    private IWirelessCharger charger;
    private int ticksSinceLastSearch = 50;
    private ICapacitor capacitor;
    private int energyStoredRF;

    public TileElectricLight() {
        this.capacitor = new BasicCapacitor(Capacitors.BASIC_CAPACITOR.capacitor.getMaxEnergyReceived(), 100);
        this.energyStoredRF = 0;
    }

    public void onNeighborBlockChange(Block blockID) {
        this.init = true;
    }

    public void nodeNeighbourChanged(TileLightNode tileLightNode) {
        this.init = true;
    }

    public void nodeRemoved(TileLightNode tileLightNode) {
        if (!this.updatingLightNodes) {
            this.init = true;
        }
    }

    public ForgeDirection getFace() {
        return this.face;
    }

    public void setFace(ForgeDirection face) {
        this.face = face;
    }

    public void setInverted(boolean inverted) {
        this.isInvereted = inverted;
    }

    public void setRequiresPower(boolean isPowered) {
        this.requiresPower = isPowered;
    }

    public boolean isRequiresPower() {
        return this.requiresPower;
    }

    public void setInvereted(boolean isInvereted) {
        this.isInvereted = isInvereted;
    }

    public boolean isInvereted() {
        return this.isInvereted;
    }

    public void setWireless(boolean wireless) {
        this.isWireless = wireless;
    }

    public boolean isWireless() {
        return this.isWireless;
    }

    public void func_145845_h() {
        boolean isActivated;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean hasRedstone = this.hasRedstoneSignal();
        boolean bl = isActivated = (!this.requiresPower || this.hasPower()) && (hasRedstone && !this.isInvereted || !hasRedstone && this.isInvereted);
        if (isActivated && this.requiresPower) {
            this.setEnergyStored(this.getEnergyStored() - 1);
        }
        if (!this.hasPower() && this.requiresPower) {
            isActivated = false;
        }
        if (this.init && this.requiresPower) {
            this.updateLightNodes();
        }
        if (isActivated != this.lastActive || this.init) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, isActivated ? 1 : 0, 2);
            if (this.requiresPower) {
                for (TileLightNode ln : this.lightNodes) {
                    if (ln == null) continue;
                    this.field_145850_b.func_72921_c(ln.field_145851_c, ln.field_145848_d, ln.field_145849_e, isActivated ? 1 : 0, 2);
                    this.field_145850_b.func_147471_g(ln.field_145851_c, ln.field_145848_d, ln.field_145849_e);
                    this.field_145850_b.func_147463_c(EnumSkyBlock.Block, ln.field_145851_c, ln.field_145848_d, ln.field_145849_e);
                }
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.init = false;
            this.lastActive = isActivated;
        }
        if (this.isWireless) {
            if (this.ticksSinceLastSearch > 50) {
                this.charger = this.findNearestCharger();
                this.ticksSinceLastSearch = 0;
            } else {
                ++this.ticksSinceLastSearch;
            }
            if (this.charger != null && this.energyStoredRF < this.getMaxEnergyStored()) {
                this.energyStoredRF += this.charger.takeEnergy(Math.min(this.getMaxEnergyStored() - this.energyStoredRF, 10));
            }
        }
    }

    private IWirelessCharger findNearestCharger() {
        TileEntity te;
        int minDist = Integer.MAX_VALUE;
        BlockCoord charger = null;
        Map<BlockCoord, IWirelessCharger> map = WirelessChargerController.instance.getChargerMap(this.field_145850_b);
        if (map == null) {
            return null;
        }
        for (BlockCoord b : map.keySet()) {
            int dist = b.distance(new BlockCoord(this));
            if (dist >= minDist) continue;
            minDist = dist;
            charger = b;
        }
        if (charger != null && minDist < Config.wirelessChargerRange && (te = charger.getTileEntity(this.field_145850_b)) instanceof IWirelessCharger) {
            return (IWirelessCharger)te;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBlockRemoved() {
        if (!this.requiresPower) {
            return;
        }
        this.updatingLightNodes = true;
        try {
            this.clearLightNodes();
        }
        finally {
            this.updatingLightNodes = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLightNodes() {
        if (!this.requiresPower) {
            return;
        }
        this.updatingLightNodes = true;
        ArrayList<NodeEntry> before = new ArrayList<NodeEntry>(17);
        if (this.lightNodes != null) {
            for (TileLightNode node : this.lightNodes) {
                before.add(new NodeEntry(node));
            }
        }
        ArrayList<NodeEntry> after = new ArrayList<NodeEntry>(17);
        try {
            if (this.lightNodeCoords != null) {
                this.lightNodes = new ArrayList<TileLightNode>();
                for (int i = 0; i < this.lightNodeCoords.length; i += 3) {
                    TileEntity te = this.field_145850_b.func_147438_o(this.lightNodeCoords[i], this.lightNodeCoords[i + 1], this.lightNodeCoords[i + 2]);
                    if (!(te instanceof TileLightNode)) continue;
                    this.lightNodes.add((TileLightNode)te);
                }
                this.lightNodeCoords = null;
            } else if (this.lightNodes == null) {
                this.lightNodes = new ArrayList<TileLightNode>();
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (dir == this.face || dir == this.face.getOpposite()) continue;
                Vector3d offset = ForgeDirectionOffsets.forDirCopy(dir);
                this.addNodeInDirection(new Vector3d(offset), after);
                this.addNodeInDirection(offset.add(ForgeDirectionOffsets.forDirCopy(this.face.getOpposite())), after);
            }
            this.addNodeInDirection(ForgeDirectionOffsets.forDirCopy(this.face.getOpposite()), after);
            Vector3d[] diags = new Vector3d[2];
            if (this.face.offsetX != 0) {
                diags[0] = ForgeDirectionOffsets.forDirCopy(ForgeDirection.UP);
                diags[1] = ForgeDirectionOffsets.forDirCopy(ForgeDirection.SOUTH);
            } else if (this.face.offsetY != 0) {
                diags[0] = ForgeDirectionOffsets.forDirCopy(ForgeDirection.EAST);
                diags[1] = ForgeDirectionOffsets.forDirCopy(ForgeDirection.SOUTH);
            } else {
                diags[0] = ForgeDirectionOffsets.forDirCopy(ForgeDirection.UP);
                diags[1] = ForgeDirectionOffsets.forDirCopy(ForgeDirection.EAST);
            }
            this.addDiaganals(diags, new Vector3d(), after);
            this.addDiaganals(diags, ForgeDirectionOffsets.forDirCopy(this.face.getOpposite()), after);
            if (!this.areEqual(before, after)) {
                this.clearLightNodes();
                for (NodeEntry entry : after) {
                    this.field_145850_b.func_147449_b(entry.coord.x, entry.coord.y, entry.coord.z, (Block)EnderIO.blockLightNode);
                    TileEntity te = this.field_145850_b.func_147438_o(entry.coord.x, entry.coord.y, entry.coord.z);
                    if (!(te instanceof TileLightNode)) continue;
                    TileLightNode ln = (TileLightNode)te;
                    ln.parentX = this.field_145851_c;
                    ln.parentY = this.field_145848_d;
                    ln.parentZ = this.field_145849_e;
                    ln.isDiagnal = entry.isDiagnal;
                    this.lightNodes.add(ln);
                }
            } else {
                this.init = false;
            }
        }
        finally {
            this.updatingLightNodes = false;
        }
    }

    private boolean areEqual(List<NodeEntry> before, List<NodeEntry> after) {
        if (before.size() != after.size()) {
            return false;
        }
        for (NodeEntry entry : before) {
            if (after.contains(entry)) continue;
            return false;
        }
        return true;
    }

    private void addDiaganals(Vector3d[] diags, Vector3d trans, List<NodeEntry> result) {
        Vector3d offset = new Vector3d();
        offset.set(diags[0]);
        offset.add(diags[1]);
        this.addNodeInDirection(offset.add(trans), true, result);
        offset.set(diags[0]);
        offset.sub(diags[1]);
        this.addNodeInDirection(offset.add(trans), true, result);
        offset.set(new Vector3d(diags[0]).negate());
        offset.add(diags[1]);
        this.addNodeInDirection(offset.add(trans), true, result);
        offset.set(new Vector3d(diags[0]).negate());
        offset.sub(diags[1]);
        this.addNodeInDirection(offset.add(trans), true, result);
    }

    private void addNodeInDirection(Vector3d offset, List<NodeEntry> after) {
        this.addNodeInDirection(offset, false, after);
    }

    private void addNodeInDirection(Vector3d offset, boolean diagnal, List<NodeEntry> result) {
        boolean isAir = this.isAir(offset);
        boolean isTransp = this.isTranparent(offset);
        if (isAir || isTransp) {
            offset.scale(2.0);
            if (this.isAir(offset)) {
                this.addLightNode(offset, diagnal, result);
            } else if (isAir) {
                offset.scale(0.5);
                this.addLightNode(offset, diagnal, result);
            }
        }
    }

    private boolean isLightNode(Vector3d offset) {
        return this.field_145850_b.func_147439_a(this.field_145851_c + (int)offset.x, this.field_145848_d + (int)offset.y, this.field_145849_e + (int)offset.z) == EnderIO.blockLightNode;
    }

    private void clearLightNodes() {
        if (this.lightNodes != null) {
            for (TileLightNode ln : this.lightNodes) {
                if (this.field_145850_b.func_147439_a(ln.field_145851_c, ln.field_145848_d, ln.field_145849_e) != EnderIO.blockLightNode) continue;
                this.field_145850_b.func_147468_f(ln.field_145851_c, ln.field_145848_d, ln.field_145849_e);
            }
            this.lightNodes.clear();
        }
    }

    private void addLightNode(Vector3d offset, boolean isDiag, List<NodeEntry> result) {
        int x = this.field_145851_c + (int)offset.x;
        int y = this.field_145848_d + (int)offset.y;
        int z = this.field_145849_e + (int)offset.z;
        if (this.isLightNode(offset)) {
            TileLightNode te = (TileLightNode)this.field_145850_b.func_147438_o(x, y, z);
            if (te.parentX != this.field_145851_c || te.parentY != this.field_145848_d || te.parentZ != this.field_145849_e) {
                return;
            }
        }
        result.add(new NodeEntry(new BlockCoord(x, y, z), isDiag));
    }

    private boolean isRailcraftException(Block id) {
        String className = id.getClass().getName();
        return className.equals("mods.railcraft.common.blocks.machine.BlockMachine");
    }

    private boolean isTranparent(Vector3d offset) {
        Block id = this.field_145850_b.func_147439_a(this.field_145851_c + (int)offset.x, this.field_145848_d + (int)offset.y, this.field_145849_e + (int)offset.z);
        if (this.isRailcraftException(id)) {
            return false;
        }
        return this.field_145850_b.getBlockLightOpacity(this.field_145851_c + (int)offset.x, this.field_145848_d + (int)offset.y, this.field_145849_e + (int)offset.z) == 0;
    }

    private boolean isAir(Vector3d offset) {
        return this.field_145850_b.func_147437_c(this.field_145851_c + (int)offset.x, this.field_145848_d + (int)offset.y, this.field_145849_e + (int)offset.z) || this.isLightNode(offset);
    }

    @Override
    public void readCustomNBT(NBTTagCompound root) {
        this.face = ForgeDirection.values()[root.func_74765_d("face")];
        this.isInvereted = root.func_74767_n("isInverted");
        this.requiresPower = root.func_74767_n("requiresPower");
        this.isWireless = root.func_74767_n("isWireless");
        if (root.func_74764_b("storedEnergy")) {
            float se = root.func_74760_g("storedEnergy");
            this.energyStoredRF = (int)(se * 10.0f);
        } else {
            this.energyStoredRF = root.func_74762_e("storedEnergyRF");
        }
        this.lightNodeCoords = root.func_74759_k("lightNodes");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound root) {
        root.func_74777_a("face", (short)this.face.ordinal());
        root.func_74768_a("storedEnergyRF", this.energyStoredRF);
        root.func_74757_a("isInverted", this.isInvereted);
        root.func_74757_a("requiresPower", this.requiresPower);
        root.func_74757_a("isWireless", this.isWireless);
        if (this.lightNodes != null) {
            int[] lnLoc = new int[this.lightNodes.size() * 3];
            int index = 0;
            for (TileLightNode ln : this.lightNodes) {
                lnLoc[index++] = ln.field_145851_c;
                lnLoc[index++] = ln.field_145848_d;
                lnLoc[index++] = ln.field_145849_e;
            }
            root.func_74783_a("lightNodes", lnLoc);
        }
    }

    public boolean hasPower() {
        return this.energyStoredRF > 1;
    }

    private boolean hasRedstoneSignal() {
        return this.field_145850_b.func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.requiresPower) {
            return 0;
        }
        return PowerHandlerUtil.recieveInternal(this, maxReceive, from, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.requiresPower;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaxEnergyStored();
    }

    @Override
    public int getMaxEnergyRecieved(ForgeDirection dir) {
        if (!this.requiresPower) {
            return 0;
        }
        return this.capacitor.getMaxEnergyReceived();
    }

    @Override
    public int getEnergyStored() {
        if (!this.requiresPower) {
            return 0;
        }
        return this.energyStoredRF;
    }

    @Override
    public int getMaxEnergyStored() {
        if (!this.requiresPower) {
            return 0;
        }
        return this.capacitor.getMaxEnergyStored();
    }

    @Override
    public void setEnergyStored(int stored) {
        this.energyStoredRF = stored;
    }

    @Override
    public boolean displayPower() {
        return this.isRequiresPower();
    }

    static class NodeEntry {
        final BlockCoord coord;
        final boolean isDiagnal;

        NodeEntry(BlockCoord coord, boolean isDiagnal) {
            this.coord = coord;
            this.isDiagnal = isDiagnal;
        }

        NodeEntry(TileLightNode node) {
            this.coord = new BlockCoord(node);
            this.isDiagnal = node.isDiagnal;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.coord == null ? 0 : this.coord.hashCode());
            result = 31 * result + (this.isDiagnal ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeEntry other = (NodeEntry)obj;
            if (this.coord == null ? other.coord != null : !this.coord.equals(other.coord)) {
                return false;
            }
            return this.isDiagnal == other.isDiagnal;
        }
    }
}

