/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.monitor;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.monitor.TilePowerMonitor;
import crazypants.enderio.network.MessageTileEntity;
import crazypants.enderio.network.NetworkUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class PacketPowerInfo
extends MessageTileEntity<TilePowerMonitor>
implements IMessageHandler<PacketPowerInfo, IMessage> {
    private NBTTagCompound nbtRoot;

    public PacketPowerInfo() {
    }

    public PacketPowerInfo(TilePowerMonitor tile) {
        super(tile);
        this.nbtRoot = new NBTTagCompound();
        tile.writePowerInfoToNBT(this.nbtRoot);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        NetworkUtil.writeNBTTagCompound(this.nbtRoot, buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.nbtRoot = NetworkUtil.readNBTTagCompound(buf);
    }

    public IMessage onMessage(PacketPowerInfo message, MessageContext ctx) {
        EntityPlayer player = EnderIO.proxy.getClientPlayer();
        TilePowerMonitor te = (TilePowerMonitor)message.getTileEntity(player.field_70170_p);
        if (te != null) {
            te.readPowerInfoFromNBT(message.nbtRoot);
        }
        return null;
    }
}

