/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.monitor;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.power.NetworkPowerManager;
import crazypants.enderio.conduit.power.PowerConduitNetwork;
import crazypants.enderio.conduit.power.PowerTracker;
import crazypants.enderio.conduit.redstone.Signal;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.monitor.PacketPowerInfo;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.IInternalPowerReceptor;
import crazypants.util.DyeColor;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePowerMonitor
extends AbstractMachineEntity
implements IInternalPowerReceptor {
    int energyPerTick = 1;
    int powerInConduits;
    int maxPowerInCoduits;
    int powerInCapBanks;
    int maxPowerInCapBanks;
    int powerInMachines;
    int maxPowerInMachines;
    float aveRfSent;
    float aveRfRecieved;
    boolean engineControlEnabled = false;
    float startLevel = 0.75f;
    float stopLevel = 0.99f;
    private Signal currentlyEmmittedSignal;

    public TilePowerMonitor() {
        super(new SlotDefinition(0, 0));
    }

    @Override
    public boolean supportsMode(ForgeDirection faceHit, IoMode mode) {
        return mode == IoMode.NONE;
    }

    public int[] getRednetOutputValues(ForgeDirection side) {
        if (this.currentlyEmmittedSignal == null) {
            return new int[16];
        }
        int[] res = new int[DyeColor.values().length];
        for (DyeColor col : DyeColor.values()) {
            res[col.ordinal()] = this.currentlyEmmittedSignal.color == col ? 15 : 0;
        }
        return res;
    }

    public int getRednetOutputValue(ForgeDirection side, int subnet) {
        if (this.currentlyEmmittedSignal != null) {
            return 15;
        }
        return 0;
    }

    int asPercentInt(float val) {
        return Math.round(val * 100.0f);
    }

    float asPercentFloat(int val) {
        return (float)val / 100.0f;
    }

    @Override
    public String func_145825_b() {
        return EnderIO.blockPowerMonitor.func_149739_a();
    }

    @Override
    public String getMachineName() {
        return ModObject.blockPowerMonitor.unlocalisedName;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    public float getEnergyPerTick() {
        return this.energyPerTick;
    }

    public float getPowerInConduits() {
        return this.powerInConduits;
    }

    public float getMaxPowerInCoduits() {
        return this.maxPowerInCoduits;
    }

    public float getPowerInCapBanks() {
        return this.powerInCapBanks;
    }

    public float getMaxPowerInCapBanks() {
        return this.maxPowerInCapBanks;
    }

    public float getPowerInMachines() {
        return this.powerInMachines;
    }

    public float getMaxPowerInMachines() {
        return this.maxPowerInMachines;
    }

    public float getAveRfSent() {
        return this.aveRfSent;
    }

    public float getAveRfRecieved() {
        return this.aveRfRecieved;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        this.setEnergyStored(this.getEnergyStored() - this.energyPerTick);
        boolean update = this.field_145850_b.func_72912_H().func_82573_f() % 10L == 0L;
        NetworkPowerManager pm = this.getPowerManager();
        if (pm != null && update) {
            this.update(pm);
            Signal sig = null;
            if (!this.engineControlEnabled) {
                sig = null;
            } else {
                float percentFull = this.getPercentFull();
                if (this.currentlyEmmittedSignal == null) {
                    if (percentFull <= this.startLevel) {
                        sig = new Signal(this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.UNKNOWN, 15, DyeColor.RED);
                    }
                } else {
                    sig = percentFull >= this.stopLevel ? null : this.currentlyEmmittedSignal;
                }
            }
            if (this.currentlyEmmittedSignal != sig) {
                this.currentlyEmmittedSignal = sig;
                this.broadcastSignal();
            }
        }
        if (update) {
            PacketHandler.sendToAllAround(new PacketPowerInfo(this), this);
        }
        return false;
    }

    private void broadcastSignal() {
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)EnderIO.blockPowerMonitor);
    }

    private float getPercentFull() {
        return (float)(this.powerInConduits + this.powerInCapBanks) / (float)(this.maxPowerInCoduits + this.maxPowerInCapBanks);
    }

    private void update(NetworkPowerManager pm) {
        this.powerInConduits = pm.getPowerInConduits();
        this.maxPowerInCoduits = pm.getMaxPowerInConduits();
        this.powerInCapBanks = pm.getPowerInCapacitorBanks();
        this.maxPowerInCapBanks = pm.getMaxPowerInCapacitorBanks();
        this.powerInMachines = pm.getPowerInReceptors();
        this.maxPowerInMachines = pm.getMaxPowerInReceptors();
        PowerTracker tracker = pm.getNetworkPowerTracker();
        this.aveRfSent = tracker.getAverageRfTickSent();
        this.aveRfRecieved = tracker.getAverageRfTickRecieved();
    }

    private NetworkPowerManager getPowerManager() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            NetworkPowerManager pm;
            AbstractConduitNetwork<?, ?> n;
            IPowerConduit con = ConduitUtil.getConduit((IBlockAccess)this.field_145850_b, this, dir, IPowerConduit.class);
            if (con == null || !((n = con.getNetwork()) instanceof PowerConduitNetwork) || (pm = ((PowerConduitNetwork)n).getPowerManager()) == null) continue;
            return pm;
        }
        return null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        super.readCustomNBT(nbtRoot);
        this.readPowerInfoFromNBT(nbtRoot);
    }

    public void readPowerInfoFromNBT(NBTTagCompound nbtRoot) {
        this.powerInConduits = nbtRoot.func_74762_e("powerInConduits");
        this.maxPowerInCoduits = nbtRoot.func_74762_e("maxPowerInCoduits");
        this.powerInCapBanks = nbtRoot.func_74762_e("powerInCapBanks");
        this.maxPowerInCapBanks = nbtRoot.func_74762_e("maxPowerInCapBanks");
        this.powerInMachines = nbtRoot.func_74762_e("powerInMachines");
        this.maxPowerInMachines = nbtRoot.func_74762_e("maxPowerInMachines");
        this.aveRfSent = nbtRoot.func_74760_g("aveRfSent");
        this.aveRfRecieved = nbtRoot.func_74760_g("aveRfRecieved");
        this.engineControlEnabled = nbtRoot.func_74767_n("engineControlEnabled");
        this.startLevel = nbtRoot.func_74760_g("startLevel");
        this.stopLevel = nbtRoot.func_74760_g("stopLevel");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        super.writeCustomNBT(nbtRoot);
        this.writePowerInfoToNBT(nbtRoot);
    }

    public void writePowerInfoToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74768_a("powerInConduits", this.powerInConduits);
        nbtRoot.func_74768_a("maxPowerInCoduits", this.maxPowerInCoduits);
        nbtRoot.func_74768_a("powerInCapBanks", this.powerInCapBanks);
        nbtRoot.func_74768_a("maxPowerInCapBanks", this.maxPowerInCapBanks);
        nbtRoot.func_74768_a("powerInMachines", this.powerInMachines);
        nbtRoot.func_74768_a("maxPowerInMachines", this.maxPowerInMachines);
        nbtRoot.func_74776_a("aveRfSent", this.aveRfSent);
        nbtRoot.func_74776_a("aveRfRecieved", this.aveRfRecieved);
        nbtRoot.func_74757_a("engineControlEnabled", this.engineControlEnabled);
        nbtRoot.func_74776_a("startLevel", this.startLevel);
        nbtRoot.func_74776_a("stopLevel", this.stopLevel);
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }
}

