/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.power;

import cofh.api.energy.IEnergyContainerItem;
import crazypants.util.Lang;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import net.minecraft.item.ItemStack;

public class PowerDisplayUtil {
    private static final NumberFormat INT_NF;
    private static final NumberFormat FLOAT_NF;
    private static final boolean REPLACE_NBSP;
    private static final char NBSP = '\u00a0';

    public static String perTickStr() {
        return Lang.localize("power.tick");
    }

    public static String ofStr() {
        return Lang.localize("gui.powerMonitor.of");
    }

    public static String getStoredEnergyString(ItemStack item) {
        if (item == null) {
            return null;
        }
        if (!(item.func_77973_b() instanceof IEnergyContainerItem)) {
            return null;
        }
        IEnergyContainerItem ci = (IEnergyContainerItem)item.func_77973_b();
        return Lang.localize("item.tooltip.power") + " " + PowerDisplayUtil.formatPower(ci.getEnergyStored(item)) + "/" + PowerDisplayUtil.formatPower(ci.getMaxEnergyStored(item)) + " " + PowerDisplayUtil.abrevation();
    }

    public static String formatPowerPerTick(int powerPerTick) {
        return PowerDisplayUtil.formatPower(powerPerTick) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr();
    }

    public static String formatStoredPower(int amount, int capacity) {
        return PowerDisplayUtil.formatPower(amount) + "/" + PowerDisplayUtil.formatPower(capacity) + " " + PowerDisplayUtil.abrevation();
    }

    public static String formatPower(int powerRF) {
        String str = INT_NF.format(powerRF);
        if (REPLACE_NBSP) {
            str = str.replace('\u00a0', ' ');
        }
        return str;
    }

    public static String formatPowerFloat(float averageRfTickSent) {
        return FLOAT_NF.format(averageRfTickSent);
    }

    public static Integer parsePower(String power) {
        if (power == null) {
            return null;
        }
        try {
            Number d;
            if (REPLACE_NBSP) {
                power = power.replace(' ', '\u00a0');
            }
            if ((d = INT_NF.parse(power)) == null) {
                return null;
            }
            return d.intValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String abrevation() {
        return Lang.localize("power.rf");
    }

    static {
        DecimalFormatSymbols syms;
        INT_NF = NumberFormat.getIntegerInstance();
        FLOAT_NF = NumberFormat.getInstance();
        boolean res = false;
        if (INT_NF instanceof DecimalFormat && (syms = ((DecimalFormat)INT_NF).getDecimalFormatSymbols()).getGroupingSeparator() == '\u00a0') {
            res = true;
        }
        REPLACE_NBSP = res;
        FLOAT_NF.setMinimumFractionDigits(1);
        FLOAT_NF.setMaximumFractionDigits(1);
    }
}

