/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.recipe;

import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.machine.recipe.RecipeOutput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public abstract class AbstractMachineRecipe
implements IMachineRecipe {
    @Override
    public int getEnergyRequired(MachineRecipeInput ... inputs) {
        if (inputs == null || inputs.length <= 0) {
            return 0;
        }
        IRecipe recipe = this.getRecipeForInputs(inputs);
        return recipe == null ? 0 : recipe.getEnergyRequired();
    }

    public abstract IRecipe getRecipeForInputs(MachineRecipeInput[] var1);

    @Override
    public List<MachineRecipeInput> getQuantitiesConsumed(MachineRecipeInput[] inputs) {
        IRecipe rec = this.getRecipeForInputs(inputs);
        ArrayList<MachineRecipeInput> result = new ArrayList<MachineRecipeInput>();
        block0: for (RecipeInput ri : rec.getInputs()) {
            for (MachineRecipeInput input : inputs) {
                if (input == null || input.item == null && input.fluid == null) continue;
                if (ri.isInput(input.item) && (ri.getSlotNumber() == -1 || ri.getSlotNumber() == input.slotNumber)) {
                    result.add(new MachineRecipeInput(input.slotNumber, ri.getInput().func_77946_l()));
                    continue block0;
                }
                if (!ri.isInput(input.fluid)) continue;
                result.add(new MachineRecipeInput(input.slotNumber, ri.getFluidInput().copy()));
                continue block0;
            }
        }
        return result;
    }

    @Override
    public float getExperianceForOutput(ItemStack output) {
        return 0.0f;
    }

    @Override
    public boolean isRecipe(MachineRecipeInput ... inputs) {
        if (inputs == null || inputs.length <= 0) {
            return false;
        }
        IRecipe recipe = this.getRecipeForInputs(inputs);
        return recipe != null;
    }

    @Override
    public IMachineRecipe.ResultStack[] getCompletedResult(float chance, MachineRecipeInput ... inputs) {
        if (inputs == null || inputs.length <= 0) {
            return new IMachineRecipe.ResultStack[0];
        }
        IRecipe recipe = this.getRecipeForInputs(inputs);
        if (recipe == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        RecipeOutput[] outputs = recipe.getOutputs();
        if (outputs == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        ArrayList<IMachineRecipe.ResultStack> result = new ArrayList<IMachineRecipe.ResultStack>();
        for (RecipeOutput output : outputs) {
            if (!(output.getChance() >= chance)) continue;
            if (output.isFluid()) {
                result.add(new IMachineRecipe.ResultStack(output.getFluidOutput().copy()));
                continue;
            }
            result.add(new IMachineRecipe.ResultStack(output.getOutput().func_77946_l()));
        }
        return result.toArray(new IMachineRecipe.ResultStack[result.size()]);
    }
}

