/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.recipe;

import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.recipe.IManyToOneRecipe;
import crazypants.enderio.machine.recipe.Recipe;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.machine.recipe.RecipeOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BasicManyToOneRecipe
implements IManyToOneRecipe {
    private final int energyRequired;
    private final ItemStack output;
    private final float expPerItem;
    private final Recipe recipe;

    public BasicManyToOneRecipe(Recipe recipe) {
        this.recipe = recipe;
        this.output = recipe.getOutputs()[0].getOutput().func_77946_l();
        this.expPerItem = recipe.getOutputs()[0].getExperiance();
        this.energyRequired = recipe.getEnergyRequired();
    }

    @Override
    public boolean isValidRecipeComponents(ItemStack ... items) {
        ArrayList<RecipeInput> inputs = new ArrayList<RecipeInput>(Arrays.asList(this.recipe.getInputs()));
        for (ItemStack is : items) {
            if (is == null) continue;
            RecipeInput remove = null;
            for (RecipeInput ri : inputs) {
                if (!ri.isInput(is)) continue;
                remove = ri;
                break;
            }
            if (remove != null) {
                inputs.remove(remove);
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public boolean isValidInput(int slot, ItemStack input) {
        if (input == null) {
            return false;
        }
        return this.getRecipeComponentFromInput(input) != null;
    }

    @Override
    public boolean isValidInput(FluidStack fluid) {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.recipe != null && this.recipe.isValid();
    }

    @Override
    public int getEnergyRequired() {
        return this.energyRequired;
    }

    @Override
    public RecipeOutput[] getOutputs() {
        return this.recipe.getOutputs();
    }

    @Override
    public List<ItemStack> getInputStacks() {
        return this.recipe.getInputStacks();
    }

    @Override
    public boolean isInputForRecipe(MachineRecipeInput ... inputs) {
        if (inputs == null) {
            return false;
        }
        return this.recipe.isInputForRecipe(inputs);
    }

    @Override
    public RecipeInput[] getInputs() {
        return this.recipe.getInputs();
    }

    @Override
    public List<FluidStack> getInputFluidStacks() {
        return Collections.emptyList();
    }

    private ItemStack getRecipeComponentFromInput(ItemStack input) {
        if (input == null) {
            return null;
        }
        for (RecipeInput ri : this.recipe.getInputs()) {
            if (!ri.isInput(input)) continue;
            return ri.getInput();
        }
        return null;
    }
}

