/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.recipe;

import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.machine.recipe.RecipeOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class Recipe
implements IRecipe {
    private final RecipeInput[] inputs;
    private final RecipeOutput[] outputs;
    private final int energyRequired;

    public Recipe(RecipeOutput output, int energyRequired, RecipeInput ... input) {
        this(input, new RecipeOutput[]{output}, energyRequired);
    }

    public Recipe(RecipeInput input, int energyRequired, RecipeOutput ... output) {
        this(new RecipeInput[]{input}, output, energyRequired);
    }

    public Recipe(RecipeInput[] input, RecipeOutput[] output, int energyRequired) {
        this.inputs = input;
        this.outputs = output;
        this.energyRequired = energyRequired;
    }

    @Override
    public boolean isInputForRecipe(MachineRecipeInput ... machineInputs) {
        if (machineInputs == null || machineInputs.length == 0) {
            return false;
        }
        ArrayList<RecipeInput> requiredInputs = new ArrayList<RecipeInput>();
        for (RecipeInput recipeInput : this.inputs) {
            if (recipeInput.getFluidInput() == null && recipeInput.getInput() == null) continue;
            requiredInputs.add(recipeInput.copy());
        }
        for (MachineRecipeInput machineRecipeInput : machineInputs) {
            if (machineRecipeInput == null || machineRecipeInput.fluid == null && machineRecipeInput.item == null) continue;
            RecipeInput required = null;
            for (int i = 0; i < requiredInputs.size() && required == null; ++i) {
                RecipeInput tst = (RecipeInput)requiredInputs.get(i);
                if ((!tst.isInput(machineRecipeInput.item) || tst.getInput().field_77994_a <= 0) && !tst.isInput(machineRecipeInput.fluid)) continue;
                required = tst;
            }
            if (required == null) {
                return false;
            }
            if (machineRecipeInput.isFluid()) {
                required.getFluidInput().amount -= machineRecipeInput.fluid.amount;
                continue;
            }
            required.getInput().field_77994_a -= machineRecipeInput.item.field_77994_a;
        }
        for (RecipeInput required : requiredInputs) {
            if (required.isFluid() && required.getFluidInput().amount > 0) {
                return false;
            }
            if (required.isFluid() || required.getInput().field_77994_a <= 0) continue;
            return false;
        }
        return true;
    }

    protected int getMinNumInputs() {
        return this.inputs.length;
    }

    @Override
    public boolean isValidInput(int slot, ItemStack item) {
        return this.getInputForStack(item) != null;
    }

    @Override
    public boolean isValidInput(FluidStack fluid) {
        return this.getInputForStack(fluid) != null;
    }

    private RecipeInput getInputForStack(FluidStack input) {
        for (RecipeInput ri : this.inputs) {
            if (!ri.isInput(input)) continue;
            return ri;
        }
        return null;
    }

    private RecipeInput getInputForStack(ItemStack input) {
        for (RecipeInput ri : this.inputs) {
            if (!ri.isInput(input)) continue;
            return ri;
        }
        return null;
    }

    @Override
    public List<ItemStack> getInputStacks() {
        if (this.inputs == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> res = new ArrayList<ItemStack>(this.inputs.length);
        for (int i = 0; i < this.inputs.length; ++i) {
            RecipeInput in = this.inputs[i];
            if (in == null || in.getInput() == null) continue;
            res.add(in.getInput());
        }
        return res;
    }

    @Override
    public List<FluidStack> getInputFluidStacks() {
        if (this.inputs == null) {
            return Collections.emptyList();
        }
        ArrayList<FluidStack> res = new ArrayList<FluidStack>(this.inputs.length);
        for (int i = 0; i < this.inputs.length; ++i) {
            RecipeInput in = this.inputs[i];
            if (in == null || in.getFluidInput() == null) continue;
            res.add(in.getFluidInput());
        }
        return res;
    }

    @Override
    public RecipeInput[] getInputs() {
        return this.inputs;
    }

    @Override
    public RecipeOutput[] getOutputs() {
        return this.outputs;
    }

    public boolean hasOuput(ItemStack result) {
        if (result == null) {
            return false;
        }
        for (RecipeOutput output : this.outputs) {
            ItemStack os = output.getOutput();
            if (os == null || !os.func_77969_a(result)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEnergyRequired() {
        return this.energyRequired;
    }

    @Override
    public boolean isValid() {
        return this.inputs != null && this.outputs != null && this.energyRequired > 0;
    }

    public String toString() {
        return "Recipe [input=" + Arrays.toString(this.inputs) + ", output=" + Arrays.toString(this.outputs) + ", energyRequired=" + this.energyRequired + "]";
    }
}

