/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.recipe;

import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.Log;
import crazypants.enderio.machine.recipe.CustomTagHandler;
import crazypants.enderio.machine.recipe.OreDictionaryRecipeInput;
import crazypants.enderio.machine.recipe.RecipeConfig;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.machine.recipe.RecipeOutput;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.io.IOUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class RecipeConfigParser
extends DefaultHandler {
    public static final String ELEMENT_RECIPE_GROUP = "recipeGroup";
    public static final String ELEMENT_RECIPE = "recipe";
    public static final String ELEMENT_INPUT = "input";
    public static final String ELEMENT_OUTPUT = "output";
    public static final String ELEMENT_ITEM_STACK = "itemStack";
    public static final String ELEMENT_FLUID_STACK = "fluidStack";
    public static final String ELEMENT_DUMP_REGISTERY = "dumpRegistery";
    public static final String AT_NAME = "name";
    public static final String AT_ENABLED = "enabled";
    public static final String AT_DUMP_ITEMS = "modObjects";
    public static final String AT_ORE_DICT = "oreDictionary";
    public static final String AT_ENERGY_COST = "energyCost";
    public static final String AT_ITEM_META = "itemMeta";
    public static final String AT_ITEM_NAME = "itemName";
    public static final String AT_MOD_ID = "modID";
    public static final String AT_NUMBER = "number";
    public static final String AT_AMOUNT = "amount";
    public static final String AT_MULTIPLIER = "multiplier";
    public static final String AT_SLOT = "slot";
    public static final String AT_CHANCE = "chance";
    public static final String AT_EXP = "exp";
    private static final String LP = "RecipeParser: ";
    private RecipeConfig result = null;
    private RecipeConfig root = null;
    private RecipeConfig.RecipeGroup recipeGroup = null;
    private RecipeConfig.RecipeElement recipe = null;
    private boolean outputTagOpen = false;
    private boolean inputTagOpen = false;
    private boolean debug = false;
    private boolean inCustomHandler = false;
    private CustomTagHandler customHandler = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecipeConfig parse(String str, CustomTagHandler customHandler) throws Exception {
        StringReader reader = new StringReader(str);
        InputSource is = new InputSource(reader);
        try {
            RecipeConfig recipeConfig = RecipeConfigParser.parse(is, customHandler);
            return recipeConfig;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecipeConfig parse(File file, CustomTagHandler customHandler) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        InputSource is = new InputSource(bis);
        try {
            RecipeConfig recipeConfig = RecipeConfigParser.parse(is, customHandler);
            return recipeConfig;
        }
        finally {
            IOUtils.closeQuietly((InputStream)bis);
        }
    }

    public static RecipeConfig parse(InputSource is, CustomTagHandler customHandler) throws Exception {
        RecipeConfigParser parser = new RecipeConfigParser(customHandler);
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setContentHandler(parser);
        xmlReader.parse(is);
        return parser.getResult();
    }

    RecipeConfigParser(CustomTagHandler customHandler) {
        this.customHandler = customHandler;
    }

    RecipeConfig getResult() {
        return this.result != null ? this.result : this.root;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        Log.warn("Warning parsing SAG Mill config file: " + e.getMessage());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        Log.error("Error parsing SAG Mill config file: " + e.getMessage());
        e.printStackTrace();
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        Log.error("Error parsing SAG Mill config file: " + e.getMessage());
        e.printStackTrace();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.isElementRoot(localName)) {
            this.result = this.root;
            this.root = null;
            if (this.debug) {
                Log.debug("RecipeParser: Closing root");
            }
            return;
        }
        if (ELEMENT_RECIPE_GROUP.equals(localName)) {
            if (this.debug) {
                Log.debug("RecipeParser: Closing recipe group");
            }
            if (this.recipeGroup != null && this.root != null) {
                this.root.addRecipeGroup(this.recipeGroup);
            }
            this.recipeGroup = null;
            return;
        }
        if (ELEMENT_RECIPE.equals(localName)) {
            if (this.debug) {
                Log.debug("RecipeParser: Closing recipe");
            }
            if (this.recipe != null && this.recipeGroup != null) {
                this.recipeGroup.addRecipe(this.recipe);
            } else {
                Log.warn("RecipeParser: Could not add recipe " + this.recipe + " to group " + this.recipeGroup);
            }
            this.recipe = null;
            return;
        }
        if (ELEMENT_OUTPUT.equals(localName)) {
            this.outputTagOpen = false;
            if (this.debug) {
                Log.debug("RecipeParser: Closing output");
            }
            return;
        }
        if (ELEMENT_INPUT.equals(localName)) {
            this.inputTagOpen = false;
            if (this.debug) {
                Log.debug("RecipeParser: Closing input");
            }
            return;
        }
        if (this.customHandler != null && this.customHandler.endElement(uri, localName, qName)) {
            this.inCustomHandler = false;
            return;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.debug) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < attributes.getLength(); ++i) {
                sb.append("[" + attributes.getQName(i) + "=" + attributes.getValue(i) + "]");
            }
            Log.debug("RecipeParser: RecipeConfigParser.startElement: localName:" + localName + " attrs:" + sb);
        }
        if (this.isElementRoot(localName)) {
            if (this.root != null) {
                Log.warn("RecipeParser: Multiple root elements found.");
            } else {
                this.root = new RecipeConfig();
            }
            return;
        }
        if (this.root == null) {
            Log.warn("RecipeParser:  Root element not specified before element " + localName + ".");
            this.root = new RecipeConfig();
        }
        if (ELEMENT_DUMP_REGISTERY.equals(localName)) {
            this.root.setDumpOreDictionary(RecipeConfigParser.getBooleanValue(AT_ORE_DICT, attributes, false));
            this.root.setDumpItemRegistery(RecipeConfigParser.getBooleanValue(AT_DUMP_ITEMS, attributes, false));
            return;
        }
        if (ELEMENT_RECIPE_GROUP.equals(localName)) {
            if (this.recipeGroup != null) {
                Log.warn("RecipeParser: Recipe group " + this.recipeGroup.getName() + " not closed before encountering a new recipe group.");
            }
            this.recipeGroup = this.root.createRecipeGroup(attributes.getValue(AT_NAME));
            this.recipeGroup.setEnabled(RecipeConfigParser.getBooleanValue(AT_ENABLED, attributes, true));
            if (!this.recipeGroup.isNameValid()) {
                Log.warn("RecipeParser: A recipe group was found with an invalid name: " + attributes.getValue(AT_NAME));
                this.recipeGroup = null;
            }
            return;
        }
        if (ELEMENT_RECIPE.equals(localName)) {
            String name;
            if (this.recipeGroup == null) {
                Log.warn("RecipeParser: A recipe was found outside of a recipe groups tags.");
                return;
            }
            if (this.recipe != null) {
                Log.warn("RecipeParser: A new recipe was started before the recipe was closed.");
            }
            if ((name = RecipeConfigParser.getStringValue(AT_NAME, attributes, null)) == null) {
                Log.warn("RecipeParser: An unnamed recipe was found.");
                return;
            }
            this.recipe = this.recipeGroup.createRecipe(name);
            this.recipe.setEnergyRequired(RecipeConfigParser.getIntValue(AT_ENERGY_COST, attributes, 400));
            return;
        }
        if (this.customHandler != null && this.customHandler.startElement(uri, localName, qName, attributes)) {
            this.inCustomHandler = true;
            return;
        }
        if (this.recipe == null) {
            if (!this.inCustomHandler) {
                Log.warn("RecipeParser: Found element <" + localName + "> with no recipe decleration.");
            }
            return;
        }
        if (ELEMENT_OUTPUT.equals(localName)) {
            if (this.inputTagOpen) {
                Log.warn("RecipeParser: <output> encounterd before <input> closed.");
                this.inputTagOpen = false;
            }
            if (this.outputTagOpen) {
                Log.warn("RecipeParser: <output> encounterd before previous <output> closed.");
            }
            this.outputTagOpen = true;
            return;
        }
        if (ELEMENT_INPUT.equals(localName)) {
            if (this.outputTagOpen) {
                Log.warn("RecipeParser: <input> encounterd before <output> closed.");
                this.outputTagOpen = false;
            }
            if (this.inputTagOpen) {
                Log.warn("RecipeParser: <input> encounterd before previous <input> closed.");
            }
            this.inputTagOpen = true;
            return;
        }
        boolean isFluidStack = ELEMENT_FLUID_STACK.equals(localName);
        if (ELEMENT_ITEM_STACK.equals(localName) || isFluidStack) {
            if (!this.inputTagOpen && !this.outputTagOpen) {
                Log.warn("RecipeParser: Encounterd an item stack outside of either an <input> or <output> tag.");
                return;
            }
            if (this.inputTagOpen && this.outputTagOpen) {
                Log.warn("RecipeParser: Encounterd an item stack within both an <input> and <output> tag.");
                return;
            }
            if (this.inputTagOpen) {
                if (isFluidStack) {
                    this.addInputFluidStack(attributes);
                } else {
                    this.addInputStack(attributes);
                }
            } else if (isFluidStack) {
                this.addOutputFluidStack(attributes);
            } else {
                this.addOutputStack(attributes);
            }
        }
    }

    private boolean isElementRoot(String str) {
        return "AlloySmelterRecipes".equals(str) || "SAGMillRecipes".equals(str) || "VatRecipes".equals(str) || "SliceAndSpliceRecipes".equals(str);
    }

    private void addOutputStack(Attributes attributes) {
        RecipeInput stack = RecipeConfigParser.getItemStack(attributes);
        if (stack == null) {
            return;
        }
        float exp = RecipeConfigParser.getFloatValue(AT_EXP, attributes, 0.0f);
        this.recipe.addOutput(new RecipeOutput(stack.getInput(), RecipeConfigParser.getFloatValue(AT_CHANCE, attributes, 1.0f), exp));
    }

    private void addInputStack(Attributes attributes) {
        RecipeInput stack = RecipeConfigParser.getItemStack(attributes);
        if (stack == null) {
            return;
        }
        this.recipe.addInput(stack);
    }

    private void addOutputFluidStack(Attributes attributes) {
        RecipeInput stack = this.getFluidStack(attributes);
        if (stack == null) {
            return;
        }
        this.recipe.addOutput(new RecipeOutput(stack.getFluidInput()));
    }

    private void addInputFluidStack(Attributes attributes) {
        RecipeInput stack = this.getFluidStack(attributes);
        if (stack == null) {
            return;
        }
        this.recipe.addInput(stack);
    }

    private RecipeInput getFluidStack(Attributes attributes) {
        int amount = RecipeConfigParser.getIntValue(AT_AMOUNT, attributes, 1000);
        String name = RecipeConfigParser.getStringValue(AT_NAME, attributes, null);
        if (name == null) {
            return null;
        }
        Fluid fluid = FluidRegistry.getFluid((String)name);
        if (fluid == null) {
            Log.warn("When parsing recipes could not find fluid with name: " + name);
            return null;
        }
        return new RecipeInput(new FluidStack(fluid, amount), RecipeConfigParser.getFloatValue(AT_MULTIPLIER, attributes, 1.0f));
    }

    public static RecipeInput getItemStack(Attributes attributes) {
        int stackSize = RecipeConfigParser.getIntValue(AT_NUMBER, attributes, 1);
        String oreDict = RecipeConfigParser.getStringValue(AT_ORE_DICT, attributes, null);
        if (oreDict != null) {
            ArrayList ores = OreDictionary.getOres((String)oreDict);
            if (ores == null || ores.isEmpty() || ores.get(0) == null) {
                Log.debug("RecipeParser: Could not find an entry in the ore dictionary for " + oreDict);
                return null;
            }
            ItemStack stack = ((ItemStack)ores.get(0)).func_77946_l();
            stack.field_77994_a = stackSize;
            return new OreDictionaryRecipeInput(stack, OreDictionary.getOreID((String)oreDict), RecipeConfigParser.getFloatValue(AT_MULTIPLIER, attributes, 1.0f), RecipeConfigParser.getIntValue(AT_SLOT, attributes, -1));
        }
        boolean useMeta = true;
        int itemMeta = 0;
        String metaString = RecipeConfigParser.getStringValue(AT_ITEM_META, attributes, "0");
        if ("*".equals(metaString)) {
            useMeta = false;
        } else {
            itemMeta = RecipeConfigParser.getIntValue(AT_ITEM_META, attributes, 0);
        }
        ItemStack res = null;
        String modId = RecipeConfigParser.getStringValue(AT_MOD_ID, attributes, null);
        String name = RecipeConfigParser.getStringValue(AT_ITEM_NAME, attributes, null);
        if (modId != null && name != null) {
            Item i = GameRegistry.findItem((String)modId, (String)name);
            if (i != null) {
                res = new ItemStack(i, stackSize, useMeta ? itemMeta : 0);
            } else {
                Block b = GameRegistry.findBlock((String)modId, (String)name);
                if (b != null) {
                    res = new ItemStack(b, stackSize, useMeta ? itemMeta : 0);
                }
            }
        }
        if (res == null) {
            Log.debug("Could not create an item stack from the attributes " + RecipeConfigParser.toString(attributes));
            return null;
        }
        return new RecipeInput(res, useMeta, RecipeConfigParser.getFloatValue(AT_MULTIPLIER, attributes, 1.0f), RecipeConfigParser.getIntValue(AT_SLOT, attributes, -1));
    }

    public static boolean getBooleanValue(String qName, Attributes attributes, boolean def) {
        String val = attributes.getValue(qName);
        if (val == null) {
            return def;
        }
        return (val = val.toLowerCase().trim()).equals("false") ? false : (val.equals("true") ? true : def);
    }

    public static int getIntValue(String qName, Attributes attributes, int def) {
        try {
            return Integer.parseInt(RecipeConfigParser.getStringValue(qName, attributes, def + ""));
        }
        catch (Exception e) {
            Log.warn("RecipeParser: Could not parse a valid int for attribute " + qName + " with value " + RecipeConfigParser.getStringValue(qName, attributes, null));
            return def;
        }
    }

    public static float getFloatValue(String qName, Attributes attributes, float def) {
        try {
            return Float.parseFloat(RecipeConfigParser.getStringValue(qName, attributes, def + ""));
        }
        catch (Exception e) {
            Log.warn("RecipeParser: Could not parse a valid float for attribute " + qName + " with value " + RecipeConfigParser.getStringValue(qName, attributes, null));
            return def;
        }
    }

    public static String getStringValue(String qName, Attributes attributes, String def) {
        String val = attributes.getValue(qName);
        if (val == null) {
            return def;
        }
        if ((val = val.trim()).length() <= 0) {
            return null;
        }
        return val;
    }

    public static boolean hasAttribute(String att, Attributes attributes) {
        return attributes.getValue(att) != null;
    }

    public static String toString(Attributes attributes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < attributes.getLength(); ++i) {
            sb.append("[" + attributes.getQName(i) + "=" + attributes.getValue(i) + "]");
        }
        return sb.toString();
    }
}

