/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.solar;

import crazypants.enderio.config.Config;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.IInternalPowerReceptor;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.util.BlockCoord;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySolarPanel
extends TileEntity
implements IInternalPowerReceptor {
    private BasicCapacitor capacitor;
    private final List<Receptor> receptors = new ArrayList<Receptor>();
    private ListIterator<Receptor> receptorIterator = this.receptors.listIterator();
    private boolean receptorsDirty = true;
    private int lastCollectionValue = -1;
    private int checkOffset = (int)(Math.random() * 20.0);
    private static final int CHECK_INTERVAL = 100;
    private int storedEnergyRF;

    public TileEntitySolarPanel() {
        this.capacitor = new BasicCapacitor(0, 10000, Config.maxPhotovoltaicAdvancedOutputRF * 5);
    }

    public void onNeighborBlockChange() {
        this.receptorsDirty = true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return PowerHandlerUtil.recieveInternal(this, maxReceive, from, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaxEnergyStored();
    }

    @Override
    public int getMaxEnergyRecieved(ForgeDirection dir) {
        return this.capacitor.getMaxEnergyReceived();
    }

    @Override
    public int getEnergyStored() {
        return this.storedEnergyRF;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.capacitor.getMaxEnergyStored();
    }

    @Override
    public void setEnergyStored(int stored) {
        this.storedEnergyRF = Math.max(stored, 0);
    }

    public void func_145845_h() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.collectEnergy();
        this.transmitEnergy();
    }

    private void collectEnergy() {
        if (!this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        if (this.lastCollectionValue == -1 || (this.field_145850_b.func_72820_D() + (long)this.checkOffset) % 100L == 0L) {
            float fromSun = this.calculateLightRatio();
            this.lastCollectionValue = Math.round((float)this.getEnergyPerTick() * fromSun);
        }
        if (this.lastCollectionValue > 0) {
            int lastRF = this.storedEnergyRF;
            this.storedEnergyRF = Math.min(this.lastCollectionValue + this.storedEnergyRF, this.capacitor.getMaxEnergyStored());
            if (lastRF != this.storedEnergyRF) {
                MinecraftServer.func_71276_C().func_71203_ab().func_148537_a(this.func_145844_m(), this.field_145850_b.field_73011_w.field_76574_g);
            }
        }
    }

    private int getEnergyPerTick() {
        int meta = this.func_145832_p();
        if (meta == 0) {
            return Config.maxPhotovoltaicOutputRF;
        }
        return Config.maxPhotovoltaicAdvancedOutputRF;
    }

    float calculateLightRatio() {
        int lightValue = this.field_145850_b.func_72972_b(EnumSkyBlock.Sky, this.field_145851_c, this.field_145848_d, this.field_145849_e) - this.field_145850_b.field_73008_k;
        float sunAngle = this.field_145850_b.func_72929_e(1.0f);
        sunAngle = sunAngle < (float)Math.PI ? (sunAngle += (0.0f - sunAngle) * 0.2f) : (sunAngle += ((float)Math.PI * 2 - sunAngle) * 0.2f);
        lightValue = Math.round((float)lightValue * MathHelper.func_76134_b((float)sunAngle));
        lightValue = MathHelper.func_76125_a((int)lightValue, (int)0, (int)15);
        return (float)lightValue / 15.0f;
    }

    private boolean transmitEnergy() {
        int canTransmit = Math.min(this.getEnergyStored(), this.capacitor.getMaxEnergyExtracted());
        int transmitted = 0;
        this.checkReceptors();
        if (!this.receptors.isEmpty() && !this.receptorIterator.hasNext()) {
            this.receptorIterator = this.receptors.listIterator();
        }
        int numReceptors = this.receptors.size();
        for (int appliedCount = 0; this.receptorIterator.hasNext() && canTransmit > 0 && appliedCount < numReceptors; ++appliedCount) {
            Receptor receptor = this.receptorIterator.next();
            IPowerInterface pp = receptor.receptor;
            if (pp != null && pp.getMinEnergyReceived(receptor.fromDir.getOpposite()) <= canTransmit) {
                int used = pp.recieveEnergy(receptor.fromDir.getOpposite(), canTransmit);
                transmitted += used;
                canTransmit -= used;
            }
            if (canTransmit <= 0) break;
            if (this.receptors.isEmpty() || this.receptorIterator.hasNext()) continue;
            this.receptorIterator = this.receptors.listIterator();
        }
        this.setEnergyStored(this.getEnergyStored() - transmitted);
        return transmitted > 0;
    }

    private void checkReceptors() {
        if (!this.receptorsDirty) {
            return;
        }
        this.receptors.clear();
        BlockCoord bc = new BlockCoord(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ForgeDirection dir = ForgeDirection.DOWN;
        BlockCoord checkLoc = bc.getLocation(dir);
        TileEntity te = this.field_145850_b.func_147438_o(checkLoc.x, checkLoc.y, checkLoc.z);
        IPowerInterface pi = PowerHandlerUtil.create(te);
        if (pi != null) {
            this.receptors.add(new Receptor(pi, dir));
        }
        this.receptorIterator = this.receptors.listIterator();
        this.receptorsDirty = false;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.storedEnergyRF = tag.func_74762_e("storedEnergyRF");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("storedEnergyRF", this.storedEnergyRF);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    static class Receptor {
        IPowerInterface receptor;
        ForgeDirection fromDir;

        private Receptor(IPowerInterface rec, ForgeDirection fromDir) {
            this.receptor = rec;
            this.fromDir = fromDir;
        }
    }
}

