/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.soul;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.soul.ISoulBinderRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class AbstractSoulBinderRecipe
implements IMachineRecipe,
ISoulBinderRecipe {
    private int energyRequired;
    private String uid;
    private int xpRequired;
    private List<String> supportedEntities = new ArrayList<String>();

    protected AbstractSoulBinderRecipe(int energyRequired, int xpRequired, String uid, Class<?> entityClass) {
        this.energyRequired = energyRequired;
        this.xpRequired = xpRequired;
        this.uid = uid;
        this.supportedEntities.add((String)EntityList.field_75626_c.get(entityClass));
    }

    protected AbstractSoulBinderRecipe(int energyRequired, int xpRequired, String uid, String ... entityNames) {
        this.energyRequired = energyRequired;
        this.xpRequired = xpRequired;
        this.uid = uid;
        for (String name : entityNames) {
            this.supportedEntities.add(name);
        }
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public int getExperienceRequired() {
        return this.xpRequired;
    }

    @Override
    public int getEnergyRequired(MachineRecipeInput ... inputs) {
        return this.getEnergyRequired();
    }

    @Override
    public boolean isRecipe(MachineRecipeInput ... inputs) {
        int validCount = 0;
        for (MachineRecipeInput input : inputs) {
            if (this.isValidInput(input)) {
                ++validCount;
                continue;
            }
            return false;
        }
        return validCount == 2;
    }

    @Override
    public IMachineRecipe.ResultStack[] getCompletedResult(float randomChance, MachineRecipeInput ... inputs) {
        String mobType = null;
        for (MachineRecipeInput input : inputs) {
            if (input == null || !EnderIO.itemSoulVessel.containsSoul(input.item)) continue;
            mobType = EnderIO.itemSoulVessel.getMobTypeFromStack(input.item);
        }
        if (!this.getSupportedSouls().contains(mobType)) {
            return new IMachineRecipe.ResultStack[0];
        }
        ItemStack resultStack = this.getOutputStack(mobType);
        ItemStack soulVessel = new ItemStack((Item)EnderIO.itemSoulVessel);
        return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(soulVessel), new IMachineRecipe.ResultStack(resultStack)};
    }

    @Override
    public float getExperianceForOutput(ItemStack output) {
        return 0.0f;
    }

    @Override
    public boolean isValidInput(MachineRecipeInput input) {
        if (input == null || input.item == null) {
            return false;
        }
        int slot = input.slotNumber;
        ItemStack item = input.item;
        if (slot == 0) {
            String type = EnderIO.itemSoulVessel.getMobTypeFromStack(item);
            return this.getSupportedSouls().contains(type);
        }
        if (slot == 1) {
            return item.func_77969_a(this.getInputStack());
        }
        return false;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockSoulBinder.unlocalisedName;
    }

    @Override
    public List<MachineRecipeInput> getQuantitiesConsumed(MachineRecipeInput[] inputs) {
        ArrayList<MachineRecipeInput> result = new ArrayList<MachineRecipeInput>(inputs.length);
        for (MachineRecipeInput input : inputs) {
            if (input == null || input.item == null) continue;
            ItemStack resStack = input.item.func_77946_l();
            resStack.field_77994_a = 1;
            MachineRecipeInput mri = new MachineRecipeInput(input.slotNumber, resStack);
            result.add(mri);
        }
        return result;
    }

    protected ItemStack getOutputStack(String mobType) {
        return this.getOutputStack();
    }

    @Override
    public List<String> getSupportedSouls() {
        return this.supportedEntities;
    }

    @Override
    public int getEnergyRequired() {
        return this.energyRequired;
    }

    public void setEnergyRequired(int energyRequired) {
        this.energyRequired = energyRequired;
    }
}

