/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.spawner;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.gui.IAdvancedTooltipProvider;
import crazypants.enderio.gui.TooltipAddera;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.spawner.ContainerPoweredSpawner;
import crazypants.enderio.machine.spawner.DummyRecipe;
import crazypants.enderio.machine.spawner.GuiPoweredSpawner;
import crazypants.enderio.machine.spawner.ItemBrokenSpawner;
import crazypants.enderio.machine.spawner.PoweredSpawnerConfig;
import crazypants.enderio.machine.spawner.TilePoweredSpawner;
import crazypants.util.Lang;
import crazypants.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.world.BlockEvent;

public class BlockPoweredSpawner
extends AbstractMachineBlock<TilePoweredSpawner>
implements IAdvancedTooltipProvider {
    private final List<DropInfo> dropQueue = new ArrayList<DropInfo>();
    private final List<GameRegistry.UniqueIdentifier> toolBlackList = new ArrayList<GameRegistry.UniqueIdentifier>();

    public static void writeMobTypeToNBT(NBTTagCompound nbt, String type) {
        if (nbt == null) {
            return;
        }
        if (type == null) {
            nbt.func_82580_o("mobType");
        } else {
            nbt.func_74778_a("mobType", type);
        }
    }

    public static String readMobTypeFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        if (!nbt.func_74764_b("mobType")) {
            return null;
        }
        return nbt.func_74779_i("mobType");
    }

    public static String getSpawnerTypeFromItemStack(ItemStack stack) {
        if (stack == null || stack.func_77973_b() != Item.func_150898_a((Block)EnderIO.blockPoweredSpawner)) {
            return null;
        }
        return BlockPoweredSpawner.readMobTypeFromNBT(stack.field_77990_d);
    }

    public static BlockPoweredSpawner create() {
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPoweredSpawner.unlocalisedName, new DummyRecipe());
        PoweredSpawnerConfig.getInstance();
        BlockPoweredSpawner res = new BlockPoweredSpawner();
        MinecraftForge.EVENT_BUS.register((Object)res);
        FMLCommonHandler.instance().bus().register((Object)res);
        res.init();
        return res;
    }

    protected BlockPoweredSpawner() {
        super(ModObject.blockPoweredSpawner, TilePoweredSpawner.class);
        String[] blackListNames;
        for (String name : blackListNames = Config.brokenSpawnerToolBlacklist) {
            this.toolBlackList.add(new GameRegistry.UniqueIdentifier(name));
        }
    }

    @SubscribeEvent
    public void onBreakEvent(BlockEvent.BreakEvent evt) {
        TileEntity tile;
        if (evt.block instanceof BlockMobSpawner && evt.getPlayer() != null && !evt.getPlayer().field_71075_bZ.field_75098_d && !evt.getPlayer().field_70170_p.field_72995_K && !evt.isCanceled() && (tile = evt.getPlayer().field_70170_p.func_147438_o(evt.x, evt.y, evt.z)) instanceof TileEntityMobSpawner) {
            String name;
            TileEntityMobSpawner spawner;
            MobSpawnerBaseLogic logic;
            if (Math.random() > Config.brokenSpawnerDropChance) {
                return;
            }
            ItemStack equipped = evt.getPlayer().func_71045_bC();
            if (equipped != null) {
                for (GameRegistry.UniqueIdentifier uid : this.toolBlackList) {
                    Item blackListItem = GameRegistry.findItem((String)uid.modId, (String)uid.name);
                    if (blackListItem != equipped.func_77973_b()) continue;
                    return;
                }
            }
            if ((logic = (spawner = (TileEntityMobSpawner)tile).func_145881_a()) != null && (name = logic.func_98276_e()) != null && !this.isBlackListed(name)) {
                ItemStack drop = ItemBrokenSpawner.createStackForMobType(name);
                this.dropQueue.add(new DropInfo(evt, drop));
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (DropInfo action : this.dropQueue) {
            action.doDrop();
        }
        this.dropQueue.clear();
    }

    @SubscribeEvent
    public void handleAnvilEvent(AnvilUpdateEvent evt) {
        if (evt.left == null || evt.left.field_77994_a != 1 || evt.left.func_77973_b() != Item.func_150898_a((Block)EnderIO.blockPoweredSpawner) || evt.right == null || ItemBrokenSpawner.getMobTypeFromStack(evt.right) == null) {
            return;
        }
        String spawnerType = ItemBrokenSpawner.getMobTypeFromStack(evt.right);
        if (this.isBlackListed(spawnerType)) {
            return;
        }
        evt.cost = Config.powerSpawnerAddSpawnerCost;
        evt.output = evt.left.func_77946_l();
        if (evt.output.field_77990_d == null) {
            evt.output.field_77990_d = new NBTTagCompound();
        }
        evt.output.field_77990_d.func_74757_a("eio.abstractMachine", true);
        BlockPoweredSpawner.writeMobTypeToNBT(evt.output.field_77990_d, spawnerType);
    }

    public boolean isBlackListed(String entityId) {
        return PoweredSpawnerConfig.getInstance().isBlackListed(entityId);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TilePoweredSpawner) {
            return new ContainerPoweredSpawner(player.field_71071_by, (TilePoweredSpawner)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TilePoweredSpawner) {
            return new GuiPoweredSpawner(player.field_71071_by, (TilePoweredSpawner)te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 88;
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        if (active) {
            return "enderio:poweredSpawnerFrontActive";
        }
        return "enderio:poweredSpawnerFront";
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        String type = BlockPoweredSpawner.getSpawnerTypeFromItemStack(itemstack);
        if (type != null) {
            list.add(StatCollector.func_74838_a((String)("entity." + type + ".name")));
        } else {
            list.add(Lang.localize("tile.blockPoweredSpawner.tooltip.empty", false));
        }
    }

    @Override
    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
    }

    @Override
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        String type = BlockPoweredSpawner.getSpawnerTypeFromItemStack(itemstack);
        if (type == null) {
            TooltipAddera.addDetailedTooltipFromResources(list, "tile.blockPoweredSpawner.empty");
        } else {
            TooltipAddera.addDetailedTooltipFromResources(list, "tile.blockPoweredSpawner");
        }
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TilePoweredSpawner te = (TilePoweredSpawner)world.func_147438_o(x, y, z);
        tooltip.add(te.getEntityName());
    }

    @Override
    public int getDefaultDisplayMask(World world, int x, int y, int z) {
        return 4;
    }

    private static class DropInfo {
        BlockEvent.BreakEvent evt;
        ItemStack drop;

        DropInfo(BlockEvent.BreakEvent evt, ItemStack stack) {
            this.evt = evt;
            this.drop = stack;
        }

        void doDrop() {
            if (this.evt.isCanceled()) {
                return;
            }
            Util.dropItems(this.evt.getPlayer().field_70170_p, this.drop, this.evt.x, this.evt.y, this.evt.z, true);
        }
    }
}

