/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.spawner;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import crazypants.enderio.Log;
import crazypants.util.IoUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PoweredSpawnerConfig {
    static final PoweredSpawnerConfig instance = new PoweredSpawnerConfig();
    private static final String CORE_FILE_NAME = "PoweredSpawnerConfig_Core.json";
    private static final String USER_FILE_NAME = "PoweredSpawnerConfig_User.json";
    private final Map<String, Double> costs = new HashMap<String, Double>();
    private final List<String> blackList = new ArrayList<String>();

    public static PoweredSpawnerConfig getInstance() {
        return instance;
    }

    public double getCostMultiplierFor(String entity) {
        Double val = this.costs.get(entity);
        if (val == null) {
            return 1.0;
        }
        return val;
    }

    public boolean isBlackListed(String entity) {
        if (entity == null) {
            return true;
        }
        return this.blackList.contains(entity);
    }

    private PoweredSpawnerConfig() {
        String s;
        JsonArray blkList;
        JsonObject costsObj;
        JsonObject rootObj;
        JsonElement root;
        String configText;
        try {
            configText = IoUtil.copyConfigFromJar(CORE_FILE_NAME, true);
            root = new JsonParser().parse(configText);
            rootObj = root.getAsJsonObject();
            costsObj = rootObj.getAsJsonObject("costMultiplier");
            for (Map.Entry entry : costsObj.entrySet()) {
                this.costs.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsDouble());
            }
            blkList = rootObj.getAsJsonArray("blackList");
            if (blkList != null) {
                for (int i = 0; i < blkList.size(); ++i) {
                    s = blkList.get(i).getAsString();
                    this.blackList.add(s);
                }
            } else {
                Log.warn("No black list for powered spawner found in " + IoUtil.getConfigFile(CORE_FILE_NAME).getAbsolutePath());
            }
        }
        catch (Exception e) {
            Log.error("Could not load Powered Spawner costs from " + IoUtil.getConfigFile(CORE_FILE_NAME).getAbsolutePath());
            e.printStackTrace();
        }
        try {
            configText = IoUtil.copyConfigFromJar(USER_FILE_NAME, false);
            root = new JsonParser().parse(configText);
            rootObj = root.getAsJsonObject();
            costsObj = rootObj.getAsJsonObject("costMultiplier");
            for (Map.Entry entry : costsObj.entrySet()) {
                double val = ((JsonElement)entry.getValue()).getAsDouble();
                this.costs.put((String)entry.getKey(), val);
            }
            blkList = rootObj.getAsJsonArray("blackList");
            if (blkList != null) {
                this.blackList.clear();
                Log.info("Replacing default Powered Spawner blacklist with user supplied values.");
                for (int i = 0; i < blkList.size(); ++i) {
                    s = blkList.get(i).getAsString();
                    this.blackList.add(s);
                }
            }
        }
        catch (Exception e) {
            Log.error("Could not load user defined Powered Spawner costs from " + IoUtil.getConfigFile(USER_FILE_NAME).getAbsolutePath());
            e.printStackTrace();
        }
    }
}

