/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.spawnguard;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.spawnguard.RangeEntity;
import crazypants.enderio.machine.spawnguard.SpawnGuardController;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.ICapacitor;
import crazypants.render.BoundingBox;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;

public class TileSpawnGuard
extends AbstractMachineEntity {
    private ICapacitor capacitor;
    private int powerPerTick;
    private int range;
    private int rangeSqu;
    private boolean registered = false;
    private AxisAlignedBB bounds;
    private boolean showingRange;

    public TileSpawnGuard() {
        super(new SlotDefinition(12, 0));
        this.setUpdrade(Capacitors.BASIC_CAPACITOR);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            this.field_145850_b.func_72838_d((Entity)new RangeEntity(this));
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        SpawnGuardController.instance.deregisterGuard(this);
        this.registered = false;
    }

    public int getRange() {
        return this.range;
    }

    @Override
    public void setCapacitor(Capacitors capacitorType) {
        this.setUpdrade(capacitorType);
        super.setCapacitor(capacitorType);
    }

    @Override
    public ICapacitor getCapacitor() {
        return this.capacitor;
    }

    private void setUpdrade(Capacitors capacitorType) {
        switch (capacitorType) {
            case ACTIVATED_CAPACITOR: {
                this.range = Config.spawnGuardRangeLevelTwo;
                this.powerPerTick = Config.spawnGuardPowerPerTickLevelTwo;
                break;
            }
            case ENDER_CAPACITOR: {
                this.range = Config.spawnGuardRangeLevelThree;
                this.powerPerTick = Config.spawnGuardPowerPerTickLevelThree;
                break;
            }
            default: {
                this.range = Config.spawnGuardRangeLevelOne;
                this.powerPerTick = Config.spawnGuardPowerPerTickLevelOne;
            }
        }
        this.rangeSqu = this.range * this.range;
        this.capacitor = new BasicCapacitor(this.powerPerTick * 8, capacitorType.capacitor.getMaxEnergyStored(), this.powerPerTick);
        BoundingBox bb = new BoundingBox(this.getLocation());
        bb = bb.scale((float)this.range + 0.5f, (float)this.range + 0.5f, (float)this.range + 0.5f).translate(0.5f, 0.5f, 0.5f);
        this.bounds = AxisAlignedBB.func_72330_a((double)bb.minX, (double)bb.minY, (double)bb.minZ, (double)bb.maxX, (double)bb.maxY, (double)bb.maxZ);
    }

    @Override
    public String getMachineName() {
        return ModObject.blockSpawnGuard.unlocalisedName;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (!this.slotDefinition.isInputSlot(i)) {
            return false;
        }
        String mob = EnderIO.itemSoulVessel.getMobTypeFromStack(itemstack);
        if (mob == null) {
            return false;
        }
        Class cl = (Class)EntityList.field_75625_b.get(mob);
        if (cl == null) {
            return false;
        }
        return EntityLiving.class.isAssignableFrom(cl);
    }

    @Override
    public boolean isActive() {
        return this.hasPower();
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        if (redstoneCheckPassed && this.hasPower()) {
            if (!this.registered) {
                SpawnGuardController.instance.registerGuard(this);
                this.registered = true;
            }
            this.usePower();
        }
        return false;
    }

    protected double usePower() {
        return this.usePower(this.getPowerUsePerTick());
    }

    protected int usePower(int wantToUse) {
        int used = Math.min(this.getEnergyStored(), wantToUse);
        this.setEnergyStored(Math.max(0, this.getEnergyStored() - used));
        return used;
    }

    @Override
    public int getPowerUsePerTick() {
        return this.powerPerTick;
    }

    public boolean isSpawnPrevented(EntityLivingBase mob) {
        return this.redstoneCheckPassed && this.hasPower() && this.isMobInRange(mob) && this.isMobInFilter(mob);
    }

    private boolean isMobInRange(EntityLivingBase mob) {
        if (mob == null) {
            return false;
        }
        return this.bounds.func_72318_a(Vec3.func_72443_a((double)mob.field_70165_t, (double)mob.field_70163_u, (double)mob.field_70161_v));
    }

    private boolean isMobInFilter(EntityLivingBase ent) {
        return this.isMobInFilter(EntityList.func_75621_b((Entity)ent));
    }

    private boolean isMobInFilter(String entityId) {
        for (int i = this.slotDefinition.minInputSlot; i <= this.slotDefinition.maxInputSlot; ++i) {
            String mob;
            if (this.inventory[i] == null || (mob = EnderIO.itemSoulVessel.getMobTypeFromStack(this.inventory[i])) == null || !mob.equals(entityId)) continue;
            return true;
        }
        return false;
    }
}

