/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.still;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.gui.IconButtonEIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.GuiMachineBase;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.still.ContainerVat;
import crazypants.enderio.machine.still.PacketDumpTank;
import crazypants.enderio.machine.still.TileVat;
import crazypants.enderio.machine.still.VatRecipeManager;
import crazypants.enderio.network.PacketHandler;
import crazypants.gui.GuiToolTip;
import crazypants.render.ColorUtil;
import crazypants.render.RenderUtil;
import crazypants.util.Lang;
import java.awt.Color;
import java.awt.Rectangle;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

public class GuiVat
extends GuiMachineBase {
    private static final String GUI_TEXTURE = "enderio:textures/gui/vat.png";
    private final TileVat vat;
    private IconButtonEIO dump1;
    private IconButtonEIO dump2;

    public GuiVat(InventoryPlayer inventory, TileVat te) {
        super(te, new ContainerVat(inventory, te));
        this.vat = te;
        this.addToolTip(new GuiToolTip(new Rectangle(30, 12, 15, 47), new String[]{""}){

            @Override
            protected void updateText() {
                this.text.clear();
                String heading = Lang.localize("vat.inputTank");
                if (((GuiVat)GuiVat.this).vat.inputTank.getFluid() != null) {
                    heading = heading + ": " + ((GuiVat)GuiVat.this).vat.inputTank.getFluid().getFluid().getLocalizedName();
                }
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)((GuiVat)GuiVat.this).vat.inputTank));
            }
        });
        this.addToolTip(new GuiToolTip(new Rectangle(132, 12, 15, 47), new String[]{""}){

            @Override
            protected void updateText() {
                this.text.clear();
                String heading = Lang.localize("vat.outputTank");
                if (((GuiVat)GuiVat.this).vat.outputTank.getFluid() != null) {
                    heading = heading + ": " + ((GuiVat)GuiVat.this).vat.outputTank.getFluid().getFluid().getLocalizedName();
                }
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)((GuiVat)GuiVat.this).vat.outputTank));
            }
        });
        this.dump1 = new IconButtonEIO(this, 1, 29, 62, IconEIO.REDSTONE_MODE_NEVER);
        this.dump1.setToolTip(Lang.localize("gui.machine.vat.dump.1"));
        this.dump2 = new IconButtonEIO(this, 2, 131, 62, IconEIO.REDSTONE_MODE_NEVER);
        this.dump2.setToolTip(Lang.localize("gui.machine.vat.dump.2"));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.dump1.onGuiInit();
        this.dump2.onGuiInit();
    }

    @Override
    public void renderSlotHighlights(IoMode mode) {
        super.renderSlotHighlights(mode);
        int x = 30;
        int y = 12;
        if (mode == IoMode.PULL || mode == IoMode.PUSH_PULL) {
            this.renderSlotHighlight(PULL_COLOR, x - 2, y - 2, 19, 51);
        }
        if (mode == IoMode.PUSH || mode == IoMode.PUSH_PULL) {
            x = 132;
            this.renderSlotHighlight(PUSH_COLOR, x - 2, y - 2, 19, 51);
        }
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture(GUI_TEXTURE);
        int guiLeft = (this.field_146294_l - this.field_146999_f) / 2;
        int guiTop = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiLeft, guiTop, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.vat.getProgress() < 1.0f && this.vat.getProgress() > 0.0f) {
            int scaled = this.vat.getProgressScaled(14) + 1;
            this.func_73729_b(guiLeft + 81, guiTop + 77 - scaled, 176, 14 - scaled, 14, scaled);
            IIcon inputIcon = null;
            if (this.vat.currentTaskInputFluid != null) {
                inputIcon = this.vat.currentTaskInputFluid.getStillIcon();
            }
            IIcon outputIcon = null;
            if (this.vat.currentTaskOutputFluid != null) {
                outputIcon = this.vat.currentTaskOutputFluid.getStillIcon();
            }
            if (inputIcon != null && outputIcon != null) {
                this.renderVat(inputIcon, outputIcon, this.vat.getProgress());
            }
        }
        int x = guiLeft + 30;
        int y = guiTop + 12;
        RenderUtil.renderGuiTank(this.vat.inputTank, x, y, this.field_73735_i, 15.0, 47.0);
        x = guiLeft + 132;
        RenderUtil.renderGuiTank(this.vat.outputTank, x, y, this.field_73735_i, 15.0, 47.0);
        if (this.vat.currentTaskOutputFluid != null || this.vat.outputTank.getFluidAmount() > 0) {
            String str;
            float mult;
            Fluid outputFluid = this.vat.outputTank.getFluidAmount() > 0 ? this.vat.outputTank.getFluid().getFluid() : this.vat.currentTaskOutputFluid;
            ItemStack inStack = this.vat.func_70301_a(0);
            if (inStack != null) {
                mult = VatRecipeManager.instance.getMultiplierForInput(inStack, outputFluid);
                str = "x" + mult;
                x = guiLeft + 63 - this.field_146289_q.func_78256_a(str) / 2;
                this.field_146289_q.func_85187_a(str, x, guiTop + 32, ColorUtil.getRGB(Color.gray), false);
            }
            if ((inStack = this.vat.func_70301_a(1)) != null) {
                mult = VatRecipeManager.instance.getMultiplierForInput(inStack, outputFluid);
                str = "x" + mult;
                x = guiLeft + 113 - this.field_146289_q.func_78256_a(str) / 2;
                this.field_146289_q.func_85187_a(str, x, guiTop + 32, ColorUtil.getRGB(Color.gray), false);
            }
        }
        RenderUtil.bindTexture(GUI_TEXTURE);
        super.func_146976_a(par1, par2, par3);
    }

    private void renderVat(IIcon inputIcon, IIcon outputIcon, float progress) {
        RenderUtil.bindBlockTexture();
        int x = this.field_147003_i + 76;
        int y = this.field_147009_r + 34;
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f * (1.0f - progress)));
        this.func_94065_a(x, y, inputIcon, 26, 28);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f * progress));
        this.func_94065_a(x, y, outputIcon, 26, 28);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture(GUI_TEXTURE);
        this.func_73729_b(x, y, 0, 228, 26, 28);
    }

    @Override
    protected void func_146284_a(GuiButton b) {
        super.func_146284_a(b);
        if (b == this.dump1) {
            this.dump(1);
        } else if (b == this.dump2) {
            this.dump(2);
        }
    }

    private void dump(int i) {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketDumpTank(this.vat, i));
    }

    @Override
    protected int getPowerX() {
        return 10;
    }

    @Override
    protected int getPowerY() {
        return 13;
    }

    @Override
    protected int getPowerHeight() {
        return 60;
    }
}

