/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.tank;

import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.tank.FluidTankEio;
import crazypants.enderio.machine.tank.PacketTank;
import crazypants.enderio.network.PacketHandler;
import crazypants.util.BlockCoord;
import crazypants.util.FluidUtil;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileTank
extends AbstractMachineEntity
implements IFluidHandler {
    private static int IO_MB_TICK = 100;
    protected FluidTankEio tank;
    protected int lastUpdateLevel = -1;
    private boolean tankDirty = false;

    public TileTank(int meta) {
        super(new SlotDefinition(0, 1, 2, 3, -1, -1));
        this.tank = meta == 1 ? new FluidTankEio(32000) : new FluidTankEio(16000);
    }

    public TileTank() {
        super(new SlotDefinition(0, 1, 2, 3, -1, -1));
    }

    @Override
    protected boolean doPush(ForgeDirection dir) {
        BlockCoord loc;
        IFluidHandler target;
        if (this.isSideDisabled(dir.ordinal())) {
            return false;
        }
        boolean res = super.doPush(dir);
        if (this.tank.getFluidAmount() > 0 && (target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, loc = this.getLocation().getLocation(dir))) != null && target.canFill(dir.getOpposite(), this.tank.getFluid().getFluid())) {
            FluidStack push = this.tank.getFluid().copy();
            push.amount = Math.min(push.amount, IO_MB_TICK);
            int filled = target.fill(dir.getOpposite(), push, true);
            if (filled > 0) {
                this.tank.drain(filled, true);
                this.tankDirty = true;
                return res;
            }
        }
        return res;
    }

    @Override
    protected boolean doPull(ForgeDirection dir) {
        BlockCoord loc;
        IFluidHandler target;
        if (this.isSideDisabled(dir.ordinal())) {
            return false;
        }
        boolean res = super.doPull(dir);
        if (this.tank.getFluidAmount() < this.tank.getCapacity() && (target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, loc = this.getLocation().getLocation(dir))) != null) {
            if (this.tank.getFluidAmount() > 0) {
                FluidStack canPull = this.tank.getFluid().copy();
                canPull.amount = this.tank.getCapacity() - this.tank.getFluidAmount();
                canPull.amount = Math.min(canPull.amount, IO_MB_TICK);
                FluidStack drained = target.drain(dir.getOpposite(), canPull, true);
                if (drained != null && drained.amount > 0) {
                    this.tank.fill(drained, true);
                    this.tankDirty = true;
                    return res;
                }
            } else {
                FluidTankInfo[] infos = target.getTankInfo(dir.getOpposite());
                if (infos != null) {
                    for (FluidTankInfo info : infos) {
                        if (info.fluid == null || info.fluid.amount <= 0 || !this.canFill(dir, info.fluid.getFluid())) continue;
                        FluidStack canPull = info.fluid.copy();
                        canPull.amount = Math.min(IO_MB_TICK, canPull.amount);
                        FluidStack drained = target.drain(dir.getOpposite(), canPull, true);
                        if (drained == null || drained.amount <= 0) continue;
                        this.tank.fill(drained, true);
                        this.tankDirty = true;
                        return res;
                    }
                }
            }
        }
        return res;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int res = this.tank.fill(resource, doFill);
        if (res > 0 && doFill) {
            this.tankDirty = true;
        }
        return res;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        FluidStack res = this.tank.drain(resource, doDrain);
        if (res != null && res.amount > 0 && doDrain) {
            this.tankDirty = true;
        }
        return res;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack res = this.tank.drain(maxDrain, doDrain);
        if (res != null && res.amount > 0 && doDrain) {
            this.tankDirty = true;
        }
        return res;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid != null && (this.tank.getFluidAmount() > 0 && this.tank.getFluid().fluidID == fluid.getID() || this.tank.getFluidAmount() == 0);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tank.canDrainFluidType(fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.tank)};
    }

    private int getFilledLevel() {
        int level = (int)Math.floor(16.0f * this.tank.getFilledRatio());
        if (level == 0 && this.tank.getFluidAmount() > 0) {
            level = 1;
        }
        return level;
    }

    @Override
    public String getMachineName() {
        return "tank";
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack item) {
        if (i == 0) {
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)item);
            if (fluid != null) {
                return true;
            }
            if (item.func_77973_b() == Items.field_151131_as) {
                return true;
            }
            return item.func_77973_b() == Items.field_151129_at;
        }
        if (i == 1) {
            return FluidContainerRegistry.isEmptyContainer((ItemStack)item) || item.func_77973_b() == Items.field_151133_ar;
        }
        return false;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        boolean res = this.processItems(redstoneCheckPassed);
        int filledLevel = this.getFilledLevel();
        if (this.lastUpdateLevel != filledLevel) {
            this.lastUpdateLevel = filledLevel;
            this.tankDirty = false;
            return true;
        }
        if (this.tankDirty && this.field_145850_b.func_82737_E() % 10L == 0L) {
            PacketHandler.sendToAllAround(new PacketTank(this), this);
            this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            this.tankDirty = false;
        }
        return res;
    }

    public int getComparatorOutput() {
        FluidTankInfo info = this.getTankInfo(null)[0];
        return info == null || info.fluid == null ? 0 : (int)((double)info.fluid.amount / (double)info.capacity * 15.0);
    }

    private boolean processItems(boolean redstoneCheckPassed) {
        if (!redstoneCheckPassed) {
            return false;
        }
        if (this.field_145850_b.func_82737_E() % 20L != 0L) {
            return false;
        }
        return this.drainFullContainer() || this.fillEmptyContainer();
    }

    private boolean fillEmptyContainer() {
        ItemStack toFill = this.inventory[1];
        if (toFill == null) {
            return false;
        }
        if (this.tank.getFluidAmount() <= 0) {
            return false;
        }
        ItemStack filledItem = FluidContainerRegistry.fillFluidContainer((FluidStack)this.tank.getFluid(), (ItemStack)toFill);
        FluidStack filledFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledItem);
        if (filledFluid == null) {
            FluidContainerRegistry.FluidContainerData[] datas;
            for (FluidContainerRegistry.FluidContainerData data : datas = FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (!data.fluid.getFluid().getName().equals(this.tank.getFluid().getFluid().getName()) || !data.emptyContainer.func_77969_a(toFill)) continue;
                filledItem = data.filledContainer.func_77946_l();
                filledFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledItem);
            }
        }
        if (filledFluid == null || filledItem == null) {
            return false;
        }
        if (filledFluid.amount > this.tank.getFluidAmount()) {
            return false;
        }
        if (!(this.inventory[3] == null || this.inventory[3].func_77969_a(filledItem) && this.inventory[3].func_77976_d() >= this.inventory[3].field_77994_a + 1)) {
            return false;
        }
        this.tank.drain(filledFluid.amount, true);
        this.tankDirty = true;
        toFill = toFill.func_77946_l();
        --toFill.field_77994_a;
        if (toFill.field_77994_a == 0) {
            this.func_70299_a(1, null);
        } else {
            this.func_70299_a(1, toFill);
        }
        if (this.inventory[3] == null) {
            this.func_70299_a(3, filledItem);
        } else {
            ItemStack newStack = this.inventory[3].func_77946_l();
            ++newStack.field_77994_a;
            this.func_70299_a(3, newStack);
        }
        this.func_70296_d();
        return false;
    }

    private boolean drainFullContainer() {
        ItemStack fillFrom = this.inventory[0];
        if (fillFrom == null) {
            return false;
        }
        FluidStack fluid = FluidUtil.getFluidFromItem(fillFrom);
        if (fluid == null) {
            return false;
        }
        ItemStack emptyItem = FluidUtil.getEmptyContainer(fillFrom);
        if (!(emptyItem == null || this.inventory[2] == null || this.inventory[2].func_77969_a(emptyItem) && this.inventory[2].func_77976_d() >= this.inventory[2].field_77994_a + 1)) {
            return false;
        }
        int filled = this.fill(ForgeDirection.UP, fluid, false);
        if (filled < fluid.amount) {
            return false;
        }
        this.fill(ForgeDirection.UP, fluid, true);
        fillFrom = fillFrom.func_77946_l();
        --fillFrom.field_77994_a;
        if (fillFrom.field_77994_a == 0) {
            this.func_70299_a(0, null);
        } else {
            this.func_70299_a(0, fillFrom);
        }
        if (emptyItem == null) {
            return true;
        }
        if (this.inventory[2] == null) {
            this.func_70299_a(2, emptyItem);
        } else {
            ItemStack newStack = this.inventory[2].func_77946_l();
            ++newStack.field_77994_a;
            this.func_70299_a(2, newStack);
        }
        this.func_70296_d();
        return false;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return false;
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        nbtRoot.func_74768_a("tankType", this.func_145832_p());
        if (this.tank.getFluidAmount() > 0) {
            NBTTagCompound fluidRoot = new NBTTagCompound();
            this.tank.getFluid().writeToNBT(fluidRoot);
            nbtRoot.func_74782_a("tankContents", (NBTBase)fluidRoot);
        }
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        int tankType = nbtRoot.func_74762_e("tankType");
        tankType = MathHelper.func_76125_a((int)tankType, (int)0, (int)1);
        this.tank = tankType == 1 ? new FluidTankEio(32000) : new FluidTankEio(16000);
        if (nbtRoot.func_74764_b("tankContents")) {
            FluidStack fl = FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)nbtRoot.func_74781_a("tankContents")));
            this.tank.setFluid(fl);
        } else {
            this.tank.setFluid(null);
        }
    }

    @Override
    public boolean displayPower() {
        return false;
    }
}

