/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.ChannelType;
import crazypants.enderio.machine.transceiver.ConnectionHandler;
import crazypants.enderio.machine.transceiver.PacketAddRemoveChannel;
import crazypants.enderio.machine.transceiver.PacketChannelList;
import crazypants.enderio.machine.transceiver.PacketSendRecieveChannel;
import crazypants.enderio.machine.transceiver.PacketSendRecieveChannelList;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.machine.transceiver.gui.ContainerTransceiver;
import crazypants.enderio.machine.transceiver.gui.GuiTransceiver;
import crazypants.enderio.network.PacketHandler;
import crazypants.util.Lang;
import crazypants.util.Util;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class BlockTransceiver
extends AbstractMachineBlock<TileTransceiver> {
    public static BlockTransceiver create() {
        PacketHandler.INSTANCE.registerMessage(PacketSendRecieveChannel.class, PacketSendRecieveChannel.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketAddRemoveChannel.class, PacketAddRemoveChannel.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketAddRemoveChannel.class, PacketAddRemoveChannel.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketChannelList.class, PacketChannelList.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketSendRecieveChannelList.class, PacketSendRecieveChannelList.class, PacketHandler.nextID(), Side.CLIENT);
        ConnectionHandler ch = new ConnectionHandler();
        FMLCommonHandler.instance().bus().register((Object)ch);
        MinecraftForge.EVENT_BUS.register((Object)ch);
        BlockTransceiver res = new BlockTransceiver();
        res.init();
        return res;
    }

    private BlockTransceiver() {
        super(ModObject.blockTransceiver, TileTransceiver.class);
    }

    @Override
    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof TileTransceiver) {
            ((TileTransceiver)te).getRailController().dropNonSpawnedCarts();
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileTransceiver) {
            return new ContainerTransceiver(player.field_71071_by, (TileTransceiver)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return new GuiTransceiver(player.field_71071_by, (TileTransceiver)te);
    }

    @Override
    protected int getGuiId() {
        return 97;
    }

    @Override
    protected void registerOverlayIcons(IIconRegister iIconRegister) {
        this.overlayIconPull = iIconRegister.func_94245_a("enderio:transcieverOverlayPull");
        this.overlayIconPush = iIconRegister.func_94245_a("enderio:transcieverOverlayPush");
        this.overlayIconPushPull = iIconRegister.func_94245_a("enderio:transcieverOverlayPushPull");
        this.overlayIconDisabled = iIconRegister.func_94245_a("enderio:transcieverOverlayDisabled");
        this.overlayIconNone = iIconRegister.func_94245_a("enderio:machineOverlayNone");
        this.selectedFaceIcon = iIconRegister.func_94245_a("enderio:machineOverlaySelectedFace");
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        if (active) {
            return "enderio:alloySmelterFrontOn";
        }
        return "enderio:alloySmelterFront";
    }

    @Override
    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileTransceiver && player.func_70093_af()) {
            TileTransceiver trans = (TileTransceiver)te;
            for (ChannelType type : ChannelType.VALUES) {
                List<Channel> recieving = trans.getRecieveChannels(type);
                List<Channel> sending = trans.getSendChannels(type);
                String recieve = "[" + this.buildString(recieving) + "]";
                String send = "[" + this.buildString(sending) + "]";
                if (this.isEmpty(recieve) && this.isEmpty(send)) break;
                tooltip.add(EnumChatFormatting.WHITE + Lang.localize("trans." + type.name().toLowerCase()));
                if (!this.isEmpty(recieve)) {
                    tooltip.add(String.format("%s%s " + Util.TAB + ": %s%s", Util.TAB, Lang.localize("trans.recieving"), Util.TAB + Util.ALIGNRIGHT + EnumChatFormatting.WHITE, recieve));
                }
                if (this.isEmpty(send)) continue;
                tooltip.add(String.format("%s%s " + Util.TAB + ": %s%s", Util.TAB, Lang.localize("trans.sending"), Util.TAB + Util.ALIGNRIGHT + EnumChatFormatting.WHITE, send));
            }
        }
    }

    private boolean isEmpty(String str) {
        return "[]".equals(str);
    }

    private String buildString(List<Channel> channels) {
        StringBuilder sb = new StringBuilder();
        for (Channel c : channels) {
            sb.append(c.getName());
            if (channels.indexOf(c) == channels.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

