/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import crazypants.enderio.Log;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.ChannelRegister;
import crazypants.enderio.machine.transceiver.ChannelType;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.util.ItemUtil;
import crazypants.util.RoundRobinIterator;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.apache.commons.io.FileUtils;

public class ServerChannelRegister
extends ChannelRegister {
    public static ServerChannelRegister instance = new ServerChannelRegister();
    private final List<TileTransceiver> transceivers = new ArrayList<TileTransceiver>();
    private Map<Channel, RoundRobinIterator<TileTransceiver>> iterators = new HashMap<Channel, RoundRobinIterator<TileTransceiver>>();

    public static void load() {
        instance.reset();
        File dataFile = ServerChannelRegister.getDataFile();
        if (!dataFile.exists()) {
            dataFile = ServerChannelRegister.getFallbackDataFile();
            if (!dataFile.exists()) {
                return;
            }
            Log.warn("ServerChannelRegister: Using fallback save location " + dataFile.getAbsolutePath());
        }
        try {
            JsonReader reader = new JsonReader((Reader)new FileReader(ServerChannelRegister.getDataFile()));
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginObject();
                reader.nextName();
                String name = reader.nextString();
                String key = reader.nextName();
                String user = null;
                if ("user".equals(key)) {
                    user = reader.nextString();
                    reader.nextName();
                }
                int oridinal = reader.nextInt();
                Channel chan = new Channel(name, user, ChannelType.values()[oridinal]);
                instance.addChannel(chan);
                reader.endObject();
            }
            reader.endArray();
            reader.close();
        }
        catch (Exception e) {
            Log.error("Could not read Dimensional trasciever channels from " + ServerChannelRegister.getDataFile().getAbsolutePath() + " : " + e);
        }
    }

    public static void store() {
        File dataFile = ServerChannelRegister.getDataFile();
        if (!ServerChannelRegister.createFolderAndWriteFile(dataFile)) {
            dataFile = ServerChannelRegister.getFallbackDataFile();
            Log.error("ServerChannelRegister: Attempting to write Dimensional Trasciever data to fallback location: " + dataFile.getAbsolutePath());
            try {
                ServerChannelRegister.writeFile(dataFile);
            }
            catch (Exception e) {
                Log.error("ServerChannelRegister: Could not write Dimensional Trasciever data fallback location " + dataFile.getAbsolutePath() + " channles not saved: " + e.getMessage());
                return;
            }
        }
        Log.info("ServerChannelRegister: Dimensional Trasciever data saved to " + dataFile.getAbsolutePath());
    }

    protected static boolean createFolderAndWriteFile(File dataFile) {
        try {
            File parentFolder = dataFile.getParentFile();
            FileUtils.forceMkdir((File)parentFolder);
            ServerChannelRegister.writeFile(dataFile);
            return true;
        }
        catch (Exception e) {
            Log.error("ServerChannelRegister: Could not write Dimensional Trasciever channels to " + dataFile.getAbsolutePath() + " : " + e);
            return false;
        }
    }

    protected static void writeFile(File dataFile) throws IOException {
        JsonWriter writer = new JsonWriter((Writer)new FileWriter(dataFile, false));
        writer.setIndent("  ");
        writer.beginArray();
        for (List chanList : ServerChannelRegister.instance.channels.values()) {
            for (Channel chan : chanList) {
                writer.beginObject();
                writer.name("name").value(chan.getName());
                if (chan.getUser() != null) {
                    writer.name("user").value(chan.getUser());
                }
                writer.name("type").value((long)chan.getType().ordinal());
                writer.endObject();
            }
        }
        writer.endArray();
        writer.close();
    }

    private static File getDataFile() {
        return new File(DimensionManager.getCurrentSaveRootDirectory(), "enderio/dimensionalTransceiver.json");
    }

    private static File getFallbackDataFile() {
        return new File(DimensionManager.getCurrentSaveRootDirectory(), "dimensionalTransceiver.json");
    }

    private ServerChannelRegister() {
    }

    public void register(TileTransceiver transceiver) {
        this.transceivers.add(transceiver);
    }

    public void dergister(TileTransceiver transceiver) {
        this.transceivers.remove(transceiver);
    }

    @Override
    public void reset() {
        super.reset();
        this.transceivers.clear();
        this.iterators.clear();
    }

    @Override
    public void removeChannel(Channel channel) {
        super.removeChannel(channel);
        for (TileTransceiver trans : this.transceivers) {
            trans.removeRecieveChanel(channel);
            trans.removeSendChanel(channel);
        }
        this.iterators.remove(channel);
    }

    public RoundRobinIterator<TileTransceiver> getIterator(Channel channel) {
        RoundRobinIterator<TileTransceiver> res = this.iterators.get(channel);
        if (res == null) {
            res = new RoundRobinIterator<TileTransceiver>(this.transceivers);
            this.iterators.put(channel, res);
        }
        return res;
    }

    public void sendPower(TileTransceiver sender, int canSend, Channel channel) {
        RoundRobinIterator<TileTransceiver> iter = this.getIterator(channel);
        for (TileTransceiver trans : iter) {
            double invLoss;
            int canSendWithLoss;
            int recieved;
            if (trans == sender || !trans.getRecieveChannels(ChannelType.POWER).contains(channel) || (recieved = trans.receiveEnergy(ForgeDirection.UNKNOWN, canSendWithLoss = (int)Math.round((double)canSend * (invLoss = 1.0 - Config.transceiverEnergyLoss)), false)) <= 0) continue;
            int recievedPlusLoss = (int)Math.round((double)recieved / invLoss);
            sender.usePower(recievedPlusLoss);
        }
    }

    public FluidTankInfo[] getTankInfoForChannels(TileTransceiver tileTransceiver, List<Channel> channels) {
        ArrayList<FluidTankInfo> infos = new ArrayList<FluidTankInfo>();
        for (TileTransceiver tran : this.transceivers) {
            if (tran == tileTransceiver) continue;
            tran.getRecieveTankInfo(infos, channels);
        }
        return infos.toArray(new FluidTankInfo[infos.size()]);
    }

    public boolean canFill(TileTransceiver tileTransceiver, List<Channel> channels, Fluid fluid) {
        for (TileTransceiver tran : this.transceivers) {
            if (tran == tileTransceiver || !tran.canReceive(channels, fluid)) continue;
            return true;
        }
        return false;
    }

    public int fill(TileTransceiver from, List<Channel> list, FluidStack resource, boolean doFill) {
        if (resource == null || !from.hasPower()) {
            return 0;
        }
        for (Channel channel : list) {
            RoundRobinIterator<TileTransceiver> iter = this.getIterator(channel);
            for (TileTransceiver trans : iter) {
                int val;
                if (trans == from || (val = trans.recieveFluid(list, resource, doFill)) <= 0) continue;
                if (doFill && Config.transceiverBucketTransmissionCostRF > 0) {
                    int powerUsed = (int)Math.max(1.0, (double)(Config.transceiverBucketTransmissionCostRF * val) / 1000.0);
                    from.usePower(powerUsed);
                }
                return val;
            }
        }
        return 0;
    }

    public void sendItem(TileTransceiver from, List<Channel> channels, int slot, ItemStack contents) {
        if (!from.hasPower()) {
            return;
        }
        for (Channel channel : channels) {
            RoundRobinIterator<TileTransceiver> iter = this.getIterator(channel);
            for (TileTransceiver trans : iter) {
                if (trans == from || !trans.getRecieveChannels(ChannelType.ITEM).contains(channel) || !trans.getRedstoneChecksPassed() || (contents = this.sendItem(from, slot, contents, trans)) != null) continue;
                return;
            }
        }
    }

    private ItemStack sendItem(TileTransceiver from, int slot, ItemStack contents, TileTransceiver to) {
        ItemStack existing;
        int i;
        SlotDefinition sd = to.getSlotDefinition();
        boolean sendComplete = false;
        for (i = sd.minOutputSlot; i <= sd.maxOutputSlot && !sendComplete; ++i) {
            ItemStack remaining;
            existing = to.func_70301_a(i);
            if (!ItemUtil.areStacksEqual(existing, contents)) continue;
            sendComplete = true;
            int numCanMerge = existing.func_77976_d() - existing.field_77994_a;
            if ((numCanMerge = Math.min(numCanMerge, contents.field_77994_a)) >= contents.field_77994_a) {
                remaining = null;
            } else {
                remaining = contents.func_77946_l();
                remaining.field_77994_a -= numCanMerge;
            }
            ItemStack destStack = existing.func_77946_l();
            destStack.field_77994_a += numCanMerge;
            to.func_70299_a(i, destStack);
            from.func_70299_a(slot, remaining);
            if (remaining == null) {
                return null;
            }
            contents = remaining.func_77946_l();
        }
        if (!sendComplete) {
            for (i = sd.minOutputSlot; i <= sd.maxOutputSlot; ++i) {
                existing = to.func_70301_a(i);
                if (existing != null) continue;
                to.func_70299_a(i, contents.func_77946_l());
                from.func_70299_a(slot, null);
                return null;
            }
        }
        return contents;
    }
}

